/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SellPropositionMessage
extends Message {
    private String unitId;
    private String settlementId;
    private Goods goods;
    private String goldString;

    public SellPropositionMessage(Unit unit, Settlement settlement, Goods goods, int gold) {
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
        this.goods = goods;
        this.goldString = Integer.toString(gold);
    }

    public SellPropositionMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
        this.goldString = element.getAttribute("gold");
        this.goods = new Goods(game, Message.getChildElement(element, Goods.getXMLElementTagName()));
    }

    public int getGold() {
        try {
            return Integer.parseInt(this.goldString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int gold;
        IndianSettlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
            settlement = server.getAdjacentIndianSettlementSafely(this.settlementId, unit);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (this.goods.getLocation() != unit) {
            return Message.createError("server.trade.noGoods", "Goods " + this.goods.getId() + " are not with unit " + this.unitId);
        }
        try {
            gold = Integer.parseInt(this.goldString);
        }
        catch (NumberFormatException e) {
            return Message.clientError("Bad gold: " + this.goldString);
        }
        return server.getInGameController().sellProposition(serverPlayer, unit, settlement, this.goods, gold);
    }

    public Element toXMLElement() {
        Element result = SellPropositionMessage.createNewRootElement(SellPropositionMessage.getXMLElementTagName());
        Document doc = result.getOwnerDocument();
        result.setAttribute("unit", this.unitId);
        result.setAttribute("settlement", this.settlementId);
        result.appendChild(this.goods.toXMLElement(null, doc));
        result.setAttribute("gold", this.goldString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "sellProposition";
    }
}

