/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIMain;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsMessage
extends Message {
    private HashMap<String, Long> memoryStats = null;
    private HashMap<String, Long> gameStats = null;
    private HashMap<String, Long> aiStats = null;

    public StatisticsMessage(Game game, AIMain aiMain) {
        this.memoryStats = new HashMap();
        System.gc();
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        long max = Runtime.getRuntime().maxMemory() / 0x100000L;
        this.memoryStats.put(Messages.message("menuBar.debug.memoryManager.free"), new Long(free));
        this.memoryStats.put(Messages.message("menuBar.debug.memoryManager.total"), new Long(total));
        this.memoryStats.put(Messages.message("menuBar.debug.memoryManager.max"), new Long(max));
        this.gameStats = new HashMap();
        Iterator<FreeColGameObject> iter = game.getFreeColGameObjectIterator();
        this.gameStats.put("disposed", new Long(0L));
        while (iter.hasNext()) {
            Long l;
            Long l2;
            Long count;
            FreeColGameObject obj = iter.next();
            String className = obj.getClass().getSimpleName();
            if (this.gameStats.containsKey(className)) {
                l2 = count = this.gameStats.get(className);
                l = count = Long.valueOf(count + 1L);
                this.gameStats.put(className, count);
            } else {
                count = new Long(1L);
                this.gameStats.put(className, count);
            }
            if (!obj.isDisposed()) continue;
            l2 = count = this.gameStats.get("disposed");
            l = count = Long.valueOf(count + 1L);
            this.gameStats.put("disposed", count);
        }
        if (aiMain != null) {
            this.aiStats = aiMain.getAIStatistics();
        }
    }

    public StatisticsMessage(Element element) {
        this.readFromXML(element);
    }

    public final HashMap<String, Long> getGameStatistics() {
        return this.gameStats;
    }

    public final HashMap<String, Long> getAIStatistics() {
        return this.aiStats;
    }

    public final HashMap<String, Long> getMemoryStatistics() {
        return this.memoryStats;
    }

    public void readFromXML(Element element) {
        Element aiElement;
        Element gameElement;
        if (!element.getTagName().equals(StatisticsMessage.getXMLElementTagName())) {
            return;
        }
        Element memoryElement = (Element)element.getElementsByTagName("memoryStatistics").item(0);
        if (memoryElement != null) {
            this.memoryStats = new HashMap();
            NamedNodeMap atts = memoryElement.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                this.memoryStats.put(atts.item(i).getNodeName(), new Long(atts.item(i).getNodeValue()));
            }
        }
        if ((gameElement = (Element)element.getElementsByTagName("gameStatistics").item(0)) != null) {
            this.gameStats = new HashMap();
            NamedNodeMap atts = gameElement.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                this.gameStats.put(atts.item(i).getNodeName(), new Long(atts.item(i).getNodeValue()));
            }
        }
        if ((aiElement = (Element)element.getElementsByTagName("aiStatistics").item(0)) != null) {
            this.aiStats = new HashMap();
            NamedNodeMap atts = aiElement.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                this.aiStats.put(atts.item(i).getNodeName(), new Long(atts.item(i).getNodeValue()));
            }
        }
    }

    @Override
    public Element toXMLElement() {
        Element result = StatisticsMessage.createNewRootElement(StatisticsMessage.getXMLElementTagName());
        Element memoryElement = result.getOwnerDocument().createElement("memoryStatistics");
        result.appendChild(memoryElement);
        for (String s : this.memoryStats.keySet()) {
            memoryElement.setAttribute(s, this.memoryStats.get(s).toString());
        }
        Element gameElement = result.getOwnerDocument().createElement("gameStatistics");
        result.appendChild(gameElement);
        for (String s : this.gameStats.keySet()) {
            gameElement.setAttribute(s, this.gameStats.get(s).toString());
        }
        Element aiElement = result.getOwnerDocument().createElement("aiStatistics");
        result.appendChild(aiElement);
        for (String s : this.aiStats.keySet()) {
            aiElement.setAttribute(s, this.aiStats.get(s).toString());
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "statistics";
    }
}

