/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.SetTradeRoutesMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateTradeRouteMessage
extends Message {
    private TradeRoute tradeRoute;

    public UpdateTradeRouteMessage(TradeRoute tradeRoute) {
        this.tradeRoute = tradeRoute;
    }

    public UpdateTradeRouteMessage(Game game, Element element) {
        this.tradeRoute = element.getChildNodes().getLength() != 1 ? null : SetTradeRoutesMessage.tradeRouteFromElement(game, (Element)element.getChildNodes().item(0));
    }

    public Element handle(FreeColServer server, Connection connection) {
        ServerGame game = server.getGame();
        ServerPlayer serverPlayer = server.getPlayer(connection);
        if (this.tradeRoute == null || this.tradeRoute.getId() == null || !SetTradeRoutesMessage.hasPrefix(this.tradeRoute)) {
            return Message.clientError("Bogus route");
        }
        String id = SetTradeRoutesMessage.removePrefix(this.tradeRoute);
        if (!(game.getFreeColGameObject(id) instanceof TradeRoute)) {
            return Message.clientError("Not a trade route: " + id);
        }
        TradeRoute realRoute = (TradeRoute)game.getFreeColGameObject(id);
        if (this.tradeRoute.getOwner() != serverPlayer) {
            return Message.clientError("Not your trade route: " + id);
        }
        realRoute.updateFrom(this.tradeRoute);
        this.tradeRoute.dispose();
        return null;
    }

    public Element toXMLElement() {
        Element result = UpdateTradeRouteMessage.createNewRootElement(UpdateTradeRouteMessage.getXMLElementTagName());
        Document doc = result.getOwnerDocument();
        result.appendChild(this.tradeRoute.toXMLElement(null, doc));
        return result;
    }

    public static String getXMLElementTagName() {
        return "updateTradeRoute";
    }
}

