/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageOption
extends AbstractOption<Language> {
    private static Logger logger = Logger.getLogger(LanguageOption.class.getName());
    private static final Map<String, Language> languages = new HashMap<String, Language>();
    public static final String AUTO = "automatic";
    private Language DEFAULT = new Language("automatic", LanguageOption.getLocale("automatic"));
    private Map<String, String> languageNames = new HashMap<String, String>();
    private static final String[][] languageNamesHelper = new String[][]{{"arz", "\u0645\u0635\u0631\u064a"}, {"hsb", "Serb\u0161\u0107ina"}, {"nds", "Plattd\u00fc\u00fctsch"}, {"pms", "Piemont\u00e9s"}, {"be-tarask", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f (\u0442\u0430\u0440\u0430\u0448\u043a\u0435\u0432\u0456\u0446\u0430)"}};
    private static Comparator<Language> languageComparator = new Comparator<Language>(){

        @Override
        public int compare(Language l1, Language l2) {
            if (l1.getKey().equals(LanguageOption.AUTO)) {
                if (l2.getKey().equals(LanguageOption.AUTO)) {
                    return 0;
                }
                return -1;
            }
            if (l2.getKey().equals(LanguageOption.AUTO)) {
                return 1;
            }
            return l1.toString().compareTo(l2.toString());
        }
    };
    private Language value;

    public LanguageOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        if (languages.size() == 0) {
            this.prepareLanguages();
        }
        this.readFromXML(in);
    }

    private void prepareLanguages() {
        for (String[] pair : languageNamesHelper) {
            this.languageNames.put(pair[0], pair[1]);
        }
    }

    @Override
    public final Language getValue() {
        return this.value;
    }

    @Override
    public final void setValue(Language newValue) {
        Language oldValue = this.value;
        this.value = newValue;
        if (!newValue.equals(oldValue)) {
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    public Language[] getOptions() {
        this.findLanguages();
        ArrayList<Language> names = new ArrayList<Language>(languages.values());
        Collections.sort(names, languageComparator);
        return names.toArray(new Language[0]);
    }

    private void findLanguages() {
        languages.put(AUTO, this.DEFAULT);
        File i18nDirectory = new File(FreeCol.getDataDirectory(), "strings");
        File[] files = i18nDirectory.listFiles();
        if (files == null) {
            throw new RuntimeException("No language files could be found in the <" + i18nDirectory + "> folder. Make sure you ran the ant correctly.");
        }
        String prefix = "FreeColMessages_";
        int prefixLength = prefix.length();
        for (File file : files) {
            if (file.getName() == null || !file.getName().startsWith(prefix)) continue;
            try {
                String languageID = file.getName().substring(prefixLength, file.getName().indexOf("."));
                if ("qqq".equals(languageID)) continue;
                languages.put(languageID, new Language(languageID, LanguageOption.getLocale(languageID)));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception in findLanguages()", e);
            }
        }
    }

    public static Locale getLocale(String languageID) {
        if (languageID == null || AUTO.equals(languageID)) {
            return Locale.getDefault();
        }
        try {
            String country = "";
            String variant = "";
            StringTokenizer st = new StringTokenizer(languageID, "_", true);
            String language = st.nextToken();
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            if (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equals("_")) {
                    country = token;
                }
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (token.equals("_") && st.hasMoreTokens()) {
                        token = st.nextToken();
                    }
                    if (!token.equals("_")) {
                        variant = token;
                    }
                }
            }
            return new Locale(language, country, variant);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot choose locale: " + languageID, e);
            return Locale.getDefault();
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(LanguageOption.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("value", this.getValue().getKey());
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        Language newValue;
        String id = in.getAttributeValue(null, "id");
        this.findLanguages();
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + LanguageOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        if ((newValue = languages.get(in.getAttributeValue(null, "value"))) == null) {
            newValue = languages.get(AUTO);
        }
        this.setValue(newValue);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "languageOption";
    }

    public class Language {
        private String key;
        private Locale locale;

        public Language(String key, Locale locale) {
            this.key = key;
            this.locale = locale;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String newKey) {
            this.key = newKey;
        }

        public final Locale getLocale() {
            return this.locale;
        }

        public final void setLocale(Locale newLocale) {
            this.locale = newLocale;
        }

        public String toString() {
            if (this.getKey().equals(LanguageOption.AUTO)) {
                return Messages.message("clientOptions.gui.languageOption.autoDetectLanguage");
            }
            String name = this.locale.getDisplayName(this.locale);
            if (name.equals(this.key) && LanguageOption.this.languageNames.containsKey(this.key)) {
                name = (String)LanguageOption.this.languageNames.get(this.key);
            }
            return name.substring(0, 1).toUpperCase(this.locale) + name.substring(1);
        }

        public boolean equals(Object o) {
            return o instanceof Language && ((Language)o).getKey().equals(this.key);
        }
    }
}

