/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringOption
extends AbstractOption<String> {
    private static Logger logger = Logger.getLogger(StringOption.class.getName());
    public static final String NONE = "none";
    private String value;
    private boolean addNone;
    private Generate generateChoices;
    private List<String> choices;

    public StringOption(String id) {
        super(id);
    }

    public StringOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXMLImpl(in);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        String oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    public final boolean addNone() {
        return this.addNone;
    }

    public final void setAddNone(boolean newAddNone) {
        this.addNone = newAddNone;
    }

    public final List<String> getChoices() {
        return this.choices;
    }

    public final void setChoices(List<String> newChoices) {
        this.choices = newChoices;
    }

    public final Generate getGenerateChoices() {
        return this.generateChoices;
    }

    public final void setGenerateChoices(Generate newGenerateChoices) {
        this.generateChoices = newGenerateChoices;
    }

    public void generateChoices(Specification specification) {
        if (this.generateChoices == null) {
            if (this.choices == null || this.choices.isEmpty()) {
                this.choices = new ArrayList<String>();
                this.choices.add(this.getValue());
            }
        } else {
            ArrayList<FreeColGameObjectType> objects = new ArrayList<FreeColGameObjectType>();
            switch (this.generateChoices) {
                case UNITS: {
                    objects.addAll(specification.getUnitTypeList());
                    break;
                }
                case IMMIGRANTS: {
                    for (UnitType unitType : specification.getUnitTypeList()) {
                        if (!unitType.isRecruitable()) continue;
                        objects.add(unitType);
                    }
                    break;
                }
                case NAVAL_UNITS: {
                    for (UnitType unitType : specification.getUnitTypeList()) {
                        if (!unitType.hasAbility("model.ability.navalUnit")) continue;
                        objects.add(unitType);
                    }
                    break;
                }
                case LAND_UNITS: {
                    for (UnitType unitType : specification.getUnitTypeList()) {
                        if (unitType.hasAbility("model.ability.navalUnit")) continue;
                        objects.add(unitType);
                    }
                    break;
                }
                case BUILDINGS: {
                    objects.addAll(specification.getBuildingTypeList());
                    break;
                }
                case FOUNDING_FATHERS: {
                    objects.addAll(specification.getFoundingFathers());
                }
            }
            this.choices = new ArrayList<String>(objects.size() + (this.addNone ? 1 : 0));
            if (this.addNone) {
                this.choices.add(NONE);
            }
            for (FreeColObject freeColObject : objects) {
                this.choices.add(freeColObject.getId());
            }
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(StringOption.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("value", this.value);
        if (this.generateChoices != null) {
            out.writeAttribute("generate", this.generateChoices.toString());
        }
        if (this.addNone) {
            out.writeAttribute("addNone", Boolean.toString(this.addNone));
        }
        if (this.choices != null && !this.choices.isEmpty()) {
            for (String choice : this.choices) {
                out.writeStartElement("choice");
                out.writeAttribute("value", choice);
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        String defaultValue = in.getAttributeValue(null, "defaultValue");
        String value = in.getAttributeValue(null, "value");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + StringOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (defaultValue == null && value == null) {
            throw new XMLStreamException("invalid <" + StringOption.getXMLElementTagName() + "> tag : no value nor default value found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        if (value != null) {
            this.setValue(value);
        } else {
            this.setValue(defaultValue);
        }
        this.addNone = StringOption.getAttribute(in, "addNone", false);
        String generate = in.getAttributeValue(null, "generate");
        if (generate != null) {
            this.generateChoices = Enum.valueOf(Generate.class, generate);
        }
        this.choices = new ArrayList<String>();
        while (in.nextTag() != 2) {
            if (!"choice".equals(in.getLocalName())) continue;
            this.choices.add(in.getAttributeValue(null, "value"));
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "stringOption";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Generate {
        UNITS,
        IMMIGRANTS,
        LAND_UNITS,
        NAVAL_UNITS,
        BUILDINGS,
        FOUNDING_FATHERS;

    }
}

