/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;

public class REFAIPlayer
extends EuropeanAIPlayer {
    private static final Logger logger = Logger.getLogger(REFAIPlayer.class.getName());

    public void startWorking() {
        logger.fine("Entering AI code for: " + this.getPlayer() + ", year " + this.getGame().getTurn());
        this.sessionRegister.clear();
        this.clearAIUnits();
        if (!this.getPlayer().isWorkForREF()) {
            return;
        }
        this.determineStances();
        this.rearrangeWorkersInColonies();
        this.abortInvalidAndOneTimeMissions();
        this.ensureCorrectMissions();
        this.giveNavalMissions();
        this.secureSettlements();
        this.giveNormalMissions();
        this.createAIGoodsInColonies();
        this.createTransportLists();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.giveNormalMissions();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.ensureCorrectMissions();
        this.clearAIUnits();
    }

    private void giveNormalMissions() {
        logger.finest("Entering method giveNormalMissions");
        HashMap<UnitType, ArrayList<Wish>> workerWishes = new HashMap<UnitType, ArrayList<Wish>>();
        if (this.getPlayer().isEuropean()) {
            Iterator<AIColony> aIterator = this.getAIColonyIterator();
            while (aIterator.hasNext()) {
                Iterator<Wish> wIterator = aIterator.next().getWishIterator();
                while (wIterator.hasNext()) {
                    Wish w = wIterator.next();
                    if (!(w instanceof WorkerWish) || w.getTransportable() != null) continue;
                    UnitType unitType = ((WorkerWish)w).getUnitType();
                    ArrayList<Wish> wishes = (ArrayList<Wish>)workerWishes.get(unitType);
                    if (wishes == null) {
                        wishes = new ArrayList<Wish>();
                        workerWishes.put(unitType, wishes);
                    }
                    wishes.add(w);
                }
            }
        }
        boolean fewColonies = this.hasFewColonies();
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.hasMission()) continue;
            Unit unit = aiUnit.getUnit();
            if (unit.isUninitialized()) {
                logger.warning("Trying to assign a mission to an uninitialized object: " + unit.getId());
                continue;
            }
            EquipmentType toolsType = this.getGame().getSpecification().getEquipmentType("model.equipment.tools");
            if (unit.canCarryTreasure()) {
                aiUnit.setMission(new CashInTreasureTrainMission(this.getAIMain(), aiUnit));
            } else if (unit.hasAbility("model.ability.scoutIndianSettlement") && ScoutingMission.isValid(aiUnit)) {
                aiUnit.setMission(new ScoutingMission(this.getAIMain(), aiUnit));
            } else if ((unit.isOffensiveUnit() || unit.isDefensiveUnit()) && (!unit.isColonist() || unit.hasAbility("model.ability.expertSoldier") || this.getGame().getTurn().getNumber() > 5)) {
                this.giveMilitaryMission(aiUnit);
            } else if (unit.getEquipment().containsKey(toolsType) && PioneeringMission.isValid(aiUnit)) {
                aiUnit.setMission(new PioneeringMission(this.getAIMain(), aiUnit));
            } else if (unit.isColonist()) {
                HashMap<Location, Integer> distances = new HashMap<Location, Integer>(121);
                for (ArrayList al : workerWishes.values()) {
                    for (Wish w : al) {
                        if (distances.containsKey(w.getDestination())) continue;
                        distances.put(w.getDestination(), unit.getTurnsToReach(w.getDestination()));
                    }
                }
                ArrayList wishList = (ArrayList)workerWishes.get(unit.getType());
                Wish bestWish = null;
                int bestTurns = Integer.MAX_VALUE;
                for (int i = 0; i < wishList.size(); ++i) {
                    WorkerWish ww = (WorkerWish)wishList.get(i);
                    if (ww.getTransportable() != null) {
                        wishList.remove(i);
                        --i;
                        continue;
                    }
                    int turns = (Integer)distances.get(ww.getDestination());
                    if (turns == Integer.MAX_VALUE) {
                        turns = ww.getDestination().getTile() == null ? 5 : 10;
                    } else if (turns > 5) {
                        turns = 5;
                    }
                    if (bestWish != null && ww.getValue() - turns * 2 <= bestWish.getValue() - bestTurns * 2) continue;
                    bestWish = ww;
                    bestTurns = turns;
                }
                if (bestWish != null) {
                    bestWish.setTransportable(aiUnit);
                    aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, bestWish));
                    continue;
                }
                Tile colonyTile = null;
                if (this.getPlayer().canBuildColonies()) {
                    colonyTile = BuildColonyMission.findColonyLocation(aiUnit.getUnit());
                }
                if (colonyTile != null) {
                    bestTurns = unit.getTurnsToReach(colonyTile);
                }
                if (!fewColonies || colonyTile == null || bestTurns > 10) {
                    for (ArrayList wishes : workerWishes.values()) {
                        for (int j = 0; j < wishes.size(); ++j) {
                            WorkerWish ww = (WorkerWish)wishes.get(j);
                            if (ww.getTransportable() != null) {
                                wishes.remove(j);
                                --j;
                                continue;
                            }
                            int turns = (Integer)distances.get(ww.getDestination());
                            if (turns == Integer.MAX_VALUE) {
                                turns = ww.getDestination().getTile() == null ? 5 : 10;
                            } else if (turns > 5) {
                                turns = 5;
                            }
                            if (bestWish != null && ww.getValue() - turns * 2 <= bestWish.getValue() - bestTurns * 2) continue;
                            bestWish = ww;
                            bestTurns = turns;
                        }
                    }
                }
                if (bestWish != null) {
                    bestWish.setTransportable(aiUnit);
                    aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, bestWish));
                    continue;
                }
                if (colonyTile != null) {
                    BuildColonyMission mission = new BuildColonyMission(this.getAIMain(), aiUnit, colonyTile, this.getPlayer().getColonyValue(colonyTile));
                    aiUnit.setMission(mission);
                    boolean isUnitOnCarrier = aiUnit.getUnit().isOnCarrier();
                    if (!isUnitOnCarrier) continue;
                    AIUnit carrier = this.getAIUnit((Unit)aiUnit.getUnit().getLocation());
                    Mission carrierMission = carrier.getMission();
                    boolean isCarrierMissionToTransport = carrierMission instanceof TransportMission;
                    if (!isCarrierMissionToTransport) {
                        throw new IllegalStateException("Carrier carrying unit not on a transport mission");
                    }
                    ((TransportMission)carrierMission).addToTransportList(aiUnit);
                    continue;
                }
            }
            if (aiUnit.hasMission()) continue;
            aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
        }
    }

    public boolean acceptIndianDemand(Unit unit, Colony colony, Goods goods, int gold) {
        return false;
    }
}

