/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class ServerEurope
extends Europe
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerEurope.class.getName());

    public ServerEurope(Game game, String id) {
        super(game, id);
    }

    public ServerEurope(Game game, Player owner) {
        super(game, owner);
    }

    public void initializeMigration(Random random) {
        Specification spec = this.getGame().getSpecification();
        ServerPlayer player = (ServerPlayer)this.getOwner();
        List recruits = player.generateRecruitablesList();
        for (int index = 0; index < 3; ++index) {
            String unitTypeId;
            String optionId = "model.option.recruitable.slot" + index;
            if (spec.hasOption(optionId) && !"none".equals(unitTypeId = spec.getStringOption(optionId).getValue())) {
                this.setRecruitable(index, spec.getUnitType(unitTypeId));
                continue;
            }
            this.setRecruitable(index, (UnitType)RandomChoice.getWeightedRandom(null, null, random, recruits));
        }
    }

    public void increasePrice(UnitType unitType, int price) {
        int increase;
        Specification spec = this.getSpecification();
        String baseOption = "model.option.priceIncreasePerType";
        String name = unitType.getId().substring(unitType.getId().lastIndexOf(46));
        String option = spec.getBooleanOption(baseOption).getValue() != false ? "model.option.priceIncrease" + name : "model.option.priceIncrease";
        int n = increase = spec.hasOption(option) ? spec.getIntegerOption(option).getValue() : 0;
        if (increase != 0) {
            this.unitPrices.put(unitType, new Integer(price + increase));
        }
    }

    public void csNewTurn(Random random, ChangeSet cs) {
        logger.finest("ServerEurope.csNewTurn, for " + this.toString());
        for (Unit unit : this.getUnitList()) {
            if (!unit.isNaval() || !unit.isUnderRepair()) continue;
            ((ServerUnit)unit).csRepairUnit(cs);
        }
    }

    public String getServerXMLElementTagName() {
        return "serverEurope";
    }
}

