/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerIndianSettlement
extends IndianSettlement
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerIndianSettlement.class.getName());
    public static final int MAX_HORSES_PER_TURN = 2;

    public ServerIndianSettlement(Game game, String id) {
        super(game, id);
    }

    public ServerIndianSettlement(Game game, Player owner, String name, Tile tile, boolean isCapital, UnitType learnableSkill, Set<Player> spokenTo, Unit missionary) {
        super(game, owner, name, tile);
        this.goodsContainer = new GoodsContainer(game, this);
        this.learnableSkill = learnableSkill;
        this.setCapital(isCapital);
        this.spokenTo = spokenTo;
        this.missionary = missionary;
        this.convertProgress = 0;
        this.updateWantedGoods();
    }

    @Override
    public void csNewTurn(Random random, ChangeSet cs) {
        logger.finest("ServerIndianSettlement.csNewTurn, for " + this.toString());
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        Specification spec = this.getSpecification();
        List<GoodsType> goodsList = spec.getGoodsTypeList();
        for (GoodsType g : goodsList) {
            this.addGoods(g.getStoredAs(), this.getProductionOf(g));
        }
        GoodsType tools = spec.getGoodsType("model.goods.tools");
        if (this.getGoodsCount(tools) > 0) {
            GoodsType typeWithSmallestAmount = null;
            for (GoodsType g : goodsList) {
                if (g.isFoodType() || g.isBuildingMaterial() || g.isRawBuildingMaterial() || !g.isRawMaterial() || this.getGoodsCount(g) <= 50 || typeWithSmallestAmount != null && this.getGoodsCount(g.getProducedMaterial()) >= this.getGoodsCount(typeWithSmallestAmount)) continue;
                typeWithSmallestAmount = g.getProducedMaterial();
            }
            if (typeWithSmallestAmount != null) {
                int production = Math.min(this.getGoodsCount(typeWithSmallestAmount.getRawMaterial()), Math.min(10, this.getGoodsCount(tools)));
                this.removeGoods(tools, production);
                this.removeGoods(typeWithSmallestAmount.getRawMaterial(), production);
                this.addGoods(typeWithSmallestAmount, production * 5);
            }
        }
        for (GoodsType g : goodsList) {
            this.consumeGoods(g, this.getConsumptionOf(g));
        }
        this.getGoodsContainer().removeAbove(500);
        GoodsType foodType = spec.getPrimaryFoodType();
        GoodsType rumType = spec.getGoodsType("model.goods.rum");
        List<UnitType> unitTypes = spec.getUnitTypesWithAbility("model.ability.bornInIndianSettlement");
        if (!unitTypes.isEmpty() && this.getGoodsCount(foodType) + 4 * this.getGoodsCount(rumType) > 250 && this.ownedUnits.size() <= this.getType().getMaximumSize()) {
            UnitType type = Utils.getRandomMember(logger, "Choose birth", unitTypes, random);
            ServerUnit unit = new ServerUnit(this.getGame(), this.getTile(), owner, type, Unit.UnitState.ACTIVE);
            this.consumeGoods(foodType, 200);
            this.consumeGoods(rumType, 50);
            this.addOwnedUnit(unit);
            unit.setIndianSettlement(this);
            logger.info("New native created in " + this.getName() + " with ID=" + unit.getId());
        }
        GoodsType horsesType = spec.getGoodsType("model.goods.horses");
        GoodsType grainType = spec.getGoodsType("model.goods.grain");
        int foodProdAvail = this.getProductionOf(grainType) - this.getFoodConsumption();
        if (this.getGoodsCount(horsesType) >= horsesType.getBreedingNumber() && foodProdAvail > 0) {
            int nHorses = Math.min(2, foodProdAvail);
            this.addGoods(horsesType, nHorses);
            logger.finest("Settlement " + this.getName() + " bred " + nHorses);
        }
        this.updateWantedGoods();
    }

    private void consumeGoods(GoodsType type, int amount) {
        if (this.getGoodsCount(type) > 0) {
            amount = Math.min(amount, this.getGoodsCount(type));
            this.removeGoods(type, amount);
        }
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverIndianSettlement";
    }
}

