/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FlagTest
extends JFrame {
    private static final int[][] layout = new int[51][2];

    public FlagTest() {
        super("FlagTest");
        JPanel panel = new JPanel(new GridLayout(0, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
        for (int states = 1; states < 51; ++states) {
            Flag flag = new Flag(states, Math.min(13, states));
            JLabel label = new JLabel(new ImageIcon(flag.getImage()));
            panel.add(label);
        }
        this.add(scrollPane);
    }

    public static void main(String[] args) {
        FlagTest frame = new FlagTest();
        frame.pack();
        frame.setVisible(true);
    }

    static {
        for (int[] bars : new int[][]{{5, 4}, {5, 6}, {6, 5}}) {
            int sum = bars[0] + bars[1];
            boolean even = true;
            while (sum < 51) {
                FlagTest.layout[sum] = bars;
                if (even) {
                    sum += bars[0];
                    even = false;
                    continue;
                }
                sum += bars[1];
                even = true;
            }
        }
    }

    public class Flag {
        private static final double width = 100.0;
        private static final double length = 190.0;
        private static final double unionLength = 76.0;
        private static final double star = 6.16;
        private double unionWidth;
        private final Color red = new Color(0.698f, 0.132f, 0.203f);
        private final Color blue = new Color(0.234f, 0.233f, 0.43f);
        private BufferedImage image = new BufferedImage(190, 100, 1);

        public Flag(int stars, int stripes) {
            GeneralPath unionPath;
            Graphics2D g = this.image.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.red);
            Rectangle2D.Double background = new Rectangle2D.Double(0.0, 0.0, 190.0, 100.0);
            g.fill(background);
            g.setColor(Color.WHITE);
            double stripeWidth = 100.0 / (double)stripes;
            Rectangle2D.Double stripe = new Rectangle2D.Double(0.0, 0.0, 190.0, stripeWidth);
            AffineTransform transform = g.getTransform();
            for (int i = 0; i < stripes / 2; ++i) {
                g.translate(0.0, stripeWidth);
                g.fill(stripe);
                g.translate(0.0, stripeWidth);
            }
            g.setTransform(transform);
            g.setColor(this.blue);
            this.unionWidth = stripes == 1 ? stripeWidth / 2.0 : stripeWidth * Math.ceil((double)stripes / 2.0);
            Rectangle2D.Double union = new Rectangle2D.Double(0.0, 0.0, 76.0, this.unionWidth);
            g.fill(union);
            if (stars == 1) {
                unionPath = this.getPentagram();
            } else if (stars == 2) {
                unionPath = new GeneralPath();
                unionPath.append(this.getPentagram(), false);
                GeneralPath newStar = this.getPentagram();
                newStar.transform(AffineTransform.getTranslateInstance(25.333333333333332, 0.0));
                unionPath.append(newStar, false);
            } else {
                unionPath = stars < 14 ? this.getCircleOfStars(stars) : this.getGrid(stars);
            }
            unionPath.transform(AffineTransform.getTranslateInstance(-unionPath.getBounds().getX(), -unionPath.getBounds().getY()));
            double x = 76.0 - unionPath.getBounds().getWidth();
            double y = this.unionWidth - unionPath.getBounds().getHeight();
            unionPath.transform(AffineTransform.getTranslateInstance(x / 2.0, y / 2.0));
            g.setColor(Color.WHITE);
            g.fill(unionPath);
        }

        public Image getImage() {
            return this.image;
        }

        public GeneralPath getGrid(int states) {
            int[] bars = new int[2];
            for (int count = states; count < 51; ++count) {
                if (layout[count][0] <= 0) continue;
                bars = layout[count];
                break;
            }
            int maxCols = Math.max(bars[0], bars[1]);
            int rows = 2;
            int sum = bars[0] + bars[1];
            while (sum < states) {
                sum += bars[rows % 2];
                ++rows;
            }
            double hSpace = 76.0 / (double)(2 * maxCols);
            double vSpace = this.unionWidth / (double)(2 * rows);
            double y = 0.0;
            GeneralPath star = this.getPentagram();
            GeneralPath grid = new GeneralPath();
            int count = 1;
            for (int row = 0; row < rows; ++row) {
                int cols = bars[row % 2];
                double x = cols == maxCols ? 0.0 : hSpace;
                for (int col = 0; col < cols && count <= states; ++count, ++col) {
                    GeneralPath newStar = (GeneralPath)star.clone();
                    newStar.transform(AffineTransform.getTranslateInstance(x, y));
                    grid.append(newStar, false);
                    x += 2.0 * hSpace;
                }
                y += 2.0 * vSpace;
            }
            return grid;
        }

        public GeneralPath getPentagram() {
            int[] vertex;
            double angle = 1.2566370614359172;
            double y = -3.08;
            GeneralPath pentagram = new GeneralPath(1);
            pentagram.moveTo(0.0, y);
            for (int i : vertex = new int[]{2, 4, 1, 3}) {
                double phi = (double)i * angle;
                double xx = -y * Math.sin(phi);
                double yy = y * Math.cos(phi);
                pentagram.lineTo(xx, yy);
            }
            pentagram.closePath();
            return pentagram;
        }

        public GeneralPath getCircleOfStars(int n) {
            double radius = 0.3 * this.unionWidth;
            double phi = Math.PI * 2 / (double)n;
            GeneralPath star = this.getPentagram();
            GeneralPath circle = new GeneralPath();
            for (int i = 0; i < n; ++i) {
                GeneralPath newStar = (GeneralPath)star.clone();
                double xx = -radius - radius * Math.sin((double)i * phi);
                double yy = -radius * Math.cos((double)i * phi);
                newStar.transform(AffineTransform.getTranslateInstance(xx, yy));
                circle.append(newStar, false);
            }
            double x = circle.getBounds().getX();
            double y = circle.getBounds().getY();
            circle.transform(AffineTransform.getTranslateInstance(-x, -y));
            return circle;
        }
    }
}

