/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.Worker;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.control.InGameInputHandler;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.control.PreGameInputHandler;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.FullScreenFrame;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.WindowedFrame;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.menu.FreeColMenuBar;
import net.sf.freecol.client.gui.plaf.FreeColLookAndFeel;
import net.sf.freecol.client.gui.sound.SoundPlayer;
import net.sf.freecol.client.networking.Client;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.ServerAPI;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.server.FreeColServer;

public final class FreeColClient {
    private static final Logger logger = Logger.getLogger(FreeColClient.class.getName());
    private static FreeColClient instance;
    private static final int DEFAULT_WINDOW_SPACE = 100;
    private ConnectController connectController;
    private PreGameController preGameController;
    private PreGameInputHandler preGameInputHandler;
    private InGameController inGameController;
    private InGameInputHandler inGameInputHandler;
    private MapEditorController mapEditorController;
    private ServerAPI serverAPI;
    private GraphicsDevice gd;
    private JFrame frame;
    private Canvas canvas;
    private GUI gui;
    private ImageLibrary imageLibrary;
    private SoundPlayer soundPlayer;
    private Client client;
    private Game game;
    private Player player;
    private boolean isRetired = false;
    private boolean inGame = false;
    private FreeColServer freeColServer = null;
    private boolean windowed;
    private boolean mapEditor;
    private boolean singleplayer;
    private final ActionManager actionManager;
    private ClientOptions clientOptions;
    public final Worker worker;
    private boolean loggedIn = false;
    private Rectangle windowBounds;
    private boolean headless;

    public FreeColClient(final File savedGame, Dimension size, final boolean sound, String splashFilename, final boolean showOpeningVideo, String fontName) {
        File baseDirectory = new File(FreeCol.getDataDirectory(), "base");
        if (!baseDirectory.exists() || !baseDirectory.isDirectory()) {
            System.err.println("Could not find base data directory: " + baseDirectory.getName());
            System.err.println("  The data files could not be found by FreeCol. Please make sure");
            System.err.println("  they are present. If FreeCol is looking in the wrong directory");
            System.err.println("  then run the game with a command-line parameter:\n");
            System.err.println("    --freecol-data <data-directory>\n");
            System.exit(1);
        }
        this.headless = "true".equals(System.getProperty("java.awt.headless", "false"));
        if (this.headless) {
            System.err.println("Headless operation disabled.\n");
            System.exit(1);
        }
        this.mapEditor = false;
        JWindow splash = null;
        if (splashFilename != null) {
            try {
                Image im = Toolkit.getDefaultToolkit().getImage(splashFilename);
                splash = new JWindow();
                splash.getContentPane().add(new JLabel(new ImageIcon(im)));
                splash.pack();
                Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
                splash.setLocation(center.x - splash.getWidth() / 2, center.y - splash.getHeight() / 2);
                splash.setVisible(true);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Splash fail", e);
                splash = null;
            }
        }
        boolean bl = this.windowed = size != null;
        if (size != null && size.width < 0) {
            Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            size = new Dimension(bounds.width - 100, bounds.height - 100);
            logger.info("Window size is " + size.getWidth() + " x " + size.getHeight());
        }
        this.connectController = new ConnectController(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameController = new InGameController(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.mapEditorController = new MapEditorController(this);
        this.imageLibrary = new ImageLibrary();
        this.actionManager = new ActionManager(this);
        this.worker = new Worker();
        this.worker.start();
        FreeColDataFile baseData = new FreeColDataFile(baseDirectory);
        ResourceManager.setBaseMapping(baseData.getResourceMapping());
        FreeColTcFile tcData = new FreeColTcFile("classic");
        ResourceManager.setTcMapping(tcData.getResourceMapping());
        this.actionManager.initializeActions();
        this.loadClientOptions(savedGame);
        ResourceManager.preload(size);
        Font font = null;
        if (fontName != null && (font = Font.decode(fontName)) == null) {
            System.err.println("Font not found: " + fontName);
        }
        if (font == null) {
            font = ResourceManager.getFont("NormalFont");
        }
        try {
            FreeColLookAndFeel fclaf = new FreeColLookAndFeel(FreeCol.getDataDirectory(), size);
            FreeColLookAndFeel.install(fclaf, font);
        }
        catch (FreeColException e) {
            System.err.println("Unable to install FreeCol look-and-feel.");
            e.printStackTrace();
            System.exit(1);
        }
        if (splash != null) {
            splash.setVisible(false);
            splash.dispose();
        }
        final Dimension windowSize = size;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FreeColClient.this.startGUI(windowSize, sound, showOpeningVideo, savedGame != null);
            }
        });
        if (savedGame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FreeColClient.this.connectController.loadGame(savedGame);
                }
            });
        }
        if (instance == null) {
            instance = this;
        }
    }

    public static FreeColClient get() {
        return instance;
    }

    private void startGUI(Dimension innerWindowSize, boolean sound, boolean showOpeningVideo, boolean loadGame) {
        if (sound) {
            ClientOptions opts = this.getClientOptions();
            AudioMixerOption amo = (AudioMixerOption)opts.getOption("model.option.audioMixer");
            PercentageOption volume = (PercentageOption)opts.getOption("model.option.audioVolume");
            try {
                this.soundPlayer = new SoundPlayer(amo, volume);
            }
            catch (Exception e) {
                this.soundPlayer = null;
                logger.log(Level.WARNING, "Sound disabled", e);
            }
        } else {
            this.soundPlayer = null;
        }
        if (GraphicsEnvironment.isHeadless()) {
            logger.info("It seems that the GraphicsEnvironment is headless!");
        }
        this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (!this.windowed) {
            if (!this.gd.isFullScreenSupported()) {
                String fullscreenNotSupported = "\nIt seems that full screen mode is not fully supported for this\nGraphicsDevice. Please try the \"--windowed\" option if you\nexperienceany graphical problems while running FreeCol.";
                logger.info(fullscreenNotSupported);
                System.out.println(fullscreenNotSupported);
            }
            Rectangle bounds = this.gd.getDefaultConfiguration().getBounds();
            innerWindowSize = new Dimension(bounds.width - bounds.x, bounds.height - bounds.y);
        }
        this.gui = new GUI(this, innerWindowSize, this.imageLibrary);
        this.canvas = new Canvas(this, innerWindowSize, this.gui);
        this.changeWindowedMode(this.windowed);
        this.frame.setIconImage(ResourceManager.getImage("FrameIcon.image"));
        Option o = this.getClientOptions().getOption("model.option.languageOption");
        if (o != null) {
            o.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (((LanguageOption.Language)e.getNewValue()).getKey().equals("automatic")) {
                        FreeColClient.this.canvas.showInformationMessage("autodetectLanguageSelected");
                    } else {
                        Locale l = ((LanguageOption.Language)e.getNewValue()).getLocale();
                        Messages.setMessageBundle(l);
                        FreeColClient.this.canvas.showInformationMessage(StringTemplate.template("newLanguageSelected").addName("%language%", l.getDisplayName()));
                    }
                }
            });
        }
        if (showOpeningVideo && !loadGame) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FreeColClient.this.canvas.showOpeningVideoPanel();
                }
            });
        } else {
            if (!loadGame) {
                this.canvas.showMainPanel();
            }
            this.playSound("sound.intro.general");
        }
        this.gui.startCursorBlinking();
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean newHeadless) {
        this.headless = newHeadless;
    }

    public boolean canSaveCurrentGame() {
        if (this.getFreeColServer() == null) {
            return false;
        }
        if (this.getMyPlayer() == null) {
            return false;
        }
        return this.getFreeColServer().getGameState() != FreeColServer.GameState.IN_GAME || this.getMyPlayer().isAdmin();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void updateMenuBar() {
        if (this.frame != null && this.frame.getJMenuBar() != null) {
            ((FreeColMenuBar)this.frame.getJMenuBar()).update();
        }
    }

    public void changeWindowedMode(boolean windowed) {
        JMenuBar menuBar = null;
        if (this.frame != null) {
            menuBar = this.frame.getJMenuBar();
            if (this.frame instanceof WindowedFrame) {
                this.windowBounds = this.frame.getBounds();
            }
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        this.windowed = windowed;
        this.frame = windowed ? new WindowedFrame() : new FullScreenFrame(this.gd);
        this.frame.setJMenuBar(menuBar);
        if (this.frame instanceof WindowedFrame) {
            ((WindowedFrame)this.frame).setCanvas(this.canvas);
            this.frame.getContentPane().add(this.canvas);
            if (this.windowBounds != null) {
                this.frame.setBounds(this.windowBounds);
            } else {
                this.frame.pack();
            }
        } else if (this.frame instanceof FullScreenFrame) {
            ((FullScreenFrame)this.frame).setCanvas(this.canvas);
            this.frame.getContentPane().add(this.canvas);
        }
        this.gui.forceReposition();
        this.canvas.updateSizes();
        this.frame.setVisible(true);
    }

    public boolean isWindowed() {
        return this.windowed;
    }

    public void setMapEditor(boolean mapEditor) {
        this.mapEditor = mapEditor;
    }

    public boolean isMapEditor() {
        return this.mapEditor;
    }

    public ImageLibrary getImageLibrary() {
        return this.imageLibrary;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    private void loadClientOptions(File savedGame) {
        File userOptions;
        this.clientOptions = new ClientOptions();
        logger.info("Loaded default client options.");
        ActionManager actionManager = this.getActionManager();
        if (actionManager != null) {
            this.clientOptions.add(actionManager);
            logger.info("Loaded client options from the action manager.");
        }
        if (savedGame != null) {
            try {
                FreeColSavegameFile save = new FreeColSavegameFile(savedGame);
                String fileName = "client-options.xml";
                this.clientOptions.loadOptions(save.getInputStream(fileName));
                logger.info("Loaded client options from saved game:" + savedGame.getPath() + "(" + fileName + ")");
            }
            catch (Exception e) {
                logger.warning("Unable to read client options from: " + savedGame.getPath());
            }
        }
        if ((userOptions = FreeCol.getClientOptionsFile()) != null && userOptions.exists()) {
            this.clientOptions.updateOptions(userOptions);
            logger.info("Updated client options from user options file: " + userOptions.getPath());
        } else {
            logger.warning("User options file not present.");
        }
        ArrayList<ResourceMapping> modMappings = new ArrayList<ResourceMapping>();
        for (FreeColModFile f : this.clientOptions.getActiveMods()) {
            modMappings.add(f.getResourceMapping());
        }
        ResourceManager.setModMappings(modMappings);
        if (actionManager != null) {
            actionManager.update();
        }
    }

    public MapEditorController getMapEditorController() {
        return this.mapEditorController;
    }

    public Player getMyPlayer() {
        return this.player;
    }

    public void setMyPlayer(Player player) {
        this.player = player;
    }

    public void setFreeColServer(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public Game getGame() {
        return this.game;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public GUI getGUI() {
        return this.gui;
    }

    private void exitActions() {
        try {
            int validDays = this.getClientOptions().getInteger("model.option.autosaveValidity");
            long validPeriod = (long)validDays * 86400L * 1000L;
            long timeNow = System.currentTimeMillis();
            File autosaveDir = FreeCol.getAutosaveDirectory();
            if (validPeriod != 0L) {
                String[] flist = autosaveDir.list();
                for (int i = 0; flist != null && i < flist.length; ++i) {
                    File saveGameFile;
                    String filename = flist[i];
                    if (!filename.endsWith(".fsg") || (saveGameFile = new File(autosaveDir, filename)).lastModified() + validPeriod >= timeNow) continue;
                    saveGameFile.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void quit() {
        this.getConnectController().quitGame(this.isSingleplayer());
        this.exitActions();
        if (!this.windowed) {
            try {
                this.gd.setFullScreenWindow(null);
            }
            catch (Exception e) {
                System.exit(1);
            }
        }
        System.exit(0);
    }

    public void continuePlaying() {
        this.client.send(DOMMessage.createNewRootElement("continuePlaying"));
    }

    public boolean isAdmin() {
        if (this.getMyPlayer() == null) {
            return false;
        }
        return this.getMyPlayer().isAdmin();
    }

    public void setSingleplayer(boolean singleplayer) {
        this.singleplayer = singleplayer;
    }

    public boolean isSingleplayer() {
        return this.singleplayer;
    }

    public void setIsRetired(boolean isRetired) {
        this.isRetired = isRetired;
    }

    public boolean isRetired() {
        return this.isRetired;
    }

    public ConnectController getConnectController() {
        return this.connectController;
    }

    public PreGameController getPreGameController() {
        return this.preGameController;
    }

    public PreGameInputHandler getPreGameInputHandler() {
        return this.preGameInputHandler;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public InGameInputHandler getInGameInputHandler() {
        return this.inGameInputHandler;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public SoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    public void playSound(String sound) {
        if (this.canPlaySound()) {
            if (sound == null) {
                this.soundPlayer.stop();
            } else {
                File file = ResourceManager.getAudio(sound);
                if (file != null) {
                    this.soundPlayer.playOnce(file);
                }
                logger.finest((file == null ? "Could not load" : "Playing") + " sound: " + sound);
            }
        }
    }

    public boolean canPlaySound() {
        return this.soundPlayer != null;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public ServerAPI askServer() {
        if (this.serverAPI == null) {
            this.serverAPI = new ServerAPI(this);
        }
        return this.serverAPI;
    }

    public void setActiveUnit(String unitId) {
        Unit active;
        if (unitId != null && this.getGame() != null && (active = (Unit)this.getGame().getFreeColGameObject(unitId)) != null) {
            active.getOwner().resetIterators();
            active.getOwner().setNextActiveUnit(active);
            this.getGUI().setActiveUnit(active);
        }
    }

    public void setInGame(boolean inGame) {
        this.inGame = inGame;
    }

    public boolean isInGame() {
        return this.inGame;
    }

    public void skipTurns(int turns) {
        if (this.freeColServer == null) {
            return;
        }
        this.freeColServer.getInGameController().setSkippedTurns(turns);
        this.getCanvas().closeMenus();
        this.inGameController.endTurn();
    }
}

