/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InputHandler;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.animation.Animations;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.panel.ChooseFoundingFatherDialog;
import net.sf.freecol.client.gui.panel.MonarchPanel;
import net.sf.freecol.client.gui.panel.VictoryPanel;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InGameInputHandler
extends InputHandler {
    private static final Logger logger = Logger.getLogger(InGameInputHandler.class.getName());
    private Unit lastAnimatedUnit = null;

    public InGameInputHandler(FreeColClient freeColClient) {
        super(freeColClient);
    }

    @Override
    public Element handle(Connection connection, Element element) {
        String type;
        Element reply = null;
        if (element != null) {
            type = element.getTagName();
            logger.log(Level.FINEST, "Received message " + type);
            if (type.equals("update")) {
                reply = this.update(element);
            } else if (type.equals("remove")) {
                reply = this.remove(element);
            } else if (type.equals("animateMove")) {
                reply = this.animateMove(element);
            } else if (type.equals("animateAttack")) {
                reply = this.animateAttack(element);
            } else if (type.equals("setCurrentPlayer")) {
                reply = this.setCurrentPlayer(element);
            } else if (type.equals("newTurn")) {
                reply = this.newTurn(element);
            } else if (type.equals("setDead")) {
                reply = this.setDead(element);
            } else if (type.equals("gameEnded")) {
                reply = this.gameEnded(element);
            } else if (type.equals("chat")) {
                reply = this.chat(element);
            } else if (type.equals("disconnect")) {
                reply = this.disconnect(element);
            } else if (type.equals("error")) {
                reply = this.error(element);
            } else if (type.equals("chooseFoundingFather")) {
                reply = this.chooseFoundingFather(element);
            } else if (type.equals("indianDemand")) {
                reply = this.indianDemand(element);
            } else if (type.equals("spyResult")) {
                reply = this.spyResult(element);
            } else if (type.equals("reconnect")) {
                reply = this.reconnect(element);
            } else if (type.equals("setAI")) {
                reply = this.setAI(element);
            } else if (type.equals("monarchAction")) {
                reply = this.monarchAction(element);
            } else if (type.equals("setStance")) {
                reply = this.setStance(element);
            } else if (type.equals("diplomacy")) {
                reply = this.diplomacy(element);
            } else if (type.equals("addPlayer")) {
                reply = this.addPlayer(element);
            } else if (type.equals("addObject")) {
                reply = this.addObject(element);
            } else if (type.equals("newLandName")) {
                reply = this.newLandName(element);
            } else if (type.equals("newRegionName")) {
                reply = this.newRegionName(element);
            } else if (type.equals("fountainOfYouth")) {
                reply = this.fountainOfYouth(element);
            } else if (type.equals("lootCargo")) {
                reply = this.lootCargo(element);
            } else if (type.equals("multiple")) {
                reply = this.multiple(connection, element);
            } else {
                logger.warning("Message is of unsupported type \"" + type + "\".");
            }
        } else {
            throw new RuntimeException("Received empty (null) message! - should never happen");
        }
        logger.log(Level.FINEST, "Handled message " + type + " replying with " + (reply == null ? "null" : reply.getTagName()));
        return reply;
    }

    private Element reconnect(Element element) {
        logger.finest("Entered reconnect...");
        if (new ShowConfirmDialogSwingTask(null, StringTemplate.key("reconnect.text"), "reconnect.yes", "reconnect.no").confirm()) {
            logger.finest("User wants to reconnect, do it!");
            new ReconnectSwingTask().invokeLater();
        } else {
            logger.finest("No reconnect, quit.");
            this.getFreeColClient().quit();
        }
        return null;
    }

    public Element update(Element updateElement) {
        this.updateGameObjects(updateElement.getChildNodes());
        new RefreshCanvasSwingTask().invokeLater();
        return null;
    }

    private void updateGameObjects(NodeList nodeList) {
        Game game = this.getGame();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String id = element.getAttribute("ID");
            FreeColGameObject fcgo = game.getFreeColGameObjectSafely(id);
            if (fcgo == null) {
                logger.warning("Object in update not present in client: " + id);
                continue;
            }
            fcgo.readFromXMLElement(element);
        }
    }

    private Element remove(Element removeElement) {
        Game game = this.getGame();
        String divertString = removeElement.getAttribute("divert");
        FreeColGameObject divert = divertString == null || divertString.isEmpty() ? null : game.getFreeColGameObject(divertString);
        Player player = this.getFreeColClient().getMyPlayer();
        NodeList nodeList = removeElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            FreeColGameObject fcgo;
            Element element = (Element)nodeList.item(i);
            String idString = element.getAttribute("ID");
            FreeColGameObject freeColGameObject = fcgo = idString == null || idString.isEmpty() ? null : game.getFreeColGameObject(idString);
            if (fcgo == null) {
                logger.warning("Could not find FreeColGameObject with ID: " + idString);
                continue;
            }
            if (divert != null) {
                player.divertModelMessages(fcgo, divert);
            }
            GUI gui = this.getFreeColClient().getCanvas().getGUI();
            if (fcgo instanceof Unit) {
                Unit u = (Unit)fcgo;
                player.invalidateCanSeeTiles();
                if (u == gui.getActiveUnit()) {
                    gui.setActiveUnit(null);
                }
                player.removeUnit(u);
            }
            fcgo.fundamentalDispose();
        }
        new RefreshCanvasSwingTask().invokeLater();
        return null;
    }

    private static Unit getUnitFromElement(Game game, Element element) {
        if (element.getFirstChild() != null) {
            return new Unit(game, (Element)element.getFirstChild());
        }
        return null;
    }

    private static Unit selectUnitFromElement(Game game, Element element, String id) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            if (!id.equals(e.getAttribute("ID"))) continue;
            return new Unit(game, e);
        }
        return null;
    }

    private Element animateMove(Element element) {
        String key;
        FreeColClient client = this.getFreeColClient();
        Game game = this.getGame();
        String unitId = element.getAttribute("unit");
        if (unitId == null) {
            logger.warning("Animation for: " + client.getMyPlayer().getId() + " ommitted unitId");
            return null;
        }
        Unit unit = (Unit)game.getFreeColGameObjectSafely(unitId);
        if (unit == null && (unit = InGameInputHandler.selectUnitFromElement(game, element, unitId)) == null) {
            logger.warning("Animation for: " + client.getMyPlayer().getId() + " incorrectly omitted unit: " + unitId);
            return null;
        }
        ClientOptions options = client.getClientOptions();
        boolean ourUnit = unit.getOwner() == client.getMyPlayer();
        String string = key = ourUnit ? "model.option.moveAnimationSpeed" : "model.option.enemyMoveAnimationSpeed";
        if (!client.isHeadless() && options.getInteger(key) > 0) {
            String oldTileId = element.getAttribute("oldTile");
            String newTileId = element.getAttribute("newTile");
            Tile oldTile = (Tile)game.getFreeColGameObjectSafely(oldTileId);
            Tile newTile = (Tile)game.getFreeColGameObjectSafely(newTileId);
            if (newTile == null || oldTile == null) {
                throw new IllegalStateException("animateMove unit: " + unitId + (oldTile == null ? ": null oldTile" : "") + (newTile == null ? ": null newTile" : ""));
            }
            try {
                new UnitMoveAnimationCanvasSwingTask(unit, oldTile, newTile, unit != this.lastAnimatedUnit).invokeSpecial();
            }
            catch (Exception exception) {
                logger.warning("UnitMoveAnimationCanvasSwingTask raised " + exception.toString());
            }
            this.lastAnimatedUnit = unit;
        }
        return null;
    }

    private Element animateAttack(Element element) {
        String attackerId;
        FreeColClient client = this.getFreeColClient();
        if (client.isHeadless()) {
            return null;
        }
        Game game = this.getGame();
        Unit attacker = (Unit)game.getFreeColGameObjectSafely(attackerId = element.getAttribute("attacker"));
        if (attacker == null && (attacker = InGameInputHandler.selectUnitFromElement(game, element, attackerId)) == null) {
            logger.warning("Attack animation for: " + client.getMyPlayer().getId() + " incorrectly omitted attacker: " + attackerId);
            return null;
        }
        String defenderId = element.getAttribute("defender");
        Unit defender = (Unit)game.getFreeColGameObjectSafely(defenderId);
        if (defender == null && (defender = InGameInputHandler.selectUnitFromElement(game, element, defenderId)) == null) {
            logger.warning("Attack animation for: " + client.getMyPlayer().getId() + " incorrectly omitted defender: " + defenderId);
            return null;
        }
        boolean success = Boolean.parseBoolean(element.getAttribute("success"));
        if (attacker == null || defender == null) {
            throw new IllegalStateException("animateAttack" + (attacker == null ? ": null attacker" : "") + (defender == null ? ": null defender" : ""));
        }
        try {
            new UnitAttackAnimationCanvasSwingTask(attacker, defender, success, attacker != this.lastAnimatedUnit).invokeSpecial();
        }
        catch (Exception exception) {
            logger.warning("UnitAttackAnimationCanvasSwingTask raised " + exception.toString());
        }
        this.lastAnimatedUnit = attacker;
        return null;
    }

    private Element setCurrentPlayer(Element element) {
        Game game = this.getGame();
        Player newPlayer = (Player)game.getFreeColGameObject(element.getAttribute("player"));
        Player player = this.getFreeColClient().getMyPlayer();
        new SetCurrentPlayerSwingTask(newPlayer, FreeCol.isInDebugMode() && player.equals(game.getCurrentPlayer()), player.equals(newPlayer)).invokeLater();
        return null;
    }

    private Element newTurn(Element element) {
        Game game = this.getGame();
        String turnString = element.getAttribute("turn");
        try {
            int turnNumber = Integer.parseInt(turnString);
            game.setTurn(new Turn(turnNumber));
        }
        catch (NumberFormatException e) {
            logger.warning("Bad turn in newTurn: " + turnString);
        }
        Turn currTurn = game.getTurn();
        if (currTurn.isFirstSeasonTurn()) {
            new ShowInformationMessageSwingTask(StringTemplate.key("twoTurnsPerYear")).invokeLater();
        }
        new UpdateMenuBarSwingTask().invokeLater();
        return null;
    }

    private Element setDead(Element element) {
        Player myPlayer;
        FreeColClient freeColClient = this.getFreeColClient();
        Player player = (Player)this.getGame().getFreeColGameObject(element.getAttribute("player"));
        if (player == (myPlayer = freeColClient.getMyPlayer())) {
            if (freeColClient.isSingleplayer()) {
                if (myPlayer.getPlayerType() != Player.PlayerType.UNDEAD && new ShowConfirmDialogSwingTask(null, StringTemplate.key("defeatedSingleplayer.text"), "defeatedSingleplayer.yes", "defeatedSingleplayer.no").confirm()) {
                    freeColClient.askServer().enterRevengeMode();
                } else {
                    freeColClient.quit();
                }
            } else if (!new ShowConfirmDialogSwingTask(null, StringTemplate.key("defeated.text"), "defeated.yes", "defeated.no").confirm()) {
                freeColClient.quit();
            }
        } else {
            myPlayer.setStance(player, null);
        }
        return null;
    }

    private Element gameEnded(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        Player winner = (Player)this.getGame().getFreeColGameObject(element.getAttribute("winner"));
        if (winner == freeColClient.getMyPlayer()) {
            new ShowVictoryPanelSwingTask().invokeLater();
        }
        return null;
    }

    private Element chat(Element element) {
        final ChatMessage chatMessage = new ChatMessage(this.getGame(), element);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Canvas canvas = InGameInputHandler.this.getFreeColClient().getCanvas();
                canvas.displayChatMessage(chatMessage.getPlayer(), chatMessage.getMessage(), chatMessage.isPrivate());
            }
        });
        return null;
    }

    private Element error(Element element) {
        try {
            new ShowErrorMessageSwingTask(element.getAttribute("messageID"), element.getAttribute("message")).invokeSpecial();
        }
        catch (Exception exception) {
            logger.warning("error() raised " + exception.toString());
        }
        return null;
    }

    private Element setAI(Element element) {
        Player p = (Player)this.getGame().getFreeColGameObject(element.getAttribute("player"));
        p.setAI(Boolean.valueOf(element.getAttribute("ai")));
        return null;
    }

    private Element chooseFoundingFather(Element element) {
        ArrayList<FoundingFather> ffs = new ArrayList<FoundingFather>();
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            String id = element.getAttribute(type.toString());
            if (id == null || id.equals("")) continue;
            FoundingFather father = this.getGame().getSpecification().getFoundingFather(id);
            if (father == null) {
                logger.warning("Bogus " + (Object)((Object)type) + " father: " + id);
                continue;
            }
            ffs.add(father);
        }
        new FoundingFatherSwingTask(ffs).invokeLater();
        return null;
    }

    private Element diplomacy(Element element) {
        Game game = this.getGame();
        Player player = this.getFreeColClient().getMyPlayer();
        DiplomacyMessage message = new DiplomacyMessage(game, element);
        Unit unit = message.getUnit(game);
        if (unit == null && (unit = InGameInputHandler.getUnitFromElement(game, element)) == null) {
            logger.warning("Unit incorrectly omitted from diplomacy message.");
            return null;
        }
        Settlement settlement = message.getSettlement(game);
        Player other = unit.getOwner() == player ? settlement.getOwner() : unit.getOwner();
        String nation = Messages.message(other.getNationName());
        DiplomaticTrade theirAgreement = message.getAgreement();
        switch (theirAgreement.getStatus()) {
            case ACCEPT_TRADE: {
                new ShowInformationMessageSwingTask(StringTemplate.template("negotiationDialog.offerAccepted").addName("%nation%", nation)).show();
                break;
            }
            case REJECT_TRADE: {
                new ShowInformationMessageSwingTask(StringTemplate.template("negotiationDialog.offerRejected").addName("%nation%", nation)).show();
                break;
            }
            case PROPOSE_TRADE: {
                DiplomaticTrade ourAgreement = new ShowNegotiationDialogSwingTask(unit, settlement, theirAgreement).select();
                if (ourAgreement == null) {
                    theirAgreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
                } else {
                    message.setAgreement(ourAgreement);
                }
                return message.toXMLElement();
            }
            default: {
                logger.warning("Bogus trade status");
            }
        }
        return null;
    }

    private Element indianDemand(Element element) {
        boolean accepted;
        ModelMessage m;
        Player player;
        block16: {
            int opt;
            String nation;
            Goods goods;
            Colony colony;
            Unit unit;
            block15: {
                Game game = this.getGame();
                player = this.getFreeColClient().getMyPlayer();
                IndianDemandMessage message = new IndianDemandMessage(game, element);
                unit = message.getUnit(game);
                if (unit == null) {
                    logger.warning("IndianDemand with null unit: " + element.getAttribute("unit"));
                    return null;
                }
                colony = message.getColony(game);
                if (colony == null) {
                    logger.warning("IndianDemand with null colony: " + element.getAttribute("colony"));
                    return null;
                }
                if (colony.getOwner() != player) {
                    throw new IllegalArgumentException("Demand to anothers colony");
                }
                goods = message.getGoods();
                String goldStr = Integer.toString(message.getGold());
                m = null;
                nation = Messages.message(unit.getOwner().getNationName());
                opt = this.getFreeColClient().getClientOptions().getInteger("model.option.indianDemandResponse");
                if (goods != null) break block15;
                switch (opt) {
                    case 0: {
                        accepted = new ShowConfirmDialogSwingTask(colony.getTile(), StringTemplate.template("indianDemand.gold.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", message.getGold()), "indianDemand.gold.yes", "indianDemand.gold.no").confirm();
                        break block16;
                    }
                    case 1: {
                        m = new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.gold.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", goldStr);
                        accepted = true;
                        break block16;
                    }
                    case 2: {
                        m = new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.gold.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", goldStr);
                        accepted = false;
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Impossible option value.");
                    }
                }
            }
            String amount = String.valueOf(goods.getAmount());
            switch (opt) {
                case 0: {
                    if (goods.getType().isFoodType()) {
                        accepted = new ShowConfirmDialogSwingTask(colony.getTile(), StringTemplate.template("indianDemand.food.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", goods.getAmount()), "indianDemand.food.yes", "indianDemand.food.no").confirm();
                        break;
                    }
                    accepted = new ShowConfirmDialogSwingTask(colony.getTile(), StringTemplate.template("indianDemand.other.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", goods.getAmount()).add("%goods%", goods.getType().getNameKey()), "indianDemand.other.yes", "indianDemand.other.no").confirm();
                    break;
                }
                case 1: {
                    m = goods.getType().isFoodType() ? new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.food.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", amount) : new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.other.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", amount).add("%goods%", goods.getNameKey());
                    accepted = true;
                    break;
                }
                case 2: {
                    m = goods.getType().isFoodType() ? new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.food.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", amount) : new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.other.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", amount).add("%goods%", goods.getNameKey());
                    accepted = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Impossible option value.");
                }
            }
        }
        if (m != null) {
            player.addModelMessage(m);
        }
        element.setAttribute("accepted", String.valueOf(accepted));
        return element;
    }

    private Element spyResult(Element element) {
        FreeColGameObject fcgo;
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() != 2) {
            logger.warning("spyResult length = " + nodeList.getLength());
            return null;
        }
        Game game = this.getGame();
        Element fullTile = (Element)nodeList.item(0);
        Element normalTile = (Element)nodeList.item(1);
        String tileId = element.getAttribute("tile");
        if (tileId == null || (fcgo = game.getFreeColGameObjectSafely(tileId)) == null || !(fcgo instanceof Tile)) {
            logger.warning("spyResult bad tile = " + tileId);
            return null;
        }
        Tile tile = (Tile)fcgo;
        tile.readFromXMLElement(fullTile);
        Colony colony = tile.getColony();
        if (colony == null) {
            tile.readFromXMLElement(normalTile);
        } else {
            new SpyColonySwingTask(colony, normalTile).invokeLater();
        }
        return null;
    }

    private Element monarchAction(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        Game game = this.getGame();
        Player player = freeColClient.getMyPlayer();
        MonarchActionMessage message = new MonarchActionMessage(game, element);
        Monarch.MonarchAction action = message.getAction();
        StringTemplate template = message.getTemplate();
        boolean accept = new ShowMonarchPanelSwingTask(action, template).confirm();
        element.setAttribute("accepted", String.valueOf(accept));
        new UpdateMenuBarSwingTask().invokeLater();
        return element;
    }

    private String unitListSummary(List<AbstractUnit> unitList) {
        ArrayList<String> unitNames = new ArrayList<String>();
        for (AbstractUnit au : unitList) {
            unitNames.add(au.getNumber() + " " + Messages.message(Messages.getLabel(au)));
        }
        return Utils.join(" " + Messages.message("and") + " ", unitNames);
    }

    private Element setStance(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        Player player = freeColClient.getMyPlayer();
        Game game = this.getGame();
        Player.Stance stance = Enum.valueOf(Player.Stance.class, element.getAttribute("stance"));
        Player first = (Player)game.getFreeColGameObject(element.getAttribute("first"));
        Player second = (Player)game.getFreeColGameObject(element.getAttribute("second"));
        Player.Stance old = first.getStance(second);
        try {
            first.setStance(second, stance);
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, "Illegal stance transition", e);
            return null;
        }
        logger.info("Stance transition: " + old.toString() + " -> " + stance.toString());
        if (player == first && old == Player.Stance.UNCONTACTED) {
            freeColClient.playSound("sound.event.meet." + second.getNationID());
        }
        return null;
    }

    private Element addPlayer(Element element) {
        Element playerElement = (Element)element.getElementsByTagName(Player.getXMLElementTagName()).item(0);
        if (this.getGame().getFreeColGameObject(playerElement.getAttribute("ID")) == null) {
            Player newPlayer = new Player(this.getGame(), playerElement);
            this.getGame().addPlayer(newPlayer);
        } else {
            this.getGame().getFreeColGameObject(playerElement.getAttribute("ID")).readFromXMLElement(playerElement);
        }
        return null;
    }

    public Element disposeUnits(Element element) {
        Game game = this.getGame();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            FreeColGameObject fcgo = game.getFreeColGameObjectSafely(e.getAttribute("ID"));
            if (fcgo instanceof Unit) {
                ((Unit)fcgo).dispose();
                continue;
            }
            logger.warning("Object is not a unit: " + (fcgo == null ? "null" : fcgo.getId()));
        }
        return null;
    }

    public Element addObject(Element element) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String owner = e.getAttribute("owner");
            Player player = null;
            if (!(game.getFreeColGameObjectSafely(owner) instanceof Player)) {
                logger.warning("addObject with broken owner: " + (owner == null ? "(null)" : owner));
                continue;
            }
            player = (Player)game.getFreeColGameObjectSafely(owner);
            String tag = e.getTagName();
            if (tag == null) {
                logger.warning("addObject null tag");
                continue;
            }
            if (tag == FoundingFather.getXMLElementTagName()) {
                String id = e.getAttribute("id");
                FoundingFather father = spec.getFoundingFather(id);
                if (father == null) continue;
                player.addFather(father);
                continue;
            }
            if (tag == HistoryEvent.getXMLElementTagName()) {
                HistoryEvent h = new HistoryEvent();
                h.readFromXMLElement(e);
                player.getHistory().add(h);
                continue;
            }
            if (tag == LastSale.getXMLElementTagName()) {
                LastSale s = new LastSale();
                s.readFromXMLElement(e);
                player.saveSale(s);
                continue;
            }
            if (tag == ModelMessage.getXMLElementTagName()) {
                ModelMessage m = new ModelMessage();
                m.readFromXMLElement(e);
                player.addModelMessage(m);
                continue;
            }
            if (tag == TradeRoute.getXMLElementTagName()) {
                TradeRoute t = new TradeRoute(game, e);
                player.getTradeRoutes().add(t);
                continue;
            }
            logger.warning("addObject unrecognized: " + tag);
        }
        return null;
    }

    public Element newLandName(Element element) {
        Game game = this.getGame();
        Player player = this.getFreeColClient().getMyPlayer();
        NewLandNameMessage message = new NewLandNameMessage(game, element);
        Unit unit = message.getUnit(game);
        String defaultName = message.getNewLandName();
        Tile tile = unit.getTile();
        if (unit == null || defaultName == null || tile == null) {
            return null;
        }
        String name = new ShowInputDialogSwingTask(tile, StringTemplate.template("newLand.text"), defaultName, "newLand.yes", null, true).show();
        Player welcomer = message.getWelcomer(game);
        boolean accept = false;
        if (welcomer != null) {
            String messageId = tile.getOwner() == welcomer ? "welcomeOffer.text" : "welcomeSimple.text";
            String type = ((IndianNationType)welcomer.getNationType()).getSettlementTypeKey(true);
            accept = new ShowConfirmDialogSwingTask(tile, StringTemplate.template(messageId).addStringTemplate("%nation%", welcomer.getNationName()).addName("%camps%", message.getCamps()).add("%settlementType%", type), "welcome.yes", "welcome.no").confirm();
        }
        this.getFreeColClient().askServer().newLandName(unit, name, welcomer, accept);
        String key = FreeColActionUI.getHumanKeyStrokeText(this.getFreeColClient().getActionManager().getFreeColAction("buildColonyAction").getAccelerator());
        player.addModelMessage(new ModelMessage(ModelMessage.MessageType.TUTORIAL, "tutorial.buildColony", player).addName("%build_colony_key%", key).add("%build_colony_menu_item%", "buildColonyAction.name").add("%orders_menu_item%", "menuBar.orders"));
        return null;
    }

    public Element newRegionName(Element element) {
        Game game = this.getGame();
        NewRegionNameMessage message = new NewRegionNameMessage(game, element);
        String name = message.getNewRegionName();
        Region region = message.getRegion(game);
        Unit unit = message.getUnit(game);
        if (name == null || region == null) {
            return null;
        }
        name = new ShowInputDialogSwingTask(unit == null ? null : unit.getTile(), StringTemplate.template("nameRegion.text").addName("%type%", Messages.message(region.getLabel())), name, "ok", null, false).show();
        if (name == null || "".equals(name)) {
            name = message.getNewRegionName();
        }
        this.getFreeColClient().askServer().newRegionName(region, unit, name);
        return null;
    }

    public Element fountainOfYouth(Element element) {
        int n;
        String migrants = element.getAttribute("migrants");
        try {
            n = Integer.parseInt(migrants);
        }
        catch (NumberFormatException e) {
            n = -1;
        }
        if (n > 0) {
            final Canvas canvas = this.getFreeColClient().getCanvas();
            final int m = n;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int i = 0; i < m; ++i) {
                        int index = canvas.showEmigrationPanel(true);
                        InGameInputHandler.this.getFreeColClient().askServer().emigrate(index + 1);
                    }
                }
            });
        }
        return null;
    }

    public Element lootCargo(Element element) {
        Game game = this.getGame();
        LootCargoMessage message = new LootCargoMessage(game, element);
        Unit unit = message.getUnit(game);
        List<Goods> goods = message.getGoods();
        if (unit == null || goods == null) {
            return null;
        }
        new LootCargoSwingTask(unit, message.getDefenderId(), goods).invokeLater();
        return null;
    }

    public Element multiple(Connection connection, Element element) {
        NodeList nodes = element.getChildNodes();
        Element reply = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                reply = this.handle(connection, (Element)nodes.item(i));
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Caught crash in multiple item " + i + ", continuing.", e);
            }
        }
        return reply;
    }

    class ShowMonarchPanelSwingTask
    extends SwingTask {
        private Monarch.MonarchAction action;
        private StringTemplate replace;

        public ShowMonarchPanelSwingTask(Monarch.MonarchAction action, StringTemplate replace) {
            this.action = action;
            this.replace = replace;
        }

        public boolean confirm() {
            try {
                Object result = this.invokeAndWait();
                return (Boolean)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        protected Object doWork() {
            Canvas canvas = InGameInputHandler.this.getFreeColClient().getCanvas();
            boolean choice = canvas.showFreeColDialog(new MonarchPanel(canvas, this.action, this.replace));
            return choice;
        }
    }

    class ShowNegotiationDialogSwingTask
    extends SwingTask {
        private Unit unit;
        private Settlement settlement;
        private DiplomaticTrade proposal;

        public ShowNegotiationDialogSwingTask(Unit unit, Settlement settlement, DiplomaticTrade proposal) {
            this.unit = unit;
            this.settlement = settlement;
            this.proposal = proposal;
        }

        public DiplomaticTrade select() {
            try {
                Object result = this.invokeAndWait();
                return (DiplomaticTrade)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        protected Object doWork() {
            return InGameInputHandler.this.getFreeColClient().getCanvas().showNegotiationDialog(this.unit, this.settlement, this.proposal);
        }
    }

    abstract class ShowSelectSwingTask
    extends SwingTask {
        ShowSelectSwingTask() {
        }

        public int select() {
            try {
                Object result = this.invokeAndWait();
                return (Integer)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }

    class ShowErrorMessageSwingTask
    extends ShowMessageSwingTask {
        private String _messageId;
        private String _message;

        public ShowErrorMessageSwingTask(String messageId, String message) {
            this._messageId = messageId;
            this._message = message;
        }

        protected Object doWork() {
            InGameInputHandler.this.getFreeColClient().getCanvas().errorMessage(this._messageId, this._message);
            return null;
        }
    }

    class ShowInformationMessageSwingTask
    extends ShowMessageSwingTask {
        private StringTemplate message;

        public ShowInformationMessageSwingTask(StringTemplate message) {
            this.message = message;
        }

        protected Object doWork() {
            Canvas canvas = InGameInputHandler.this.getFreeColClient().getCanvas();
            canvas.showInformationMessage(null, this.message);
            return null;
        }
    }

    class ShowModelMessageSwingTask
    extends ShowMessageSwingTask {
        private ModelMessage _modelMessage;

        public ShowModelMessageSwingTask(ModelMessage modelMessage) {
            this._modelMessage = modelMessage;
        }

        protected Object doWork() {
            InGameInputHandler.this.getFreeColClient().getCanvas().showModelMessages(this._modelMessage);
            return null;
        }
    }

    abstract class ShowMessageSwingTask
    extends SwingTask {
        ShowMessageSwingTask() {
        }

        public void show() {
            try {
                this.invokeAndWait();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }

    class ShowInputDialogSwingTask
    extends SwingTask {
        private Tile tile;
        private StringTemplate text;
        private String defaultValue;
        private String okText;
        private String cancelText;
        private boolean rejectEmpty;

        public ShowInputDialogSwingTask(Tile tile, StringTemplate text, String defaultValue, String okText, String cancelText, boolean rejectEmpty) {
            this.tile = tile;
            this.text = text;
            this.defaultValue = defaultValue;
            this.okText = okText;
            this.cancelText = cancelText;
            this.rejectEmpty = rejectEmpty;
        }

        public String show() {
            try {
                Object result = this.invokeSpecial();
                return result instanceof String ? (String)result : null;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        protected Object doWork() {
            Canvas canvas = InGameInputHandler.this.getFreeColClient().getCanvas();
            String choice = canvas.showInputDialog(this.tile, this.text, this.defaultValue, this.okText, this.cancelText, this.rejectEmpty);
            return choice;
        }
    }

    class ShowConfirmDialogSwingTask
    extends SwingTask {
        private Tile tile;
        private StringTemplate text;
        private String okText;
        private String cancelText;

        public ShowConfirmDialogSwingTask(Tile tile, StringTemplate text, String okText, String cancelText) {
            this.tile = tile;
            this.text = text;
            this.okText = okText;
            this.cancelText = cancelText;
        }

        public boolean confirm() {
            try {
                Object result = this.invokeSpecial();
                return (Boolean)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        protected Object doWork() {
            Canvas canvas = InGameInputHandler.this.getFreeColClient().getCanvas();
            boolean choice = canvas.showConfirmDialog(this.tile, this.text, this.okText, this.cancelText);
            return choice;
        }
    }

    class ShowVictoryPanelSwingTask
    extends NoResultCanvasSwingTask {
        ShowVictoryPanelSwingTask() {
        }

        protected void doWork(Canvas canvas) {
            canvas.showPanel(new VictoryPanel(canvas));
        }
    }

    class UpdateMenuBarSwingTask
    extends NoResultCanvasSwingTask {
        UpdateMenuBarSwingTask() {
        }

        protected void doWork(Canvas canvas) {
            InGameInputHandler.this.getFreeColClient().updateMenuBar();
        }
    }

    class ReconnectSwingTask
    extends SwingTask {
        ReconnectSwingTask() {
        }

        protected Object doWork() {
            InGameInputHandler.this.getFreeColClient().getConnectController().reconnect();
            return null;
        }
    }

    class SpyColonySwingTask
    extends NoResultCanvasSwingTask {
        private Colony colony;
        private Element normalTile;

        public SpyColonySwingTask(Colony colony, Element normalTile) {
            this.colony = colony;
            this.normalTile = normalTile;
        }

        protected void doWork(Canvas canvas) {
            final Tile tile = this.colony.getTile();
            canvas.showColonyPanel(this.colony).addClosingCallback(new Runnable(){

                public void run() {
                    tile.readFromXMLElement(SpyColonySwingTask.this.normalTile);
                }
            });
        }
    }

    class UnitAttackAnimationCanvasSwingTask
    extends NoResultCanvasSwingTask {
        private final Unit unit;
        private final Unit defender;
        private final boolean success;
        private boolean focus;

        public UnitAttackAnimationCanvasSwingTask(Unit unit, Unit defender, boolean success) {
            this(unit, defender, success, true);
        }

        public UnitAttackAnimationCanvasSwingTask(Unit unit, Unit defender, boolean success, boolean focus) {
            this.unit = unit;
            this.defender = defender;
            this.success = success;
            this.focus = focus;
        }

        protected void doWork(Canvas canvas) {
            GUI gui = canvas.getGUI();
            if (this.focus || !gui.onScreen(this.unit.getTile())) {
                gui.setFocusImmediately(this.unit.getTile());
            }
            Animations.unitAttack(canvas, this.unit, this.defender, this.success);
            canvas.refresh();
        }
    }

    class UnitMoveAnimationCanvasSwingTask
    extends NoResultCanvasSwingTask {
        private final Unit unit;
        private final Tile destinationTile;
        private final Tile sourceTile;
        private boolean focus;

        public UnitMoveAnimationCanvasSwingTask(Unit unit, Tile sourceTile, Tile destinationTile) {
            this(unit, sourceTile, destinationTile, true);
        }

        public UnitMoveAnimationCanvasSwingTask(Unit unit, Tile sourceTile, Tile destinationTile, boolean focus) {
            this.unit = unit;
            this.sourceTile = sourceTile;
            this.destinationTile = destinationTile;
            this.focus = focus;
        }

        protected void doWork(Canvas canvas) {
            GUI gui = canvas.getGUI();
            if (this.focus || !gui.onScreen(this.sourceTile)) {
                gui.setFocusImmediately(this.sourceTile);
            }
            Animations.unitMove(canvas, this.unit, this.sourceTile, this.destinationTile);
            canvas.refresh();
        }
    }

    class RefreshTilesSwingTask
    extends NoResultCanvasSwingTask {
        private final Tile _oldTile;
        private final Tile _newTile;

        public RefreshTilesSwingTask(Tile oldTile, Tile newTile) {
            this._oldTile = oldTile;
            this._newTile = newTile;
        }

        void doWork(Canvas canvas) {
            canvas.refreshTile(this._oldTile);
            canvas.refreshTile(this._newTile);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LootCargoSwingTask
    extends NoResultCanvasSwingTask {
        private Unit unit;
        private String defenderId;
        private List<Goods> goods;

        public LootCargoSwingTask(Unit unit, String defenderId, List<Goods> goods) {
            this.unit = unit;
            this.defenderId = defenderId;
            this.goods = goods;
        }

        @Override
        protected void doWork(Canvas canvas) {
            this.goods = canvas.showCaptureGoodsDialog(this.unit, this.goods);
            if (!this.goods.isEmpty()) {
                InGameInputHandler.this.getFreeColClient().askServer().loot(this.unit, this.defenderId, this.goods);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FoundingFatherSwingTask
    extends NoResultCanvasSwingTask {
        private List<FoundingFather> choices;

        public FoundingFatherSwingTask(List<FoundingFather> choices) {
            this.choices = choices;
        }

        @Override
        protected void doWork(Canvas canvas) {
            ChooseFoundingFatherDialog dialog = new ChooseFoundingFatherDialog(canvas, this.choices);
            FoundingFather ff = canvas.showFreeColDialog(dialog);
            if (ff != null) {
                FreeColClient freeColClient = InGameInputHandler.this.getFreeColClient();
                freeColClient.getMyPlayer().setCurrentFather(ff);
                freeColClient.askServer().chooseFoundingFather(ff);
            }
        }
    }

    class SetCurrentPlayerSwingTask
    extends RefreshCanvasSwingTask {
        private Player newPlayer;
        private boolean oldTurn;
        private boolean newTurn;

        public SetCurrentPlayerSwingTask(Player newPlayer, boolean oldTurn, boolean newTurn) {
            super(true);
            this.newPlayer = newPlayer;
            this.oldTurn = oldTurn;
            this.newTurn = newTurn;
        }

        public void doWork(Canvas canvas) {
            super.doWork(canvas);
            FreeColClient fcc = InGameInputHandler.this.getFreeColClient();
            if (this.oldTurn) {
                canvas.closeMenus();
            }
            fcc.getInGameController().setCurrentPlayer(this.newPlayer);
            if (this.newTurn) {
                List<Settlement> settlements;
                if (FreeCol.isDebugRunComplete() && FreeCol.getDebugRunSaveName() != null) {
                    try {
                        fcc.getFreeColServer().saveGame(new File(".", FreeCol.getDebugRunSaveName()), fcc.getMyPlayer().getName(), fcc.getClientOptions());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    fcc.quit();
                }
                Tile defTile = ((settlements = this.newPlayer.getSettlements()).size() > 0 ? settlements.get(0).getTile() : this.newPlayer.getEntryLocation().getTile()).getSafeTile(null, null);
                this.newPlayer.resetIterators();
                fcc.getInGameController().nextActiveUnit(defTile);
            }
        }
    }

    class RefreshCanvasSwingTask
    extends NoResultCanvasSwingTask {
        private final boolean _requestFocus;

        public RefreshCanvasSwingTask() {
            this(false);
        }

        public RefreshCanvasSwingTask(boolean requestFocus) {
            this._requestFocus = requestFocus;
        }

        protected void doWork(Canvas canvas) {
            canvas.refresh();
            if (this._requestFocus && !canvas.isShowingSubPanel()) {
                canvas.requestFocusInWindow();
            }
        }
    }

    abstract class NoResultCanvasSwingTask
    extends SwingTask {
        NoResultCanvasSwingTask() {
        }

        protected Object doWork() {
            this.doWork(InGameInputHandler.this.getFreeColClient().getCanvas());
            return null;
        }

        abstract void doWork(Canvas var1);
    }

    static abstract class SwingTask
    implements Runnable {
        private static final Logger taskLogger = Logger.getLogger(SwingTask.class.getName());
        private Object _result;
        private boolean _synchronous;
        private boolean _started;

        SwingTask() {
        }

        public Object invokeAndWait() throws InvocationTargetException {
            this.verifyNotStarted();
            this.markStarted(true);
            try {
                SwingUtilities.invokeAndWait(this);
            }
            catch (InterruptedException e) {
                throw new InvocationTargetException(e);
            }
            return this._result;
        }

        public void invokeLater() {
            this.verifyNotStarted();
            this.markStarted(false);
            SwingUtilities.invokeLater(this);
        }

        public Object invokeSpecial() throws InvocationTargetException {
            return SwingUtilities.isEventDispatchThread() ? this.doWork() : this.invokeAndWait();
        }

        private synchronized void markStarted(boolean synchronous) {
            this._synchronous = synchronous;
            this._started = true;
        }

        private synchronized void markDone() {
            this._started = false;
        }

        private synchronized void verifyNotStarted() {
            if (this._started) {
                throw new IllegalStateException("Swing task already started!");
            }
        }

        private synchronized boolean isSynchronous() {
            return this._synchronous;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                taskLogger.log(Level.FINEST, "Running Swing task " + this.getClass().getName() + "...");
                this.setResult(this.doWork());
                taskLogger.log(Level.FINEST, "Swing task " + this.getClass().getName() + " returned " + this._result);
            }
            catch (RuntimeException e) {
                taskLogger.log(Level.WARNING, "Swing task " + this.getClass().getName() + " failed!", e);
                if (this.isSynchronous()) {
                    throw e;
                }
            }
            finally {
                this.markDone();
            }
        }

        public synchronized Object getResult() {
            return this._result;
        }

        private synchronized void setResult(Object r) {
            this._result = r;
        }

        protected abstract Object doWork();
    }
}

