/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.resources.ResourceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class FreeColAction
extends AbstractAction
implements Option {
    private static final Logger logger = Logger.getLogger(FreeColAction.class.getName());
    public static final String ACTION_ID = "ACTION_ID";
    public static final String BUTTON_IMAGE = "BUTTON_IMAGE";
    public static final String BUTTON_ROLLOVER_IMAGE = "BUTTON_ROLLOVER_IMAGE";
    public static final String BUTTON_PRESSED_IMAGE = "BUTTON_PRESSED_IMAGE";
    public static final String BUTTON_DISABLED_IMAGE = "BUTTON_DISABLED_IMAGE";
    public static final Integer NO_MNEMONIC = null;
    protected final FreeColClient freeColClient;
    private int orderButtonImageCount = 0;

    protected FreeColAction(FreeColClient freeColClient, String id) {
        super(Messages.message(id + ".name"));
        String acceleratorKey;
        String accelerator;
        this.freeColClient = freeColClient;
        this.putValue(ACTION_ID, id);
        String descriptionKey = id + ".shortDescription";
        String shortDescription = Messages.message(descriptionKey);
        if (!shortDescription.equals(descriptionKey)) {
            this.putValue("ShortDescription", shortDescription);
        }
        if (!(accelerator = Messages.message(acceleratorKey = id + ".accelerator")).equals(acceleratorKey)) {
            this.setAccelerator(KeyStroke.getKeyStroke(accelerator));
        }
    }

    public Integer getMnemonic() {
        return (Integer)this.getValue("MnemonicKey");
    }

    public void setMnemonic(int mnemonic) {
        this.putValue("MnemonicKey", mnemonic);
    }

    protected FreeColClient getFreeColClient() {
        return this.freeColClient;
    }

    public boolean hasOrderButtons() {
        return this.orderButtonImageCount == 4;
    }

    protected void addImageIcons(String key) {
        Image normal = ResourceManager.getImage("orderButton.normal." + key);
        Image highlighted = ResourceManager.getImage("orderButton.highlighted." + key);
        Image pressed = ResourceManager.getImage("orderButton.pressed." + key);
        Image disabled = ResourceManager.getImage("orderButton.disabled." + key);
        this.orderButtonImageCount = (normal == null ? 0 : 1) + (highlighted == null ? 0 : 1) + (pressed == null ? 0 : 1) + (disabled == null ? 0 : 1);
        if (this.hasOrderButtons()) {
            this.putValue(BUTTON_IMAGE, new ImageIcon(normal));
            this.putValue(BUTTON_ROLLOVER_IMAGE, new ImageIcon(highlighted));
            this.putValue(BUTTON_PRESSED_IMAGE, new ImageIcon(pressed));
            this.putValue(BUTTON_DISABLED_IMAGE, new ImageIcon(disabled));
        } else {
            logger.warning("Missing " + (4 - this.orderButtonImageCount) + " orderButton images for " + this.getId());
        }
    }

    public void update() {
        boolean b = this.shouldBeEnabled();
        if (this.isEnabled() != b) {
            this.setEnabled(b);
        }
    }

    protected boolean shouldBeEnabled() {
        return this.freeColClient.getCanvas() != null && !this.freeColClient.getCanvas().isClientOptionsDialogShowing();
    }

    public void setAccelerator(KeyStroke accelerator) {
        this.putValue("AcceleratorKey", accelerator);
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public String getShortDescription() {
        return (String)this.getValue("ShortDescription");
    }

    public String toString() {
        return this.getName();
    }

    public String getId() {
        return (String)this.getValue(ACTION_ID);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public static String getKeyStrokeText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        return keyStroke.toString();
    }

    public boolean isPreviewEnabled() {
        return false;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(FreeColAction.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("accelerator", FreeColAction.getKeyStrokeText(this.getAccelerator()));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        String acc = in.getAttributeValue(null, "accelerator");
        if (id == null) {
            id = in.getLocalName();
        }
        if (!acc.equals("")) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(acc));
        } else {
            this.putValue("AcceleratorKey", null);
        }
        in.nextTag();
    }

    public void toXML(XMLStreamWriter out) throws XMLStreamException {
        this.toXMLImpl(out);
    }

    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLImpl(in);
    }

    public Element toXMLElement(Document document) {
        try {
            StringWriter sw = new StringWriter();
            XMLOutputFactory xif = XMLOutputFactory.newInstance();
            XMLStreamWriter xsw = xif.createXMLStreamWriter(sw);
            this.toXML(xsw);
            xsw.close();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document tempDocument = null;
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                tempDocument = builder.parse(new InputSource(new StringReader(sw.toString())));
                return (Element)document.importNode(tempDocument.getDocumentElement(), true);
            }
            catch (ParserConfigurationException pce) {
                StringWriter swe = new StringWriter();
                pce.printStackTrace(new PrintWriter(swe));
                logger.warning(swe.toString());
                throw new IllegalStateException("ParserConfigurationException");
            }
            catch (SAXException se) {
                StringWriter swe = new StringWriter();
                se.printStackTrace(new PrintWriter(swe));
                logger.warning(swe.toString());
                throw new IllegalStateException("SAXException");
            }
            catch (IOException ie) {
                StringWriter swe = new StringWriter();
                ie.printStackTrace(new PrintWriter(swe));
                logger.warning(swe.toString());
                throw new IllegalStateException("IOException");
            }
        }
        catch (XMLStreamException e) {
            logger.warning(e.toString());
            throw new IllegalStateException("XMLStreamException");
        }
    }

    public void readFromXMLElement(Element element) {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        try {
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer xmlTransformer = factory.newTransformer();
                StringWriter stringWriter = new StringWriter();
                xmlTransformer.transform(new DOMSource(element), new StreamResult(stringWriter));
                String xml = stringWriter.toString();
                XMLStreamReader xsr = xif.createXMLStreamReader(new StringReader(xml));
                xsr.nextTag();
                this.readFromXML(xsr);
            }
            catch (TransformerException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                logger.warning(sw.toString());
                throw new IllegalStateException("TransformerException");
            }
        }
        catch (XMLStreamException e) {
            logger.warning(e.toString());
            throw new IllegalStateException("XMLStreamException");
        }
    }

    public MenuKeyListener getMenuKeyListener() {
        return new InnerMenuKeyListener();
    }

    public static String getXMLElementTagName() {
        return "action";
    }

    public class InnerMenuKeyListener
    implements MenuKeyListener {
        int mnemonic;

        public InnerMenuKeyListener() {
            this.mnemonic = (Integer)FreeColAction.this.getValue("MnemonicKey");
        }

        public void menuKeyPressed(MenuKeyEvent e) {
            if (e.getKeyCode() == this.mnemonic) {
                ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), (String)FreeColAction.this.getValue("Name"), e.getModifiers());
                FreeColAction.this.actionPerformed(ae);
                e.consume();
            }
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
        }
    }
}

