/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.BooleanOption;

public final class BooleanOptionUI
extends JCheckBox
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(BooleanOptionUI.class.getName());
    private final BooleanOption option;
    private boolean originalValue;

    public BooleanOptionUI(final BooleanOption option, boolean editable) {
        this.option = option;
        this.originalValue = option.getValue();
        String name = Messages.getName(option);
        String description = Messages.getShortDescription(option);
        this.setText(name);
        this.setSelected(option.getValue());
        this.setEnabled(editable);
        this.setToolTipText(description != null ? description : name);
        option.addPropertyChangeListener(this);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (option.isPreviewEnabled()) {
                    boolean value = BooleanOptionUI.this.isSelected();
                    if (option.getValue() != value) {
                        option.setValue(value);
                    }
                }
            }
        });
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        boolean value;
        if (event.getPropertyName().equals("value") && (value = ((Boolean)event.getNewValue()).booleanValue()) != this.isSelected()) {
            this.setSelected(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue(this.isSelected());
    }

    public void reset() {
        this.setSelected(this.option.getValue());
    }

    public void setValue(boolean b) {
        this.setSelected(b);
    }
}

