/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.RangeOption;

public final class RangeOptionUI
extends JSlider
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(RangeOptionUI.class.getName());
    private final RangeOption option;
    private int originalValue;

    public RangeOptionUI(final RangeOption option, boolean editable) {
        this.option = option;
        this.originalValue = option.getValue();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Messages.getName(option)));
        String name = Messages.getName(option);
        String description = Messages.getShortDescription(option);
        this.setModel(new DefaultBoundedRangeModel(option.getValueRank(), 0, 0, option.getItemValues().size() - 1));
        this.setOrientation(0);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        int index = 0;
        for (String string : option.getItemValues().values()) {
            if (option.localizeLabels()) {
                labels.put(index, new JLabel(Messages.message(string)));
            } else {
                labels.put(index, new JLabel(string));
            }
            ++index;
        }
        this.setLabelTable(labels);
        this.setValue(option.getValueRank());
        this.setPaintLabels(true);
        this.setMajorTickSpacing(1);
        this.setExtent(0);
        this.setPaintTicks(true);
        this.setSnapToTicks(true);
        this.setPreferredSize(new Dimension(500, 50));
        this.setToolTipText(description != null ? description : name);
        this.setEnabled(editable);
        this.setOpaque(false);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (option.isPreviewEnabled()) {
                    int value = RangeOptionUI.this.getValue();
                    if (option.getValue() != value) {
                        option.setValueRank(value);
                    }
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        int value;
        if (event.getPropertyName().equals("value") && (value = ((Integer)event.getNewValue()).intValue()) != this.getValue()) {
            this.setValue(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValueRank(this.getValue());
    }

    public void reset() {
        this.setValue(this.option.getValueRank());
    }
}

