/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public class BuildingToolTip
extends JToolTip {
    private static final JLabel arrow = new JLabel("\u2192");

    public BuildingToolTip(Building building, Canvas parent) {
        int workplaces = building.getUnitCapacity();
        String columns = "[align center]";
        for (int index = 0; index < workplaces; ++index) {
            columns = columns + "20[]5[]";
        }
        MigLayout layout = new MigLayout("fill, insets 20, wrap " + (2 * workplaces + 1), columns, "[][][align bottom]");
        this.setLayout((LayoutManager)layout);
        JLabel buildingName = new JLabel(Messages.message(building.getNameKey()));
        buildingName.setFont(ResourceManager.getFont("SimpleFont", 1, 16.0f));
        this.add((Component)buildingName, "span");
        ProductionInfo info = building.getProductionInfo();
        if (info.getProduction().isEmpty()) {
            this.add((Component)new JLabel(), "span");
        } else {
            AbstractGoods production = info.getProduction().get(0);
            AbstractGoods maximumProduction = info.getMaximumProduction().isEmpty() ? production : info.getMaximumProduction().get(0);
            ProductionLabel productionOutput = new ProductionLabel(production, maximumProduction, parent);
            if (info.getConsumption().isEmpty()) {
                this.add((Component)productionOutput, "span");
            } else {
                AbstractGoods consumption = info.getConsumption().get(0);
                if (consumption.getAmount() > 0) {
                    AbstractGoods maximumConsumption = info.getMaximumConsumption().isEmpty() ? consumption : info.getMaximumConsumption().get(0);
                    ProductionLabel productionInput = new ProductionLabel(consumption, maximumConsumption, parent);
                    this.add((Component)productionInput, "span, split 3");
                    this.add(arrow);
                    this.add(productionOutput);
                } else {
                    this.add((Component)new JLabel(parent.getImageLibrary().getGoodsImageIcon(consumption.getType())), "span, split 3");
                    this.add(arrow);
                    this.add(new JLabel(parent.getImageLibrary().getGoodsImageIcon(production.getType())));
                }
            }
        }
        this.add(new JLabel(new ImageIcon(ResourceManager.getImage(building.getType().getId() + ".image"))));
        for (Unit unit : building.getUnitList()) {
            UnitLabel unitLabel = new UnitLabel(unit, parent, false);
            if (building.canTeach() && unit.getStudent() != null) {
                JLabel progress = new JLabel(unit.getTurnsOfTraining() + "/" + unit.getNeededTurnsOfTraining());
                UnitLabel studentLabel = new UnitLabel(unit.getStudent(), parent, true);
                studentLabel.setIgnoreLocation(true);
                this.add(unitLabel);
                this.add((Component)progress, "split 2, flowy");
                this.add(studentLabel);
                continue;
            }
            this.add((Component)unitLabel, "span 2");
        }
        int diff = building.getUnitCapacity() - building.getUnitList().size();
        for (int index = 0; index < diff; ++index) {
            this.add((Component)new JLabel(new ImageIcon(ResourceManager.getImage("placeholder.image"))), "span 2");
        }
        this.setPreferredSize(layout.preferredLayoutSize((Container)this));
    }

    static {
        arrow.setFont(ResourceManager.getFont("SimpleFont", 1, 24.0f));
    }
}

