/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

public class CargoPanel
extends FreeColPanel
implements PropertyChangeListener {
    private static Logger logger = Logger.getLogger(CargoPanel.class.getName());
    private Unit carrier = null;
    private final DefaultTransferHandler defaultTransferHandler;
    private final MouseListener pressListener;
    private final TitledBorder border;
    private JPanel parentPanel;

    public CargoPanel(Canvas parent, boolean withTitle) {
        super(parent);
        this.defaultTransferHandler = new DefaultTransferHandler(parent, this);
        this.pressListener = new DragListener(this);
        this.border = withTitle ? BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("cargoOnCarrier")) : null;
        this.setBorder(this.border);
        this.initialize();
    }

    public final JPanel getParentPanel() {
        return this.parentPanel;
    }

    public final void setParentPanel(JPanel newParentPanel) {
        this.parentPanel = newParentPanel;
    }

    public boolean isActive() {
        return this.carrier != null;
    }

    public Unit getCarrier() {
        return this.carrier;
    }

    public void setCarrier(Unit newCarrier) {
        this.removePropertyChangeListeners();
        this.carrier = newCarrier;
        this.addPropertyChangeListeners();
        this.update();
    }

    public void initialize() {
        this.update();
    }

    public void cleanup() {
        this.removePropertyChangeListeners();
    }

    public void update() {
        this.removeAll();
        if (this.carrier != null) {
            Iterator<Unit> unitIterator = this.carrier.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit unit = unitIterator.next();
                UnitLabel label = new UnitLabel(unit, this.getCanvas());
                if (this.isEditable()) {
                    label.setTransferHandler(this.defaultTransferHandler);
                    label.addMouseListener(this.pressListener);
                }
                this.add(label);
            }
            Iterator<Goods> goodsIterator = this.carrier.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods g = goodsIterator.next();
                GoodsLabel label = new GoodsLabel(g, this.getCanvas());
                if (this.isEditable()) {
                    label.setTransferHandler(this.defaultTransferHandler);
                    label.addMouseListener(this.pressListener);
                }
                this.add(label);
            }
        }
        this.updateTitle();
        this.revalidate();
        this.repaint();
    }

    private void updateTitle() {
        if (this.border == null) {
            return;
        }
        if (this.carrier == null) {
            this.border.setTitle(Messages.message("cargoOnCarrier"));
        } else {
            int spaceLeft = this.carrier.getSpaceLeft();
            StringTemplate t = StringTemplate.template("cargoOnCarrierLong").addStringTemplate("%name%", Messages.getLabel(this.carrier)).addAmount("%space%", spaceLeft);
            this.border.setTitle(Messages.message(t));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component add(Component comp, boolean editState) {
        if (this.carrier == null) {
            return null;
        }
        if (editState) {
            if (comp instanceof UnitLabel) {
                Unit unit = ((UnitLabel)comp).getUnit();
                if (!this.carrier.canAdd(unit)) return null;
                Container oldParent = comp.getParent();
                if (!this.getController().boardShip(unit, this.carrier)) return null;
                ((UnitLabel)comp).setSmall(false);
                oldParent.remove(comp);
                this.update();
                return comp;
            }
            if (comp instanceof GoodsLabel) {
                Goods goods = ((GoodsLabel)comp).getGoods();
                int loadableAmount = this.carrier.getLoadableAmount(goods.getType());
                if (loadableAmount == 0) {
                    return null;
                }
                if (loadableAmount > goods.getAmount()) {
                    loadableAmount = goods.getAmount();
                }
                Goods goodsToAdd = new Goods(goods.getGame(), goods.getLocation(), goods.getType(), loadableAmount);
                goods.setAmount(goods.getAmount() - loadableAmount);
                this.getController().loadCargo(goodsToAdd, this.carrier);
                this.update();
                return comp;
            }
            if (!(comp instanceof MarketLabel)) return null;
            MarketLabel label = (MarketLabel)comp;
            Player player = this.carrier.getOwner();
            if (player.canTrade(label.getType())) {
                this.getController().buyGoods(label.getType(), label.getAmount(), this.carrier);
                this.getController().nextModelMessage();
                this.update();
                return comp;
            }
            this.getController().payArrears(label.getType());
            return null;
        }
        super.add(comp);
        return null;
    }

    public void remove(Component comp) {
        if (comp instanceof UnitLabel) {
            Unit unit = ((UnitLabel)comp).getUnit();
            this.getController().leaveShip(unit);
            this.update();
        } else if (comp instanceof GoodsLabel) {
            Goods g = ((GoodsLabel)comp).getGoods();
            this.getController().unloadCargo(g, false);
            this.update();
        }
    }

    public void addPropertyChangeListeners() {
        if (this.carrier != null) {
            this.carrier.addPropertyChangeListener("CARGO_CHANGE", this);
            this.carrier.getGoodsContainer().addPropertyChangeListener(this);
        }
    }

    public void removePropertyChangeListeners() {
        if (this.carrier != null) {
            this.carrier.removePropertyChangeListener("CARGO_CHANGE", this);
            this.carrier.getGoodsContainer().removePropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        logger.finest("CargoPanel change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
        this.update();
    }

    public String getUIClassID() {
        return "CargoPanelUI";
    }
}

