/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.FAFile;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeclarationDialog
extends FreeColDialog<Boolean> {
    private static final Logger logger = Logger.getLogger(DeclarationDialog.class.getName());
    private final SignaturePanel signaturePanel;
    final DeclarationDialog theDialog = this;

    public DeclarationDialog(Canvas parent) {
        super(parent);
        this.signaturePanel = new SignaturePanel();
        this.setLayout(null);
        Image image = ResourceManager.getImage("Declaration.image");
        this.setSize(image.getWidth(null), image.getHeight(null));
        this.setOpaque(false);
        this.setBorder(null);
        this.signaturePanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ActionListener al = new ActionListener(){

                    public void actionPerformed(ActionEvent e2) {
                        DeclarationDialog.this.theDialog.setResponse(Boolean.TRUE);
                    }
                };
                Timer t = new Timer(10000, al);
                t.setRepeats(false);
                t.start();
            }
        });
        this.add(this.signaturePanel);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DeclarationDialog.this.theDialog.setResponse(Boolean.TRUE);
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        Image image = ResourceManager.getImage("Declaration.image");
        g.drawImage(image, 0, 0, null);
    }

    @Override
    public void initialize() {
        int SIGNATURE_Y = 450;
        this.resetResponse();
        this.signaturePanel.initialize(this.getMyPlayer().getName());
        this.signaturePanel.setLocation((this.getWidth() - this.signaturePanel.getWidth()) / 2, (this.getHeight() + 450 - this.signaturePanel.getHeight()) / 2 - 15);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeclarationDialog.this.signaturePanel.startAnimation();
            }
        };
        Timer t = new Timer(3000, al);
        t.setRepeats(false);
        t.start();
    }

    private class SignaturePanel
    extends JPanel {
        private FAFile faFile;
        private ArrayList<ActionListener> actionListeners = new ArrayList();
        private Point[] points = null;
        private int counter = 0;

        SignaturePanel() {
            this.faFile = ResourceManager.getFAFile("AnimatedFont");
            this.setOpaque(false);
        }

        private String getAbbreviatedName(String name) {
            if (!this.isTooLarge(name)) {
                return name;
            }
            String[] partNames = name.split(" ");
            for (int i = 1; i < partNames.length - 1 && this.isTooLarge(Utils.join(" ", partNames)); ++i) {
                partNames[i] = partNames[i].charAt(0) + ".";
            }
            while (partNames.length > 2 && this.isTooLarge(Utils.join(" ", partNames))) {
                String[] newPartNames = new String[partNames.length - 1];
                newPartNames[0] = partNames[0];
                for (int i = 1; i < newPartNames.length; ++i) {
                    newPartNames[i] = partNames[i + 1];
                }
                partNames = newPartNames;
            }
            if (!this.isTooLarge(Utils.join(" ", partNames))) {
                return Utils.join(" ", partNames);
            }
            if (!this.isTooLarge(partNames[0].charAt(0) + ". " + partNames[1])) {
                return partNames[0].charAt(0) + ". " + partNames[1];
            }
            if (!this.isTooLarge(partNames[0] + " " + partNames[1].charAt(0) + ".")) {
                return partNames[0] + " " + partNames[1].charAt(0) + ".";
            }
            return partNames[0].charAt(0) + ". " + partNames[1].charAt(0) + ".";
        }

        private boolean isTooLarge(String name) {
            Dimension d = this.faFile.getDimension(name);
            return d.width > DeclarationDialog.this.theDialog.getWidth() - 10;
        }

        public void initialize(String name) {
            name = this.getAbbreviatedName(name);
            this.points = this.faFile.getPoints(name);
            this.counter = 0;
            this.setSize(this.faFile.getDimension(name));
        }

        public void addActionListener(ActionListener al) {
            if (!this.actionListeners.contains(al)) {
                this.actionListeners.add(al);
            }
        }

        private void notifyStopped() {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                this.actionListeners.get(i).actionPerformed(new ActionEvent(this, 1001, "AnimationStopped"));
            }
        }

        public void startAnimation() {
            int delay = 50;
            ActionListener taskPerformer = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (SignaturePanel.this.counter < SignaturePanel.this.points.length - 1) {
                        SignaturePanel.this.counter += 20;
                        if (SignaturePanel.this.counter > SignaturePanel.this.points.length) {
                            SignaturePanel.this.counter = SignaturePanel.this.points.length - 1;
                            ((Timer)evt.getSource()).stop();
                            SignaturePanel.this.notifyStopped();
                        }
                        SignaturePanel.this.repaint();
                    } else {
                        ((Timer)evt.getSource()).stop();
                        SignaturePanel.this.notifyStopped();
                    }
                }
            };
            new Timer(delay, taskPerformer).start();
        }

        public void paintComponent(Graphics g) {
            if (this.points == null || this.points.length == 0) {
                return;
            }
            if (this.isOpaque()) {
                super.paintComponent(g);
            }
            g.setColor(Color.BLACK);
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.75f));
            for (int i = 0; i < this.counter; ++i) {
                Point p = this.points[i];
                g.drawLine((int)p.getX(), (int)p.getY(), (int)p.getX(), (int)p.getY());
            }
        }
    }
}

