/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NegotiationDialog
extends FreeColDialog<DiplomaticTrade>
implements ActionListener {
    private static final String SEND = "send";
    private static final String ACCEPT = "accept";
    private static final String CANCEL = "cancel";
    private static Logger logger = Logger.getLogger(NegotiationDialog.class.getName());
    private DiplomaticTrade agreement;
    private JButton acceptButton;
    private JButton cancelButton;
    private JButton sendButton;
    private StanceTradeItemPanel stance;
    private GoldTradeItemPanel goldOffer;
    private GoldTradeItemPanel goldDemand;
    private ColonyTradeItemPanel colonyOffer;
    private ColonyTradeItemPanel colonyDemand;
    private GoodsTradeItemPanel goodsOffer;
    private GoodsTradeItemPanel goodsDemand;
    private JTextPane summary;
    private final Unit unit;
    private final Settlement settlement;
    private Player player;
    private Player otherPlayer;
    private Player sender;
    private Player recipient;
    private boolean canAccept;

    public NegotiationDialog(Canvas parent, Unit unit, Settlement settlement) {
        this(parent, unit, settlement, null);
    }

    public NegotiationDialog(Canvas parent, Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        super(parent);
        this.setFocusCycleRoot(true);
        this.unit = unit;
        this.settlement = settlement;
        this.player = this.getMyPlayer();
        this.sender = unit.getOwner();
        this.recipient = settlement.getOwner();
        this.canAccept = agreement != null;
        this.agreement = agreement == null ? new DiplomaticTrade(unit.getGame(), this.sender, this.recipient) : agreement;
        this.otherPlayer = this.sender == this.player ? this.recipient : this.sender;
        if (this.player.atWarWith(this.otherPlayer) && !this.hasPeaceOffer()) {
            Player.Stance stance = Player.Stance.PEACE;
            this.agreement.add(new StanceTradeItem(this.getGame(), this.player, this.otherPlayer, stance));
        }
        this.summary = NegotiationDialog.getDefaultTextPane();
        this.summary.setOpaque(false);
        this.summary.setEditable(false);
    }

    @Override
    public void initialize() {
        this.sendButton = new JButton(Messages.message("negotiationDialog.send"));
        this.sendButton.addActionListener(this);
        this.sendButton.setActionCommand(SEND);
        FreeColPanel.enterPressesWhenFocused(this.sendButton);
        this.acceptButton = new JButton(Messages.message("negotiationDialog.accept"));
        this.acceptButton.addActionListener(this);
        this.acceptButton.setActionCommand(ACCEPT);
        FreeColPanel.enterPressesWhenFocused(this.acceptButton);
        this.acceptButton.setEnabled(this.canAccept);
        this.cancelButton = new JButton(Messages.message("negotiationDialog.cancel"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(CANCEL);
        this.setCancelComponent(this.cancelButton);
        FreeColPanel.enterPressesWhenFocused(this.cancelButton);
        this.stance = new StanceTradeItemPanel(this, this.player, this.otherPlayer);
        this.goldDemand = new GoldTradeItemPanel(this, this.otherPlayer, 0);
        this.goldOffer = new GoldTradeItemPanel(this, this.player, 0);
        this.colonyDemand = new ColonyTradeItemPanel(this, this.otherPlayer);
        this.colonyOffer = new ColonyTradeItemPanel(this, this.player);
        this.setLayout((LayoutManager)new MigLayout("wrap 3", "[200, fill][300, fill][200, fill]", ""));
        this.add((Component)new JLabel(Messages.message("negotiationDialog.demand")), "center");
        this.add((Component)new JLabel(Messages.message("negotiationDialog.offer")), "skip, center");
        this.add((Component)this.stance, "skip 2");
        this.add(this.goldDemand);
        this.add((Component)this.summary, "spany");
        this.add(this.goldOffer);
        if (this.unit.isCarrier()) {
            this.goodsDemand = new GoodsTradeItemPanel(this, this.otherPlayer, null);
            this.add(this.goodsDemand);
            this.goodsOffer = new GoodsTradeItemPanel(this, this.player, null);
            this.add(this.goodsOffer);
        } else {
            this.add(this.colonyDemand);
            this.add(this.colonyOffer);
        }
        this.add((Component)this.sendButton, "newline 20, span, split 3");
        this.add((Component)this.acceptButton, "tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
        this.updateDialog();
    }

    private void updateSummary() {
        try {
            int end;
            StyledDocument document = this.summary.getStyledDocument();
            document.remove(0, document.getLength());
            String input = Messages.message("negotiationDialog.summary");
            int start = input.indexOf(37);
            if (start == -1) {
                this.insertText(input.substring(0));
                return;
            }
            if (start > 0) {
                this.insertText(input.substring(0, start));
            }
            while ((end = input.indexOf(37, start + 1)) >= 0) {
                String var = input.substring(start, end + 1);
                if (var.equals("%nation%")) {
                    this.insertText(Messages.message(this.sender.getNationName()));
                    start = end + 1;
                    continue;
                }
                if (var.equals("%offers%")) {
                    this.insertOffers();
                    start = end + 1;
                    continue;
                }
                if (var.equals("%demands%")) {
                    this.insertDemands();
                    start = end + 1;
                    continue;
                }
                this.insertText(input.substring(start, end));
                start = end;
            }
            if (start < input.length()) {
                this.insertText(input.substring(start));
            }
        }
        catch (Exception e) {
            logger.warning("Failed to update summary: " + e.toString());
        }
    }

    private void updateOfferItems() {
        this.stance.updateStanceBox();
        this.goldOffer.setAvailableGold(this.player.getGold());
        if (this.unit.isCarrier()) {
            Iterator<Goods> goodsInAgreement = this.agreement.getGoodsGivenBy(this.player).iterator();
            ArrayList<Goods> goodsAvail = new ArrayList<Goods>();
            goodsAvail.addAll(this.unit.getGoodsContainer().getGoods());
            block0: while (goodsInAgreement.hasNext()) {
                Goods goods = goodsInAgreement.next();
                for (int i = 0; i < goodsAvail.size(); ++i) {
                    Goods goodAvail = (Goods)goodsAvail.get(i);
                    if (goodAvail.getType() != goods.getType() || goodAvail.getAmount() != goods.getAmount()) continue;
                    goodsAvail.remove(i);
                    continue block0;
                }
            }
            this.goodsOffer.updateGoodsBox(goodsAvail);
        } else {
            this.colonyOffer.updateColonyBox();
        }
    }

    private void updateDemandItems() {
        NationSummary ns = this.getController().getNationSummary(this.otherPlayer);
        int foreignGold = ns == null ? 0 : ns.getGold();
        this.goldDemand.setAvailableGold(foreignGold);
        if (this.unit.isCarrier()) {
            Iterator<Goods> goodsInAgreement = this.agreement.getGoodsGivenBy(this.otherPlayer).iterator();
            ArrayList<Goods> goodsAvail = new ArrayList<Goods>();
            goodsAvail.addAll(this.settlement.getGoodsContainer().getGoods());
            block0: while (goodsInAgreement.hasNext()) {
                Goods goods = goodsInAgreement.next();
                for (int i = 0; i < goodsAvail.size(); ++i) {
                    Goods goodAvail = (Goods)goodsAvail.get(i);
                    if (goodAvail.getType() != goods.getType() || goodAvail.getAmount() != goods.getAmount()) continue;
                    goodsAvail.remove(i);
                    continue block0;
                }
            }
            this.goodsDemand.updateGoodsBox(goodsAvail);
        } else {
            this.colonyDemand.updateColonyBox();
        }
    }

    public void updateDialog() {
        this.updateOfferItems();
        this.updateDemandItems();
        this.updateSummary();
    }

    private void insertText(String text) throws Exception {
        StyledDocument document = this.summary.getStyledDocument();
        document.insertString(document.getLength(), text, document.getStyle("regular"));
    }

    private void insertOffers() {
        this.insertTradeItemDescriptions(this.sender);
    }

    private void insertDemands() {
        this.insertTradeItemDescriptions(this.recipient);
    }

    private void insertTradeItemDescriptions(Player itemSource) {
        StyledDocument document = this.summary.getStyledDocument();
        List<TradeItem> items = this.agreement.getTradeItems();
        boolean foundItem = false;
        for (int index = 0; index < items.size(); ++index) {
            TradeItem item = items.get(index);
            if (item.getSource() != itemSource) continue;
            foundItem = true;
            String description = "";
            if (item instanceof StanceTradeItem) {
                description = Messages.getStanceAsString(((StanceTradeItem)item).getStance());
            } else if (item instanceof GoldTradeItem) {
                int gold = ((GoldTradeItem)item).getGold();
                description = Messages.message(StringTemplate.template("tradeItem.gold.long").addAmount("%amount%", gold));
            } else if (item instanceof ColonyTradeItem) {
                description = Messages.message(StringTemplate.template("tradeItem.colony.long").addName("%colony%", ((ColonyTradeItem)item).getColonyName()));
            } else if (item instanceof GoodsTradeItem) {
                description = Messages.message(StringTemplate.template("model.goods.goodsAmount").addAmount("%amount%", ((GoodsTradeItem)item).getGoods().getAmount()).add("%goods%", ((GoodsTradeItem)item).getGoods().getNameKey()));
            } else if (item instanceof UnitTradeItem) {
                description = Messages.message(((UnitTradeItem)item).getUnit().getLabel());
            }
            try {
                JButton button = NegotiationDialog.getLinkButton(description, null, String.valueOf(index));
                button.addActionListener(this);
                StyleConstants.setComponent(document.getStyle("button"), button);
                document.insertString(document.getLength(), " ", document.getStyle("button"));
                if (index >= items.size() - 1) {
                    return;
                }
                document.insertString(document.getLength(), ", ", document.getStyle("regular"));
                continue;
            }
            catch (Exception e) {
                logger.warning(e.toString());
            }
        }
        if (!foundItem) {
            try {
                document.insertString(document.getLength(), Messages.message("negotiationDialog.nothing"), document.getStyle("regular"));
            }
            catch (Exception e) {
                logger.warning(e.toString());
            }
        }
    }

    private boolean hasPeaceOffer() {
        return this.getStance() != null;
    }

    public void addColonyTradeItem(Player source, Colony colony) {
        Player destination = source == this.otherPlayer ? this.player : this.otherPlayer;
        this.agreement.add(new ColonyTradeItem(this.getGame(), source, destination, colony));
    }

    public void addGoldTradeItem(Player source, int amount) {
        Player destination = source == this.otherPlayer ? this.player : this.otherPlayer;
        this.agreement.add(new GoldTradeItem(this.getGame(), source, destination, amount));
    }

    public void addGoodsTradeItem(Player source, Goods goods) {
        Player destination = source == this.otherPlayer ? this.player : this.otherPlayer;
        this.agreement.add(new GoodsTradeItem(this.getGame(), source, destination, goods, this.settlement));
    }

    public void setStance(Player.Stance stance) {
        this.agreement.add(new StanceTradeItem(this.getGame(), this.otherPlayer, this.player, stance));
    }

    public Player.Stance getStance() {
        return this.agreement.getStance();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(CANCEL)) {
            this.agreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
            this.setResponse(this.agreement);
        } else if (command.equals(ACCEPT)) {
            this.agreement.setStatus(DiplomaticTrade.TradeStatus.ACCEPT_TRADE);
            this.setResponse(this.agreement);
        } else if (command.equals(SEND)) {
            this.agreement.setStatus(DiplomaticTrade.TradeStatus.PROPOSE_TRADE);
            this.setResponse(this.agreement);
        } else {
            int index = Integer.parseInt(command);
            this.agreement.remove(index);
            this.updateDialog();
        }
    }

    public class GoldTradeItemPanel
    extends JPanel
    implements ActionListener {
        private JSpinner spinner;
        private JButton addButton;
        private Player player;
        private NegotiationDialog negotiationDialog;

        public GoldTradeItemPanel(NegotiationDialog parent, Player source, int gold) {
            this.player = source;
            this.negotiationDialog = parent;
            this.addButton = new JButton(Messages.message("negotiationDialog.add"));
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand("add");
            this.spinner = new JSpinner(new SpinnerNumberModel(0, 0, gold, 1));
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setColumns(5);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
            this.add(new JLabel(Messages.message("tradeItem.gold")));
            this.add(this.spinner);
            this.add(this.addButton);
        }

        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("add")) {
                int amount = (Integer)this.spinner.getValue();
                this.negotiationDialog.addGoldTradeItem(this.player, amount);
                NegotiationDialog.this.updateDialog();
            }
        }

        public void setAvailableGold(int gold) {
            SpinnerNumberModel model = (SpinnerNumberModel)this.spinner.getModel();
            model.setMaximum(new Integer(gold));
        }
    }

    public class StanceTradeItemPanel
    extends JPanel
    implements ActionListener {
        private JComboBox stanceBox;
        private JButton addButton;
        private NegotiationDialog negotiationDialog;
        private Player source;
        private Player target;

        public StanceTradeItemPanel(NegotiationDialog parent, Player source, Player target) {
            this.negotiationDialog = parent;
            this.source = source;
            this.target = target;
            this.addButton = new JButton(Messages.message("negotiationDialog.add"));
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand("add");
            this.stanceBox = new JComboBox();
            this.updateStanceBox();
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
            this.add(new JLabel(Messages.message("tradeItem.stance")));
            this.add(this.stanceBox);
            this.add(this.addButton);
        }

        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("add")) {
                StanceItem stance = (StanceItem)this.stanceBox.getSelectedItem();
                this.negotiationDialog.setStance(stance.getValue());
                NegotiationDialog.this.updateSummary();
            }
        }

        public void updateStanceBox() {
            this.stanceBox.removeAllItems();
            Player.Stance stance = this.source.getStance(this.target);
            if (stance != Player.Stance.WAR) {
                this.stanceBox.addItem(new StanceItem(Player.Stance.WAR));
            }
            if (stance == Player.Stance.WAR) {
                this.stanceBox.addItem(new StanceItem(Player.Stance.CEASE_FIRE));
            }
            if (stance != Player.Stance.PEACE && stance != Player.Stance.UNCONTACTED) {
                this.stanceBox.addItem(new StanceItem(Player.Stance.PEACE));
            }
            if (stance != Player.Stance.ALLIANCE) {
                this.stanceBox.addItem(new StanceItem(Player.Stance.ALLIANCE));
            }
            if (this.negotiationDialog.hasPeaceOffer()) {
                this.stanceBox.setSelectedItem(new StanceItem(this.negotiationDialog.getStance()));
            }
        }

        class StanceItem {
            private Player.Stance value;

            StanceItem(Player.Stance value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.value = value;
            }

            public String toString() {
                return Messages.getStanceAsString(this.value);
            }

            Player.Stance getValue() {
                return this.value;
            }

            public boolean equals(Object other) {
                if (other == null || !(other instanceof StanceItem)) {
                    return false;
                }
                return this.value.equals((Object)((StanceItem)other).value);
            }

            public int hashCode() {
                return this.value.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GoodsTradeItemPanel
    extends JPanel
    implements ActionListener {
        private JComboBox goodsBox;
        private JButton addButton;
        private Player player;
        private NegotiationDialog negotiationDialog;
        private JLabel label;

        public GoodsTradeItemPanel(NegotiationDialog parent, Player source, List<Goods> allGoods) {
            this.player = source;
            this.negotiationDialog = parent;
            this.addButton = new JButton(Messages.message("negotiationDialog.add"));
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand("add");
            this.goodsBox = new JComboBox();
            this.label = new JLabel(Messages.message("tradeItem.goods"));
            this.updateGoodsBox(allGoods);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
            this.add(this.label);
            this.add(this.goodsBox);
            this.add(this.addButton);
            this.setSize(this.getPreferredSize());
        }

        private void updateGoodsBox(List<Goods> allGoods) {
            ActionListener[] listeners;
            for (ActionListener al : listeners = this.goodsBox.getActionListeners()) {
                this.goodsBox.removeActionListener(al);
            }
            this.goodsBox.removeAllItems();
            if (allGoods != null && !allGoods.isEmpty()) {
                for (Goods goods : allGoods) {
                    if (!goods.getType().isStorable()) continue;
                    this.goodsBox.addItem(goods);
                }
                for (ActionListener al : listeners) {
                    this.goodsBox.addActionListener(al);
                }
                this.label.setEnabled(true);
                this.addButton.setEnabled(true);
                this.goodsBox.setEnabled(true);
            } else {
                this.label.setEnabled(false);
                this.addButton.setEnabled(false);
                this.goodsBox.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("add")) {
                this.negotiationDialog.addGoodsTradeItem(this.player, (Goods)this.goodsBox.getSelectedItem());
                NegotiationDialog.this.updateDialog();
            }
        }
    }

    public class ColonyTradeItemPanel
    extends JPanel
    implements ActionListener {
        private JComboBox colonyBox;
        private JButton addButton;
        private Player player;
        private NegotiationDialog negotiationDialog;
        private JLabel textLabel;

        public ColonyTradeItemPanel(NegotiationDialog parent, Player source) {
            this.player = source;
            this.negotiationDialog = parent;
            this.addButton = new JButton(Messages.message("negotiationDialog.add"));
            this.addButton.addActionListener(this);
            this.addButton.setActionCommand("add");
            this.colonyBox = new JComboBox();
            this.updateColonyBox();
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.textLabel = new JLabel(Messages.message("tradeItem.colony"));
            this.add(this.textLabel);
            this.add(this.colonyBox);
            this.add(this.addButton);
        }

        private void updateColonyBox() {
            ActionListener[] listeners;
            if (!this.player.isEuropean()) {
                return;
            }
            for (ActionListener al : listeners = this.colonyBox.getActionListeners()) {
                this.colonyBox.removeActionListener(al);
            }
            this.colonyBox.removeAllItems();
            Iterator<Colony> coloniesInAgreement = NegotiationDialog.this.agreement.getColoniesGivenBy(this.player).iterator();
            List<Colony> coloniesAvail = NegotiationDialog.this.getClientOptions().getSortedColonies(this.player);
            block1: while (coloniesInAgreement.hasNext()) {
                Colony colony = coloniesInAgreement.next();
                for (int i = 0; i < coloniesAvail.size(); ++i) {
                    Colony colonyAvail = coloniesAvail.get(i);
                    if (colonyAvail != colony) continue;
                    coloniesAvail.remove(i);
                    continue block1;
                }
            }
            if (coloniesAvail.isEmpty()) {
                this.addButton.setEnabled(false);
                this.colonyBox.setEnabled(false);
            } else {
                for (Colony c : coloniesAvail) {
                    this.colonyBox.addItem(c);
                }
                for (ActionListener al : listeners) {
                    this.colonyBox.addActionListener(al);
                }
                this.addButton.setEnabled(true);
                this.colonyBox.setEnabled(true);
            }
        }

        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("add")) {
                this.negotiationDialog.addColonyTradeItem(this.player, (Colony)this.colonyBox.getSelectedItem());
                NegotiationDialog.this.updateDialog();
            }
        }
    }
}

