/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionGroupUI;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.option.OptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionsDialog
extends FreeColDialog<OptionGroup> {
    private static final Logger logger = Logger.getLogger(OptionsDialog.class.getName());
    private static final String RESET = "RESET";
    private static final String SAVE = "SAVE";
    protected static final String LOAD = "LOAD";
    private OptionGroupUI ui;
    private OptionGroup group;
    private JButton reset = new JButton(Messages.message("reset"));
    private JButton load = new JButton(Messages.message("load"));
    protected JButton save = new JButton(Messages.message("save"));
    private JPanel optionPanel;
    private List<JButton> buttons = new ArrayList<JButton>();
    protected static final FileFilter[] filters = new FileFilter[]{new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".xml");
        }

        public String getDescription() {
            return Messages.message("filter.xml");
        }
    }};

    public OptionsDialog(Canvas parent, boolean editable) {
        super(parent);
        this.editable = editable;
        this.setLayout((LayoutManager)new MigLayout("wrap 1, fill"));
        this.reset.setActionCommand(RESET);
        this.reset.addActionListener(this);
        this.load.setActionCommand(LOAD);
        this.load.addActionListener(this);
        this.save.setActionCommand(SAVE);
        this.save.addActionListener(this);
        this.buttons.add(this.reset);
        this.buttons.add(this.load);
        this.buttons.add(this.save);
        this.setCancelComponent(this.cancelButton);
        this.setSize(850, 600);
    }

    protected void initialize(OptionGroup group, String header, Component component) {
        this.group = group;
        this.removeAll();
        this.add((Component)OptionsDialog.getDefaultHeader(header), "center");
        if (component != null) {
            this.add(component);
        }
        this.ui = new OptionGroupUI(group, this.isEditable());
        this.optionPanel = new JPanel(){

            public String getUIClassID() {
                return "ReportPanelUI";
            }
        };
        this.optionPanel.setOpaque(true);
        this.optionPanel.add(this.ui);
        JScrollPane scrollPane = new JScrollPane(this.optionPanel, 20, 30);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)scrollPane, "height 100%, width 100%");
        if (this.isEditable()) {
            int cells = this.buttons.size() + 2;
            this.add((Component)this.okButton, "newline 20, tag ok, split " + cells);
            this.add((Component)this.cancelButton, "tag cancel");
            for (JButton button : this.buttons) {
                this.add(button);
            }
        } else {
            this.add((Component)this.okButton, "newline 20, tag ok");
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(850, 700);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    protected OptionGroupUI getOptionUI() {
        return this.ui;
    }

    protected boolean isGroupEditable() {
        return this.isEditable();
    }

    protected List<JButton> getButtons() {
        return this.buttons;
    }

    protected void updateUI(OptionGroup group) {
        this.group = group;
        this.optionPanel.removeAll();
        this.ui = new OptionGroupUI(group, this.isEditable());
        this.optionPanel.add(this.ui);
        this.revalidate();
        this.repaint();
    }

    protected OptionGroup getGroup() {
        return this.group;
    }

    public abstract String getDefaultFileName();

    public abstract String getOptionGroupId();

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.ui.updateOption();
            this.ui.unregister();
            this.getCanvas().remove(this);
            this.setResponse(this.group);
        } else if ("CANCEL".equals(command)) {
            this.ui.rollback();
            this.ui.unregister();
            this.getCanvas().remove(this);
            this.setResponse(null);
        } else if (RESET.equals(command)) {
            this.ui.reset();
            this.revalidate();
            this.repaint();
        } else if (SAVE.equals(command)) {
            File saveFile = this.getCanvas().showSaveDialog(FreeCol.getOptionsDirectory(), ".xml", filters, this.getDefaultFileName());
            if (saveFile != null) {
                this.ui.updateOption();
                try {
                    this.group.save(saveFile);
                }
                catch (FileNotFoundException e) {
                    logger.warning(e.toString());
                    StringTemplate t = StringTemplate.template("failedToSave").addName("%name%", saveFile.getPath());
                    this.getCanvas().showInformationMessage(t);
                }
            }
        } else if (LOAD.equals(command)) {
            File loadFile = this.getCanvas().showLoadDialog(FreeCol.getOptionsDirectory(), filters);
            if (loadFile != null) {
                this.load(loadFile);
            }
        } else {
            logger.warning("Invalid ActionCommand: " + command);
        }
    }

    protected void load(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(in);
            xsr.nextTag();
            this.getSpecification().getOptionGroup(this.getOptionGroupId()).setValue(new OptionGroup(xsr));
            in.close();
            logger.info("Loaded custom options from file " + file.getPath());
        }
        catch (Exception e) {
            logger.warning("Failed to load OptionGroup with ID " + this.getOptionGroupId() + " from " + file.getName() + ": " + e.toString());
        }
    }

    protected boolean loadCustomOptions() {
        File customFile = new File(FreeCol.getOptionsDirectory(), this.getDefaultFileName());
        if (customFile.exists()) {
            this.load(customFile);
            return true;
        }
        return false;
    }
}

