/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.resources.ResourceManager;

public final class ProductionLabel
extends AbstractGoodsLabel {
    private static Logger logger = Logger.getLogger(ProductionLabel.class.getName());
    private int maxIcons = 7;
    private boolean drawPlus = false;
    private boolean centered = true;
    private int compressedWidth = -1;
    private ImageIcon goodsIcon;
    private int maximumProduction = this.maximumProduction;
    private int displayNumber;
    private int stockNumber = -1;
    private String toolTipPrefix = null;
    private Image stringImage = null;

    public ProductionLabel(AbstractGoods goods, Canvas parent) {
        this(goods, -1, parent);
    }

    public ProductionLabel(AbstractGoods goods, AbstractGoods maximum, Canvas parent) {
        this(goods, maximum.getAmount(), parent);
    }

    public ProductionLabel(GoodsType goodsType, int amount, Canvas parent) {
        this(new AbstractGoods(goodsType, amount), -1, parent);
    }

    public ProductionLabel(AbstractGoods goods, int maximum, Canvas parent) {
        super(goods, parent, false);
        ClientOptions options = parent.getFreeColClient().getClientOptions();
        this.maxIcons = options.getInteger("model.option.guiMaxNumberOfGoodsImages");
        this.displayNumber = options.getInteger("model.option.guiMinNumberToDisplayGoodsCount");
        this.setFont(ResourceManager.getFont("SimpleFont", 1, 12.0f));
        if (goods.getAmount() < 0) {
            this.setForeground(Color.RED);
        } else {
            this.setForeground(Color.WHITE);
        }
        if (goods.getType() != null) {
            this.setGoodsIcon(parent.getImageLibrary().getGoodsImageIcon(goods.getType()));
            this.updateToolTipText();
        }
    }

    public String getToolTipPrefix() {
        return this.toolTipPrefix;
    }

    public void setToolTipPrefix(String newToolTipPrefix) {
        this.toolTipPrefix = newToolTipPrefix;
        this.updateToolTipText();
    }

    public int getDisplayNumber() {
        return this.displayNumber;
    }

    public void setDisplayNumber(int newDisplayNumber) {
        this.displayNumber = newDisplayNumber;
    }

    public ImageIcon getGoodsIcon() {
        return this.goodsIcon;
    }

    public void setGoodsIcon(ImageIcon newGoodsIcon) {
        this.goodsIcon = newGoodsIcon;
        this.compressedWidth = this.goodsIcon.getIconWidth() * 2;
    }

    public void setProduction(int newProduction) {
        this.getGoods().setAmount(newProduction);
        this.updateToolTipText();
    }

    private void updateToolTipText() {
        if (this.getType() == null || this.getAmount() == 0) {
            this.setToolTipText(null);
        } else {
            String text = Messages.message(StringTemplate.template("model.goods.goodsAmount").add("%goods%", this.getGoods().getNameKey()).addAmount("%amount%", this.getAmount()));
            if (this.toolTipPrefix != null) {
                text = this.toolTipPrefix + " " + text;
            }
            this.setToolTipText(text);
        }
    }

    public int getMaximumProduction() {
        return this.maximumProduction;
    }

    public void setMaximumProduction(int newMaximumProduction) {
        this.maximumProduction = newMaximumProduction;
    }

    public int getMaxGoodsIcons() {
        return this.maxIcons;
    }

    public void setMaxGoodsIcons(int newMaxGoodsIcons) {
        this.maxIcons = newMaxGoodsIcons;
    }

    public int getStockNumber() {
        return this.stockNumber;
    }

    public void setStockNumber(int newStockNumber) {
        this.stockNumber = newStockNumber;
    }

    public boolean drawPlus() {
        return this.drawPlus;
    }

    public void setDrawPlus(boolean newDrawPlus) {
        this.drawPlus = newDrawPlus;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean newCentered) {
        this.centered = newCentered;
    }

    public int getCompressedWidth() {
        return this.compressedWidth;
    }

    public void setCompressedWidth(int newCompressedWidth) {
        this.compressedWidth = newCompressedWidth;
    }

    public Dimension getPreferredSize() {
        if (this.goodsIcon == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.getPreferredWidth(), this.goodsIcon.getImage().getHeight(null));
    }

    public int getPreferredWidth() {
        int maxSpacing;
        boolean iconsTooFarApart;
        if (this.goodsIcon == null) {
            return 0;
        }
        int drawImageCount = Math.max(1, Math.min(Math.abs(this.getAmount()), this.maxIcons));
        int iconWidth = this.goodsIcon.getIconWidth();
        int pixelsPerIcon = iconWidth / 2;
        if (pixelsPerIcon - iconWidth < 0) {
            pixelsPerIcon = (this.compressedWidth - iconWidth) / drawImageCount;
        }
        boolean bl = iconsTooFarApart = pixelsPerIcon > (maxSpacing = iconWidth);
        if (iconsTooFarApart) {
            pixelsPerIcon = maxSpacing;
        }
        int width = pixelsPerIcon * (drawImageCount - 1) + iconWidth;
        if (this.getStringImage() == null) {
            return width;
        }
        return Math.max(this.getStringImage().getWidth(null), width);
    }

    public void paintComponent(Graphics g) {
        int maxSpacing;
        boolean iconsTooFarApart;
        int iconWidth;
        int pixelsPerIcon;
        if (this.goodsIcon == null || this.getAmount() == 0 && this.stockNumber < 0) {
            logger.fine("Empty production label: fix this!");
            return;
        }
        int stringWidth = this.getStringImage() == null ? 0 : this.getStringImage().getWidth(null);
        int drawImageCount = Math.min(Math.abs(this.getAmount()), this.maxIcons);
        if (drawImageCount == 0) {
            drawImageCount = 1;
        }
        if ((pixelsPerIcon = (iconWidth = this.goodsIcon.getIconWidth()) / 2) - iconWidth < 0) {
            pixelsPerIcon = (this.compressedWidth - iconWidth) / drawImageCount;
        }
        boolean bl = iconsTooFarApart = pixelsPerIcon > (maxSpacing = iconWidth);
        if (iconsTooFarApart) {
            pixelsPerIcon = maxSpacing;
        }
        int coverage = pixelsPerIcon * (drawImageCount - 1) + iconWidth;
        int leftOffset = 0;
        int width = Math.max(this.getWidth(), Math.max(stringWidth, coverage));
        if (this.centered && coverage < width) {
            leftOffset = (width - coverage) / 2;
        }
        int height = Math.max(this.getHeight(), this.goodsIcon.getImage().getHeight(null));
        this.setSize(new Dimension(width, height));
        for (int i = 0; i < drawImageCount; ++i) {
            this.goodsIcon.paintIcon(null, g, leftOffset + i * pixelsPerIcon, 0);
        }
        if (this.stringImage != null) {
            int textOffset = width > stringWidth ? (width - stringWidth) / 2 : 0;
            textOffset = textOffset >= 0 ? textOffset : 0;
            g.drawImage(this.stringImage, textOffset, this.goodsIcon.getIconHeight() / 2 - this.stringImage.getHeight(null) / 2, null);
        }
    }

    private Image getStringImage() {
        if (this.stringImage == null && (this.getAmount() >= this.displayNumber || this.getAmount() < 0 || this.maxIcons < this.getAmount() || this.stockNumber > 0 || this.maximumProduction > this.getAmount() && this.getAmount() > 0)) {
            String number = "";
            if (this.stockNumber >= 0) {
                number = Integer.toString(this.stockNumber);
                this.drawPlus = true;
            }
            number = this.getAmount() >= 0 && this.drawPlus ? number + "+" + Integer.toString(this.getAmount()) : number + Integer.toString(this.getAmount());
            if (this.maximumProduction > this.getAmount() && this.getAmount() > 0) {
                number = number + "/" + String.valueOf(this.maximumProduction);
            }
            Font font = ResourceManager.getFont("SimpleFont", 1, 12.0f);
            this.stringImage = this.getCanvas().getGUI().createStringImage(this.getCanvas().getGraphics(), number, this.getForeground(), font);
        }
        return this.stringImage;
    }
}

