/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.networking;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.MessageHandler;
import org.w3c.dom.Element;

public final class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getName());
    private final Connection c;
    private String host;
    private int port;

    public Client(String host, int port, MessageHandler handler) throws IOException {
        this.host = host;
        this.port = port;
        this.c = new Connection(host, port, handler, "FreeColClient:");
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Connection getConnection() {
        return this.c;
    }

    public void setMessageHandler(MessageHandler mh) {
        this.c.setMessageHandler(mh);
    }

    public void disconnect() {
        try {
            this.c.close();
        }
        catch (IOException e) {
            logger.warning("Exception while closing connection: " + e);
        }
    }

    public void send(Element element) {
        try {
            this.c.send(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send: " + element, e);
        }
    }

    public void sendAndWait(Element element) {
        try {
            this.c.sendAndWait(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not sendAndWait: " + element, e);
        }
    }

    public Element ask(Element element) {
        try {
            return this.c.ask(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not ask: " + element, e);
            return null;
        }
    }
}

