/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Settlement
extends FreeColGameObject
implements Location,
Named,
Ownable {
    private static final Logger logger = Logger.getLogger(Settlement.class.getName());
    public static final int FOOD_PER_COLONIST = 200;
    protected Player owner;
    private String name;
    protected Tile tile;
    protected GoodsContainer goodsContainer;
    private FeatureContainer featureContainer;
    private SettlementType type;

    protected Settlement() {
    }

    public Settlement(Game game, Player owner, String name, Tile tile) {
        super(game);
        this.owner = owner;
        this.name = name;
        this.tile = tile;
        this.featureContainer = new FeatureContainer();
        this.setType(owner.getNationType().getSettlementType(false));
        owner.addSettlement(this);
    }

    public Settlement(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public Settlement(Game game, Element e) {
        super(game, e);
    }

    public Settlement(Game game, String id) {
        super(game, id);
    }

    public final SettlementType getType() {
        return this.type;
    }

    public final void setType(SettlementType newType) {
        if (this.type != null) {
            this.featureContainer.remove(this.type.getFeatureContainer());
        }
        this.type = newType;
        if (newType != null) {
            this.featureContainer.add(newType.getFeatureContainer());
        }
    }

    public Set<Modifier> getModifierSet(String key) {
        return this.featureContainer.getModifierSet(key);
    }

    @Override
    public String getNameKey() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public abstract String getNameFor(Player var1);

    public void setName(String newName) {
        this.name = newName;
    }

    public abstract String getImageKey();

    public boolean isCapital() {
        return this.getType().isCapital();
    }

    public void setCapital(boolean isCapital) {
        if (this.isCapital() != isCapital) {
            this.setType(this.owner.getNationType().getSettlementType(isCapital));
        }
    }

    public FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    protected void setFeatureContainer(FeatureContainer container) {
        this.featureContainer = container;
    }

    public int getLineOfSight() {
        return this.getType().getVisibleRadius();
    }

    public abstract Unit getDefendingUnit(Unit var1);

    public abstract RandomRange getPlunderRange(Unit var1);

    public int getPlunder(Unit attacker, Random random) {
        RandomRange range = this.getPlunderRange(attacker);
        return range == null ? 0 : range.getAmount("Plunder " + this.getName(), random, false);
    }

    @Override
    public Tile getTile() {
        return this.tile;
    }

    public void placeSettlement() {
        List<Tile> tiles = this.getGame().getMap().getClaimableTiles(this.owner, this.tile, this.getRadius());
        this.tile.setSettlement(this);
        for (Tile t : tiles) {
            t.changeOwnership(this.owner, this);
        }
        for (Tile t : this.tile.getSurroundingTiles(this.getLineOfSight())) {
            this.owner.setExplored(t);
        }
        this.owner.invalidateCanSeeTiles();
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player player) {
        this.owner = player;
    }

    public void changeOwner(Player newOwner) {
        Player oldOwner = this.owner;
        this.setOwner(newOwner);
        if (oldOwner.hasSettlement(this)) {
            oldOwner.removeSettlement(this);
        }
        if (!newOwner.hasSettlement(this)) {
            newOwner.addSettlement(this);
        }
        List<Unit> units = this.getUnitList();
        units.addAll(this.getTile().getUnitList());
        while (!units.isEmpty()) {
            Unit u = units.remove(0);
            units.addAll(u.getUnitList());
            u.setState(Unit.UnitState.ACTIVE);
            UnitType type = u.getTypeChange(newOwner.isUndead() ? UnitTypeChange.ChangeType.UNDEAD : UnitTypeChange.ChangeType.CAPTURE, newOwner);
            if (type != null) {
                u.setType(type);
            }
            u.setOwner(newOwner);
        }
        for (Tile t : this.getOwnedTiles()) {
            t.changeOwnership(newOwner, this);
        }
        oldOwner.invalidateCanSeeTiles();
        newOwner.invalidateCanSeeTiles();
        if (this.getGame().getFreeColGameObjectListener() != null) {
            this.getGame().getFreeColGameObjectListener().ownerChanged(this, oldOwner, newOwner);
        }
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return this.goodsContainer;
    }

    public void setGoodsContainer(GoodsContainer goodsContainer) {
        this.goodsContainer = goodsContainer;
    }

    public Iterator<Goods> getGoodsIterator() {
        return this.goodsContainer.getGoodsIterator();
    }

    public List<Goods> getCompactGoods() {
        return this.goodsContainer.getCompactGoods();
    }

    public List<Tile> getOwnedTiles() {
        Tile settlementTile = this.getTile();
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        tiles.add(settlementTile);
        for (Tile t : settlementTile.getSurroundingTiles(this.getRadius())) {
            if (t.getOwningSettlement() != this) continue;
            tiles.add(t);
        }
        ArrayList<Tile> todo = new ArrayList<Tile>(tiles);
        while (!todo.isEmpty()) {
            Tile t;
            t = (Tile)todo.remove(0);
            for (Tile s : t.getSurroundingTiles(1)) {
                if (s.getOwningSettlement() != this || tiles.contains(s)) continue;
                tiles.add(s);
                todo.add(s);
            }
        }
        return tiles;
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        if (this.owner != null && this.goodsContainer != null) {
            objects.addAll(this.goodsContainer.disposeList());
            this.goodsContainer = null;
        }
        if (this.owner != null && this.getTile() != null && this.getTile().getSettlement() != null) {
            Tile settlementTile = this.getTile();
            List<Tile> lostTiles = this.getOwnedTiles();
            for (Tile tile : lostTiles) {
                tile.changeOwnership(null, null);
            }
            settlementTile.setSettlement(null);
            Player oldOwner = this.owner;
            this.setOwner(null);
            oldOwner.removeSettlement(this);
            oldOwner.invalidateCanSeeTiles();
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    public int getRadius() {
        return this.getType().getClaimableRadius();
    }

    public abstract int getSoL();

    public abstract boolean propagateAlarm(Player var1, int var2);

    public abstract int getWarehouseCapacity();

    public void removeGoods(GoodsType type, int amount) {
        this.goodsContainer.removeGoods(type, amount);
    }

    public void removeGoods(AbstractGoods goods) {
        this.goodsContainer.removeGoods(goods);
    }

    public void removeGoods(GoodsType type) {
        this.goodsContainer.removeGoods(type);
    }

    public void addGoods(GoodsType type, int amount) {
        this.goodsContainer.addGoods(type, amount);
    }

    public void addGoods(AbstractGoods goods) {
        this.addGoods(goods.getType(), goods.getAmount());
    }

    public int getGoodsCount(GoodsType type) {
        return this.goodsContainer.getGoodsCount(type);
    }

    public abstract int getProductionOf(GoodsType var1);

    public int getConsumptionOf(GoodsType goodsType) {
        int result = 0;
        for (Unit unit : this.getUnitList()) {
            result += unit.getType().getConsumptionOf(goodsType);
        }
        return Math.max(0, result);
    }

    public int getConsumptionOf(List<GoodsType> goodsTypes) {
        int result = 0;
        if (goodsTypes != null) {
            for (GoodsType goodsType : goodsTypes) {
                result += this.getConsumptionOf(goodsType);
            }
        }
        return result;
    }

    public int getFoodConsumption() {
        return this.getConsumptionOf(this.getSpecification().getFoodGoodsTypeList());
    }

    public boolean canBuildEquipment(EquipmentType equipmentType) {
        for (AbstractGoods requiredGoods : equipmentType.getGoodsRequired()) {
            if (this.getGoodsCount(requiredGoods.getType()) >= requiredGoods.getAmount()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        SettlementType settlementType;
        super.readAttributes(in);
        this.setName(in.getAttributeValue(null, "name"));
        this.owner = this.getFreeColGameObject(in, "owner", Player.class);
        this.tile = this.getFreeColGameObject(in, "tile", Tile.class);
        this.featureContainer = new FeatureContainer();
        String typeStr = in.getAttributeValue(null, "settlementType");
        if (typeStr == null) {
            String capital = in.getAttributeValue(null, "isCapital");
            settlementType = this.owner.getNationType().getSettlementType("true".equals(capital));
        } else {
            settlementType = this.owner.getNationType().getSettlementType(typeStr);
        }
        this.setType(settlementType);
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("name", this.getName());
        out.writeAttribute("tile", this.tile.getId());
        out.writeAttribute("settlementType", this.getType().getId());
    }
}

