/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTemplate
extends FreeColObject {
    private TemplateType templateType = TemplateType.KEY;
    private String defaultId;
    private List<String> keys;
    private List<StringTemplate> replacements;

    protected StringTemplate() {
    }

    public StringTemplate(String id, StringTemplate template) {
        this.setId(id);
        this.templateType = template.templateType;
        this.keys = template.keys;
        this.replacements = template.replacements;
    }

    protected StringTemplate(String template, TemplateType templateType) {
        this.setId(template);
        this.templateType = templateType;
        switch (templateType) {
            case TEMPLATE: {
                this.keys = new ArrayList<String>();
            }
            case LABEL: {
                this.replacements = new ArrayList<StringTemplate>();
            }
        }
    }

    public final String getDefaultId() {
        return this.defaultId;
    }

    public StringTemplate setDefaultId(String newDefaultId) {
        this.defaultId = newDefaultId;
        return this;
    }

    public static StringTemplate name(String value) {
        return new StringTemplate(value, TemplateType.NAME);
    }

    public static StringTemplate key(String value) {
        return new StringTemplate(value, TemplateType.KEY);
    }

    public static StringTemplate template(String value) {
        return new StringTemplate(value, TemplateType.TEMPLATE);
    }

    public static StringTemplate label(String value) {
        return new StringTemplate(value, TemplateType.LABEL);
    }

    public final TemplateType getTemplateType() {
        return this.templateType;
    }

    public final List<String> getKeys() {
        return this.keys;
    }

    public final List<StringTemplate> getReplacements() {
        return this.replacements;
    }

    public final StringTemplate getReplacement(String key) {
        for (int index = 0; index < this.keys.size(); ++index) {
            if (!key.equals(this.keys.get(index))) continue;
            if (this.replacements.size() > index) {
                return this.replacements.get(index);
            }
            return null;
        }
        return null;
    }

    public StringTemplate add(String key, String value) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add key-value pair to StringTemplate type " + this.templateType.toString());
        }
        this.keys.add(key);
        this.replacements.add(new StringTemplate(value, TemplateType.KEY));
        return this;
    }

    public StringTemplate add(String value) {
        if (this.templateType != TemplateType.LABEL) {
            throw new IllegalArgumentException("Cannot add a single string to StringTemplate type " + this.templateType.toString());
        }
        this.replacements.add(new StringTemplate(value, TemplateType.KEY));
        return this;
    }

    public StringTemplate addName(String key, String value) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add key-value pair to StringTemplate type " + this.templateType.toString());
        }
        this.keys.add(key);
        this.replacements.add(new StringTemplate(value, TemplateType.NAME));
        return this;
    }

    public StringTemplate addName(String key, FreeColObject object) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add key-value pair to StringTemplate type " + this.templateType.toString());
        }
        this.keys.add(key);
        this.replacements.add(new StringTemplate(object.getId() + ".name", TemplateType.KEY));
        return this;
    }

    public StringTemplate addName(String value) {
        if (this.templateType != TemplateType.LABEL) {
            throw new IllegalArgumentException("Cannot add a single string to StringTemplate type " + this.templateType.toString());
        }
        this.replacements.add(new StringTemplate(value, TemplateType.NAME));
        return this;
    }

    public StringTemplate addAmount(String key, Number amount) {
        this.addName(key, amount.toString());
        return this;
    }

    public StringTemplate addStringTemplate(String key, StringTemplate template) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add a key-template pair to a StringTemplate type " + this.templateType.toString());
        }
        this.keys.add(key);
        this.replacements.add(template);
        return this;
    }

    public StringTemplate addStringTemplate(StringTemplate template) {
        if (this.templateType != TemplateType.LABEL) {
            throw new IllegalArgumentException("Cannot add a StringTemplate to StringTemplate type " + this.templateType.toString());
        }
        this.replacements.add(template);
        return this;
    }

    public String toString() {
        String result = this.templateType.toString() + ": ";
        switch (this.templateType) {
            case LABEL: {
                if (this.replacements == null) {
                    result = result + this.getId();
                    break;
                }
                for (StringTemplate object : this.replacements) {
                    result = result + object + this.getId();
                }
                break;
            }
            case TEMPLATE: {
                result = result + this.getId();
                if (this.defaultId != null) {
                    result = result + " (" + this.defaultId + ")";
                }
                result = result + " [";
                for (int index = 0; index < this.keys.size(); ++index) {
                    result = result + "[" + this.keys.get(index) + ": " + this.replacements.get(index).toString() + "]";
                }
                result = result + "]";
                break;
            }
            case KEY: {
                result = result + this.getId();
                if (this.defaultId == null) break;
                result = result + " (" + this.defaultId + ")";
                break;
            }
            default: {
                result = result + this.getId();
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof StringTemplate)) return false;
        StringTemplate t = (StringTemplate)o;
        if (!this.getId().equals(t.getId()) || this.templateType != t.templateType) {
            return false;
        }
        if (this.defaultId == null) {
            if (t.defaultId != null) {
                return false;
            }
        } else {
            if (t.defaultId == null) {
                return false;
            }
            if (!this.defaultId.equals(t.defaultId)) {
                return false;
            }
        }
        if (this.templateType == TemplateType.LABEL) {
            if (this.replacements.size() != t.replacements.size()) return false;
            for (int index = 0; index < this.replacements.size(); ++index) {
                if (this.replacements.get(index).equals(t.replacements.get(index))) continue;
                return false;
            }
            return true;
        } else {
            if (this.templateType != TemplateType.TEMPLATE) return true;
            if (this.keys.size() != t.keys.size() || this.replacements.size() != t.replacements.size() || this.keys.size() != this.replacements.size()) return false;
            for (int index = 0; index < this.replacements.size(); ++index) {
                if (this.keys.get(index).equals(t.keys.get(index)) && this.replacements.get(index).equals(t.replacements.get(index))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result;
        block4: {
            block3: {
                result = 17;
                result = result * 31 + this.getId().hashCode();
                result = result * 31 + this.templateType.ordinal();
                if (this.defaultId != null) {
                    result = result * 31 + this.defaultId.hashCode();
                }
                if (this.templateType != TemplateType.LABEL) break block3;
                for (StringTemplate replacement : this.replacements) {
                    result = result * 31 + replacement.hashCode();
                }
                break block4;
            }
            if (this.templateType != TemplateType.TEMPLATE) break block4;
            for (int index = 0; index < this.keys.size(); ++index) {
                result = result * 31 + this.keys.get(index).hashCode();
                result = result * 31 + this.replacements.get(index).hashCode();
            }
        }
        return result;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, StringTemplate.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("templateType", this.templateType.toString());
        if (this.defaultId != null) {
            out.writeAttribute("defaultId", this.defaultId);
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.keys != null) {
            for (String key : this.keys) {
                out.writeStartElement("key");
                out.writeAttribute("value", key);
                out.writeEndElement();
            }
        }
        if (this.replacements != null) {
            for (StringTemplate replacement : this.replacements) {
                replacement.toXMLImpl(out);
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        if (id == null) {
            id = in.getAttributeValue(null, "ID");
        }
        this.setId(id);
        String typeString = in.getAttributeValue(null, "templateType");
        this.templateType = typeString == null ? TemplateType.TEMPLATE : Enum.valueOf(TemplateType.class, typeString);
        this.defaultId = in.getAttributeValue(null, "defaultId");
        switch (this.templateType) {
            case TEMPLATE: {
                this.keys = new ArrayList<String>();
            }
            case LABEL: {
                this.replacements = new ArrayList<StringTemplate>();
            }
        }
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
            if ("key".equals(in.getLocalName())) {
                this.keys.add(in.getAttributeValue(null, "value"));
                in.nextTag();
                continue;
            }
            if (StringTemplate.getXMLElementTagName().equals(in.getLocalName())) {
                StringTemplate replacement = new StringTemplate();
                replacement.readFromXMLImpl(in);
                this.replacements.add(replacement);
                continue;
            }
            if ("data".equals(in.getLocalName())) {
                this.readOldFormat(this.readFromArrayElement("data", in, new String[0]));
                continue;
            }
            if (!"strings".equals(in.getLocalName())) continue;
            this.readOldFormat(this.readFromArrayElement("strings", in, new String[0]));
        }
    }

    private void readOldFormat(String[] data) {
        for (int index = 0; index < data.length; index += 2) {
            this.keys.add(data[index]);
            this.replacements.add(new StringTemplate(data[index + 1], TemplateType.NAME));
        }
    }

    public static String getXMLElementTagName() {
        return "stringTemplate";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TemplateType {
        NAME,
        KEY,
        TEMPLATE,
        LABEL;

    }
}

