/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.PlayerExploredTile;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tile
extends FreeColGameObject
implements Location,
Named,
Ownable {
    private static final Logger logger = Logger.getLogger(Tile.class.getName());
    private static final String UNITS_TAG_NAME = "units";
    public static final String UNIT_CHANGE = "TILE_UNIT_CHANGE";
    private TileType type;
    private int x;
    private int y;
    private Player owner;
    private Settlement settlement;
    private TileItemContainer tileItemContainer;
    private List<Unit> units = Collections.emptyList();
    private Settlement owningSettlement;
    private java.util.Map<Player, PlayerExploredTile> playerExploredTiles;
    private Region region;
    private boolean connected = false;
    private Boolean moveToEurope;
    private int style;

    public Tile(Game game, TileType type, int locX, int locY) {
        super(game);
        this.type = type;
        this.x = locX;
        this.y = locY;
        this.owningSettlement = null;
        this.settlement = null;
        if (!this.isViewShared()) {
            this.playerExploredTiles = new HashMap<Player, PlayerExploredTile>();
        }
    }

    public Tile(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        if (!this.isViewShared()) {
            this.playerExploredTiles = new HashMap<Player, PlayerExploredTile>();
        }
        this.readFromXML(in);
    }

    public Tile(Game game, Element e) {
        super(game, e);
        if (!this.isViewShared()) {
            this.playerExploredTiles = new HashMap<Player, PlayerExploredTile>();
        }
        this.readFromXMLElement(e);
    }

    public Tile(Game game, String id) {
        super(game, id);
        if (!this.isViewShared()) {
            this.playerExploredTiles = new HashMap<Player, PlayerExploredTile>();
        }
    }

    public boolean isViewShared() {
        return this.getGame().getViewOwner() != null;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region newRegion) {
        this.region = newRegion;
    }

    public Region getDiscoverableRegion() {
        if (this.region == null) {
            return null;
        }
        return this.region.getDiscoverableRegion();
    }

    @Override
    public String getNameKey() {
        if (this.isViewShared()) {
            if (this.isExplored()) {
                return this.getType().getNameKey();
            }
            return "unexplored";
        }
        Player player = this.getGame().getCurrentPlayer();
        if (player != null) {
            PlayerExploredTile pet = this.getPlayerExploredTile(player);
            return pet != null ? this.getType().getNameKey() : "unexplored";
        }
        logger.warning("player == null");
        return "";
    }

    public StringTemplate getLabel() {
        if (this.tileItemContainer == null) {
            return StringTemplate.key(this.type.getNameKey());
        }
        return StringTemplate.label("/").add(this.type.getNameKey()).addStringTemplate(this.tileItemContainer.getLabel());
    }

    @Override
    public StringTemplate getLocationName() {
        if (this.settlement == null) {
            Settlement nearSettlement = null;
            int radius = 8;
            for (Tile tile : this.getSurroundingTiles(radius)) {
                nearSettlement = tile.getSettlement();
                if (nearSettlement == null) continue;
                return StringTemplate.template("nameLocation").add("%name%", this.type.getNameKey()).addStringTemplate("%location%", StringTemplate.template("nearLocation").addName("%location%", nearSettlement.getName()));
            }
            if (this.region != null && this.region.getName() != null) {
                return StringTemplate.template("nameLocation").add("%name%", this.type.getNameKey()).add("%location%", this.region.getNameKey());
            }
            return StringTemplate.key(this.type.getNameKey());
        }
        return this.settlement.getLocationName();
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return this.settlement == null ? this.getLocationName() : this.settlement.getLocationNameFor(player);
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int newStyle) {
        this.style = newStyle;
    }

    public int getDistanceTo(Tile tile) {
        return this.getPosition().getDistance(tile.getPosition());
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    public TileItemContainer getTileItemContainer() {
        return this.tileItemContainer;
    }

    public void setTileItemContainer(TileItemContainer newTileItemContainer) {
        this.tileItemContainer = newTileItemContainer;
    }

    public List<TileImprovement> getTileImprovements() {
        if (this.tileItemContainer == null) {
            return Collections.emptyList();
        }
        return this.tileItemContainer.getImprovements();
    }

    public List<TileImprovement> getCompletedTileImprovements() {
        if (this.tileItemContainer == null) {
            return Collections.emptyList();
        }
        ArrayList<TileImprovement> result = new ArrayList<TileImprovement>();
        for (TileImprovement improvement : this.tileItemContainer.getImprovements()) {
            if (improvement.getTurnsToComplete() != 0) continue;
            result.add(improvement);
        }
        return result;
    }

    private static boolean betterDefender(Unit defender, float defenderPower, Unit other, float otherPower) {
        return defender == null || otherPower > defenderPower && (!defender.isDefensiveUnit() || other.isDefensiveUnit());
    }

    public Unit getDefendingUnit(Unit attacker) {
        float power;
        CombatModel cm = this.getGame().getCombatModel();
        Unit defender = null;
        float defenderPower = -1.0f;
        for (Unit u : this.units) {
            if (this.isLand() == u.isNaval() || !Tile.betterDefender(defender, defenderPower, u, power = cm.getDefencePower(attacker, u))) continue;
            defender = u;
            defenderPower = power;
        }
        if (!(defender != null && defender.isDefensiveUnit() || this.getSettlement() == null)) {
            Unit u = null;
            try {
                u = this.settlement.getDefendingUnit(attacker);
            }
            catch (IllegalStateException e) {
                logger.warning("Empty settlement: " + this.settlement.getName());
            }
            if (u != null && Tile.betterDefender(defender, defenderPower, u, power = cm.getDefencePower(attacker, u))) {
                defender = u;
                defenderPower = power;
            }
        }
        if (defender == null && this.isLand()) {
            defender = this.getFirstUnit();
        }
        return defender;
    }

    public void disposeAllUnits() {
        for (Unit unit : new ArrayList<Unit>(this.units)) {
            unit.dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.settlement != null) {
            this.settlement.dispose();
        }
        if (this.tileItemContainer != null) {
            this.tileItemContainer.dispose();
        }
        super.dispose();
    }

    public Unit getFirstUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(0);
    }

    public Unit getLastUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }

    public int getTotalUnitCount() {
        int result = 0;
        for (Unit unit : this.units) {
            ++result;
            result += unit.getUnitCount();
        }
        return result;
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.units.contains(locatable);
        }
        if (locatable instanceof TileItem) {
            return this.tileItemContainer != null && this.tileItemContainer.contains((TileItem)locatable);
        }
        logger.warning("Tile.contains(" + locatable + ") Not implemented yet!");
        return false;
    }

    public Map getMap() {
        return this.getGame().getMap();
    }

    public boolean isConnected() {
        return this.connected || this.type != null && this.type.isConnected();
    }

    public void setConnected(boolean newConnected) {
        this.connected = newConnected;
    }

    public Boolean getMoveToEurope() {
        return this.moveToEurope;
    }

    public void setMoveToEurope(Boolean moveToEurope) {
        this.moveToEurope = moveToEurope;
    }

    public boolean canMoveToEurope() {
        return this.getMoveToEurope() != null ? this.getMoveToEurope() : (this.type == null ? false : (this.type.hasAbility("model.ability.moveToEurope") ? true : this.isAdjacentToMapEdge() && this.type.isWater()));
    }

    public boolean isExplored() {
        return this.type != null;
    }

    public boolean isLand() {
        return this.type != null && !this.type.isWater();
    }

    public boolean isForested() {
        return this.type != null && this.type.isForested();
    }

    public boolean hasRiver() {
        return this.tileItemContainer != null && this.getTileItemContainer().getRiver() != null;
    }

    public boolean hasResource() {
        return this.tileItemContainer != null && this.getTileItemContainer().getResource() != null;
    }

    public boolean hasLostCityRumour() {
        return this.tileItemContainer != null && this.getTileItemContainer().getLostCityRumour() != null;
    }

    public boolean hasRoad() {
        return this.tileItemContainer != null && this.getTileItemContainer().getRoad() != null;
    }

    public TileImprovement getRoad() {
        if (this.tileItemContainer == null) {
            return null;
        }
        return this.getTileItemContainer().getRoad();
    }

    public TileType getType() {
        return this.type;
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player owner) {
        this.owner = owner;
    }

    public void setSettlement(Settlement s) {
        this.settlement = s;
        this.owningSettlement = s;
    }

    @Override
    public Settlement getSettlement() {
        return this.settlement;
    }

    @Override
    public Colony getColony() {
        return this.settlement != null && this.settlement instanceof Colony ? (Colony)this.settlement : null;
    }

    public IndianSettlement getIndianSettlement() {
        return this.settlement != null && this.settlement instanceof IndianSettlement ? (IndianSettlement)this.settlement : null;
    }

    public void setOwningSettlement(Settlement owner) {
        this.owningSettlement = owner;
    }

    public Settlement getOwningSettlement() {
        return this.owningSettlement;
    }

    public void changeOwnership(Player player, Settlement settlement) {
        Player old = this.getOwner();
        this.setOwner(player);
        this.setOwningSettlement(settlement);
        this.updatePlayerExploredTiles(old);
    }

    public boolean isInUse() {
        return this.getOwningSettlement() instanceof Colony && ((Colony)this.getOwningSettlement()).isTileInUse(this);
    }

    private void addTileItem(TileItem item) {
        if (this.tileItemContainer == null) {
            this.tileItemContainer = new TileItemContainer(this.getGame(), this);
        }
        this.tileItemContainer.addTileItem(item);
        this.updatePlayerExploredTiles();
    }

    public LostCityRumour getLostCityRumour() {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getLostCityRumour();
    }

    public void addLostCityRumour(LostCityRumour rumour) {
        this.addTileItem(rumour);
    }

    public void removeLostCityRumour() {
        if (this.tileItemContainer != null) {
            this.tileItemContainer.removeAll(LostCityRumour.class);
            this.updatePlayerExploredTiles();
        }
    }

    public TileImprovement getRiver() {
        if (this.tileItemContainer == null) {
            return null;
        }
        return this.tileItemContainer.getRiver();
    }

    public int getRiverStyle() {
        if (this.tileItemContainer == null) {
            return 0;
        }
        TileImprovement river = this.tileItemContainer.getRiver();
        if (river == null) {
            return 0;
        }
        return river.getStyle();
    }

    public Tile getNeighbourOrNull(Map.Direction direction) {
        Map.Position position = this.getPosition();
        if (this.getMap().isValid(position)) {
            Map.Position neighbourPosition = position.getAdjacent(direction);
            return this.getMap().getTile(neighbourPosition);
        }
        return null;
    }

    public boolean hasUnexploredAdjacent() {
        for (Tile t : this.getSurroundingTiles(1)) {
            if (t.isExplored()) continue;
            return true;
        }
        return false;
    }

    public boolean isCoast() {
        for (Map.Direction direction : Map.Direction.values()) {
            Tile otherTile = this.getNeighbourOrNull(direction);
            if (otherTile == null || otherTile.isLand() == this.isLand()) continue;
            return true;
        }
        return false;
    }

    public void addResource(Resource resource) {
        if (resource == null) {
            return;
        }
        this.addTileItem(resource);
    }

    public void setType(TileType t) {
        if (t == null) {
            throw new IllegalArgumentException("Tile type must not be null");
        }
        this.type = t;
        if (this.tileItemContainer != null) {
            this.tileItemContainer.removeIncompatibleImprovements();
        }
        if (!this.isLand()) {
            this.settlement = null;
        }
        this.updatePlayerExploredTiles();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Map.Position getPosition() {
        return new Map.Position(this.x, this.y);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Unit getMovableUnit() {
        Unit childUnit;
        Iterator<Unit> childUnitIterator;
        Unit u;
        Iterator<Unit> unitIterator;
        if (this.getFirstUnit() != null) {
            unitIterator = this.getUnitIterator();
            while (unitIterator.hasNext()) {
                u = unitIterator.next();
                childUnitIterator = u.getUnitIterator();
                while (childUnitIterator.hasNext()) {
                    childUnit = childUnitIterator.next();
                    if (childUnit.getMovesLeft() <= 0 || childUnit.getState() != Unit.UnitState.ACTIVE) continue;
                    return childUnit;
                }
                if (u.getMovesLeft() <= 0 || u.getState() != Unit.UnitState.ACTIVE) continue;
                return u;
            }
        } else {
            return null;
        }
        unitIterator = this.getUnitIterator();
        while (unitIterator.hasNext()) {
            u = unitIterator.next();
            childUnitIterator = u.getUnitIterator();
            while (childUnitIterator.hasNext()) {
                childUnit = childUnitIterator.next();
                if (childUnit.getMovesLeft() <= 0) continue;
                return childUnit;
            }
            if (u.getMovesLeft() <= 0) continue;
            return u;
        }
        return null;
    }

    @Override
    public Tile getTile() {
        return this;
    }

    @Override
    public void add(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (!this.units.contains(locatable)) {
                if (((Object)this.units).equals(Collections.emptyList())) {
                    this.units = new ArrayList<Unit>();
                }
                this.units.add((Unit)locatable);
                ((Unit)locatable).setState(Unit.UnitState.ACTIVE);
            }
        } else if (locatable instanceof TileItem) {
            this.addTileItem((TileItem)locatable);
        } else {
            logger.warning("Tried to add an unrecognized 'Locatable' to a tile.");
        }
    }

    @Override
    public void remove(Locatable locatable) {
        Player old = this.getOwner();
        if (locatable instanceof Unit) {
            this.units.remove(locatable);
        } else if (locatable instanceof TileItem) {
            this.tileItemContainer.addTileItem((TileItem)locatable);
            this.updatePlayerExploredTiles(old);
        } else {
            logger.warning("Tried to remove an unrecognized 'Locatable' from a tile.");
        }
    }

    public void removeUnitNoUpdate(Unit unit) {
        this.units.remove(unit);
    }

    public void addUnitNoUpdate(Unit unit) {
        if (((Object)this.units).equals(Collections.emptyList())) {
            this.units = new ArrayList<Unit>();
        }
        this.units.add(unit);
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    @Override
    public List<Unit> getUnitList() {
        return new ArrayList<Unit>(this.units);
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.units.iterator();
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable instanceof Unit) {
            return true;
        }
        if (locatable instanceof TileImprovement) {
            return ((TileImprovement)locatable).getType().isTileTypeAllowed(this.getType());
        }
        return false;
    }

    public int potential(GoodsType goodsType, UnitType unitType) {
        return Tile.getTileTypePotential(this.getType(), goodsType, this.getTileItemContainer(), unitType);
    }

    public int getMaximumPotential(GoodsType goodsType, UnitType unitType) {
        ArrayList<TileType> tileTypes = new ArrayList<TileType>();
        tileTypes.add(this.getType());
        for (TileImprovementType impType : this.getSpecification().getTileImprovementTypeList()) {
            if (impType.getChange(this.getType()) == null) continue;
            tileTypes.add(impType.getChange(this.getType()));
        }
        int maxProduction = 0;
        for (TileType tileType : tileTypes) {
            float potential = tileType.getProductionOf(goodsType, unitType);
            if (tileType == this.getType() && this.hasResource()) {
                for (TileItem item : this.tileItemContainer.getTileItems()) {
                    if (!(item instanceof Resource)) continue;
                    potential = ((Resource)item).getBonus(goodsType, unitType, (int)potential);
                }
            }
            for (TileImprovementType impType : this.getSpecification().getTileImprovementTypeList()) {
                if (impType.isNatural() || !impType.isTileTypeAllowed(tileType) || impType.getBonus(goodsType) <= 0) continue;
                potential = impType.getProductionModifier(goodsType).applyTo(potential);
            }
            maxProduction = Math.max((int)potential, maxProduction);
        }
        return maxProduction;
    }

    public Set<Modifier> getProductionBonus(GoodsType goodsType, UnitType unitType) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        result.addAll(this.type.getProductionBonus(goodsType));
        if (this.tileItemContainer != null) {
            Resource resource = this.tileItemContainer.getResource();
            if (resource != null) {
                result.addAll(resource.getType().getProductionModifier(goodsType, unitType));
            }
            if (!result.isEmpty()) {
                result.addAll(this.tileItemContainer.getProductionBonus(goodsType, unitType));
            }
        }
        return result;
    }

    public boolean canGetRoad() {
        return this.isLand() && (this.tileItemContainer == null || this.tileItemContainer.getRoad() == null);
    }

    public TileImprovement findTileImprovementType(TileImprovementType type) {
        if (this.tileItemContainer == null) {
            return null;
        }
        return this.tileItemContainer.findTileImprovementType(type);
    }

    public boolean hasImprovement(TileImprovementType type) {
        if (type.changeContainsTarget(this.getType())) {
            return true;
        }
        if (this.tileItemContainer != null) {
            return this.tileItemContainer.hasImprovement(type);
        }
        return false;
    }

    public static int getTileTypePotential(TileType tileType, GoodsType goodsType, TileItemContainer tiContainer, UnitType unitType) {
        if (tileType == null || goodsType == null || !goodsType.isFarmed()) {
            return 0;
        }
        int potential = tileType.getProductionOf(goodsType, unitType);
        if (tiContainer != null) {
            potential = tiContainer.getTotalBonusPotential(goodsType, unitType, potential, false);
        }
        return potential;
    }

    public List<AbstractGoods> getSortedPotential() {
        return this.getSortedPotential(null, null);
    }

    public List<AbstractGoods> getSortedPotential(Unit unit) {
        return this.getSortedPotential(unit.getType(), unit.getOwner());
    }

    public List<AbstractGoods> getSortedPotential(UnitType unitType, Player owner) {
        ArrayList<AbstractGoods> goodsTypeList = new ArrayList<AbstractGoods>();
        if (this.getType() != null) {
            for (GoodsType goodsType : this.getSpecification().getFarmedGoodsTypeList()) {
                int potential = this.potential(goodsType, unitType);
                if (potential <= 0) continue;
                goodsTypeList.add(new AbstractGoods(goodsType, potential));
            }
            if (owner == null || owner.getMarket() == null) {
                Collections.sort(goodsTypeList, new Comparator<AbstractGoods>(){

                    @Override
                    public int compare(AbstractGoods o, AbstractGoods p) {
                        return p.getAmount() - o.getAmount();
                    }
                });
            } else {
                final Market market = owner.getMarket();
                Collections.sort(goodsTypeList, new Comparator<AbstractGoods>(){

                    @Override
                    public int compare(AbstractGoods o, AbstractGoods p) {
                        return market.getSalePrice(p.getType(), p.getAmount()) - market.getSalePrice(o.getType(), o.getAmount());
                    }
                });
            }
        }
        return goodsTypeList;
    }

    public Resource expendResource(GoodsType goodsType, UnitType unitType, Settlement settlement) {
        if (this.hasResource() && this.tileItemContainer.getResource().getQuantity() != -1) {
            Resource resource = this.tileItemContainer.getResource();
            int potential = Tile.getTileTypePotential(this.getType(), goodsType, this.tileItemContainer, unitType);
            for (TileItem item : this.tileItemContainer.getTileItems()) {
                if (!(item instanceof TileImprovement)) continue;
                potential += ((TileImprovement)item).getBonus(goodsType);
            }
            if (resource.useQuantity(goodsType, unitType, potential) == 0) {
                this.tileItemContainer.removeTileItem(resource);
                this.updatePlayerExploredTiles();
                return resource;
            }
        }
        return null;
    }

    public void updatePlayerExploredTiles() {
        this.updatePlayerExploredTiles(null);
    }

    public void updatePlayerExploredTiles(Player oldPlayer) {
        if (this.playerExploredTiles == null || this.getGame().getViewOwner() != null) {
            return;
        }
        for (Player player : this.getGame().getLiveEuropeanPlayers()) {
            if (player != oldPlayer && !player.canSee(this)) continue;
            this.updatePlayerExploredTile(player, false);
        }
    }

    public PlayerExploredTile getPlayerExploredTile(Player player) {
        return this.playerExploredTiles == null ? null : this.playerExploredTiles.get(player);
    }

    public void updatePlayerExploredTile(Player player, boolean full) {
        if (this.playerExploredTiles == null || this.getGame().getViewOwner() != null || !player.isEuropean()) {
            return;
        }
        PlayerExploredTile pet = this.playerExploredTiles.get(player);
        if (pet == null) {
            pet = new PlayerExploredTile(this.getGame(), player, this);
            this.playerExploredTiles.put(player, pet);
        }
        pet.update(full);
    }

    public boolean isExploredBy(Player player) {
        if (!player.isEuropean()) {
            return true;
        }
        if (!this.isExplored()) {
            return false;
        }
        return this.getPlayerExploredTile(player) != null;
    }

    public void setExploredBy(Player player, boolean explored) {
        if (!player.isEuropean()) {
            return;
        }
        if (explored) {
            this.updatePlayerExploredTile(player, false);
        } else if (this.playerExploredTiles != null) {
            this.playerExploredTiles.remove(player);
        }
    }

    public int getWorkAmount(TileImprovementType workType) {
        if (workType == null) {
            return -1;
        }
        if (!workType.isTileAllowed(this)) {
            return -1;
        }
        return this.getType().getBasicWorkTurns() + workType.getAddWorkTurns();
    }

    public Unit getOccupyingUnit() {
        Unit unit = this.getFirstUnit();
        Player owner = null;
        if (this.owningSettlement != null) {
            owner = this.owningSettlement.getOwner();
        }
        if (owner != null && unit != null && unit.getOwner() != owner && owner.getStance(unit.getOwner()) != Player.Stance.ALLIANCE) {
            for (Unit enemyUnit : this.getUnitList()) {
                if (!enemyUnit.isOffensiveUnit() || enemyUnit.getState() != Unit.UnitState.FORTIFIED) continue;
                return enemyUnit;
            }
        }
        return null;
    }

    public boolean isOccupied() {
        return this.getOccupyingUnit() != null;
    }

    public boolean isAdjacent(Tile tile) {
        return tile == null ? false : this.getDistanceTo(tile) == 1;
    }

    public Tile getAdjacentTile(Map.Direction direction) {
        int x = this.getX() + ((this.getY() & 1) != 0 ? direction.getOddDX() : direction.getEvenDX());
        int y = this.getY() + ((this.getY() & 1) != 0 ? direction.getOddDY() : direction.getEvenDY());
        return this.getMap().getTile(x, y);
    }

    public Iterable<Tile> getSurroundingTiles(final int range) {
        return new Iterable<Tile>(){

            @Override
            public Iterator<Tile> iterator() {
                final Map.CircleIterator m = range == 1 ? Tile.this.getMap().getAdjacentIterator(Tile.this.getPosition()) : Tile.this.getMap().getCircleIterator(Tile.this.getPosition(), true, range);
                return new Iterator<Tile>(){

                    @Override
                    public boolean hasNext() {
                        return m.hasNext();
                    }

                    @Override
                    public Tile next() {
                        return Tile.this.getMap().getTile((Map.Position)m.next());
                    }

                    @Override
                    public void remove() {
                        m.remove();
                    }
                };
            }
        };
    }

    public List<Tile> getSurroundingTiles(int rangeMin, int rangeMax) {
        ArrayList<Tile> result = new ArrayList<Tile>();
        if (rangeMin > rangeMax || rangeMin < 0) {
            return result;
        }
        if (rangeMin == 0) {
            result.add(this);
        }
        if (rangeMax > 0) {
            for (Tile t : this.getSurroundingTiles(rangeMax)) {
                result.add(t);
            }
        }
        if (rangeMin > 1) {
            for (Tile t : this.getSurroundingTiles(rangeMin - 1)) {
                result.remove(t);
            }
        }
        return result;
    }

    public boolean isAdjacentToVerticalMapEdge() {
        return this.getNeighbourOrNull(Map.Direction.E) == null || this.getNeighbourOrNull(Map.Direction.W) == null;
    }

    public boolean isAdjacentToMapEdge() {
        for (Map.Direction direction : Map.Direction.values()) {
            if (this.getNeighbourOrNull(direction) != null) continue;
            return true;
        }
        return false;
    }

    public Settlement getNearestSettlement(Player owner, int radius) {
        if (radius <= 0) {
            radius = Integer.MAX_VALUE;
        }
        Map map = this.getGame().getMap();
        Map.CircleIterator iter = map.getCircleIterator(this.getPosition(), true, radius);
        while (iter.hasNext()) {
            Settlement settlement;
            Tile t = map.getTile((Map.Position)iter.next());
            if (t == this || (settlement = t.getSettlement()) == null || owner != null && settlement.getOwner() != owner) continue;
            return settlement;
        }
        return null;
    }

    public Tile getSafeTile(Player player, Random random) {
        if (!(this.getFirstUnit() != null && this.getFirstUnit().getOwner() != player || this.getSettlement() != null && this.getSettlement().getOwner() != player)) {
            return this;
        }
        int r = 1;
        while (true) {
            List<Tile> tiles = this.getSurroundingTiles(r, r);
            if (random != null) {
                Collections.shuffle(tiles, random);
            }
            for (Tile t : tiles) {
                if (t.getFirstUnit() != null && t.getFirstUnit().getOwner() != player || t.getSettlement() != null && t.getSettlement().getOwner() != player) continue;
                return t;
            }
            ++r;
        }
    }

    public void toXMLMinimal(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(Tile.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("x", Integer.toString(this.x));
        out.writeAttribute("y", Integer.toString(this.y));
        out.writeAttribute("style", Integer.toString(this.style));
        if (this.moveToEurope != null) {
            out.writeAttribute("moveToEurope", Boolean.toString(this.moveToEurope));
        }
        out.writeEndElement();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (!showAll) {
            if (toSavedGame) {
                logger.warning("toSavedGame is true, but showAll is false");
            }
            if (player == null) {
                logger.warning("player is null, but showAll is false");
            }
        }
        PlayerExploredTile pet = showAll || toSavedGame ? null : this.getPlayerExploredTile(player);
        out.writeStartElement(Tile.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("x", Integer.toString(this.x));
        out.writeAttribute("y", Integer.toString(this.y));
        out.writeAttribute("style", Integer.toString(this.style));
        this.writeAttribute(out, "type", this.getType());
        this.writeAttribute(out, "region", this.getRegion());
        if (this.moveToEurope != null) {
            out.writeAttribute("moveToEurope", Boolean.toString(this.moveToEurope));
        }
        if (this.connected && !this.type.isConnected()) {
            out.writeAttribute("connected", Boolean.toString(true));
        }
        if (showAll || toSavedGame || player.canSee(this)) {
            if (this.owner != null) {
                out.writeAttribute("owner", this.owner.getId());
            }
            if (this.owningSettlement != null) {
                out.writeAttribute("owningSettlement", this.owningSettlement.getId());
            }
        } else if (pet != null) {
            if (pet.getOwner() != null) {
                out.writeAttribute("owner", pet.getOwner().getId());
            }
            if (pet.getOwningSettlement() != null) {
                out.writeAttribute("owningSettlement", pet.getOwningSettlement().getId());
            }
        }
        if (showAll || toSavedGame || player.canSee(this)) {
            if (this.settlement != null) {
                this.settlement.toXML(out, player, showAll, toSavedGame);
            }
            if ((showAll || toSavedGame || this.settlement == null || this.settlement.getOwner() == player) && !this.units.isEmpty()) {
                out.writeStartElement(UNITS_TAG_NAME);
                for (Unit unit : this.units) {
                    unit.toXML(out, player, showAll, toSavedGame);
                }
                out.writeEndElement();
            }
        } else if (!(pet == null || this.settlement == null || this.settlement != pet.getOwningSettlement() || this.settlement.getOwner() != pet.getOwner() || this.settlement instanceof Colony && pet.getColonyUnitCount() <= 0)) {
            this.settlement.toXML(out, player, showAll, toSavedGame);
        }
        if (this.tileItemContainer != null) {
            this.tileItemContainer.toXML(out, player, showAll, toSavedGame);
        }
        if (toSavedGame && this.playerExploredTiles != null) {
            for (Map.Entry entry : this.playerExploredTiles.entrySet()) {
                ((PlayerExploredTile)entry.getValue()).toXML(out, (Player)entry.getKey(), showAll, toSavedGame);
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        Player settlementOwner;
        Settlement oldSettlement = this.settlement;
        Player oldSettlementOwner = this.settlement == null ? null : this.settlement.getOwner();
        this.setId(in.getAttributeValue(null, "ID"));
        this.x = Integer.parseInt(in.getAttributeValue(null, "x"));
        this.y = Integer.parseInt(in.getAttributeValue(null, "y"));
        this.style = this.getAttribute(in, "style", 0);
        String typeString = in.getAttributeValue(null, "type");
        if (typeString != null) {
            this.type = this.getSpecification().getTileType(typeString);
        }
        boolean needsRumour = Tile.getAttribute(in, LostCityRumour.getXMLElementTagName(), false);
        this.connected = Tile.getAttribute(in, "connected", false);
        this.owner = this.getFreeColGameObject(in, "owner", Player.class, null);
        this.region = this.getFreeColGameObject(in, "region", Region.class, null);
        this.moveToEurope = in.getAttributeValue(null, "moveToEurope") == null ? null : Boolean.valueOf(Tile.getAttribute(in, "moveToEurope", false));
        String owningSettlementStr = in.getAttributeValue(null, "owningSettlement");
        if (owningSettlementStr != null) {
            this.owningSettlement = (Settlement)this.getGame().getFreeColGameObject(owningSettlementStr);
            if (this.owningSettlement == null) {
                if (owningSettlementStr.startsWith(IndianSettlement.getXMLElementTagName())) {
                    this.owningSettlement = new IndianSettlement(this.getGame(), owningSettlementStr);
                } else if (owningSettlementStr.startsWith(Colony.getXMLElementTagName())) {
                    this.owningSettlement = new Colony(this.getGame(), owningSettlementStr);
                } else {
                    logger.warning("Unknown type of Settlement.");
                }
            }
        } else {
            this.owningSettlement = null;
        }
        this.settlement = null;
        this.units.clear();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(Colony.getXMLElementTagName())) {
                this.settlement = this.updateFreeColGameObject(in, Colony.class);
                continue;
            }
            if (in.getLocalName().equals(IndianSettlement.getXMLElementTagName())) {
                this.settlement = this.updateFreeColGameObject(in, IndianSettlement.class);
                continue;
            }
            if (in.getLocalName().equals(UNITS_TAG_NAME)) {
                while (in.nextTag() != 2) {
                    if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                    if (((Object)this.units).equals(Collections.emptyList())) {
                        this.units = new ArrayList<Unit>();
                    }
                    this.units.add(this.updateFreeColGameObject(in, Unit.class));
                }
                continue;
            }
            if (in.getLocalName().equals(TileItemContainer.getXMLElementTagName())) {
                this.tileItemContainer = (TileItemContainer)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (this.tileItemContainer != null) {
                    this.tileItemContainer.readFromXML(in);
                    continue;
                }
                this.tileItemContainer = new TileItemContainer(this.getGame(), this, in);
                continue;
            }
            if (in.getLocalName().equals(PlayerExploredTile.getXMLElementTagName())) {
                Player player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
                PlayerExploredTile pet = this.getPlayerExploredTile(player);
                if (pet == null) {
                    pet = new PlayerExploredTile(this.getGame(), in);
                    this.playerExploredTiles.put(player, pet);
                    continue;
                }
                pet.readFromXML(in);
                continue;
            }
            logger.warning("Unknown tag: " + in.getLocalName() + " [" + in.getAttributeValue(null, "ID") + "] " + " loading tile with ID " + this.getId());
            in.nextTag();
        }
        Player player = settlementOwner = this.settlement == null ? null : this.settlement.getOwner();
        if (this.settlement == null && oldSettlement != null) {
            oldSettlement.setOwner(null);
            oldSettlementOwner.removeSettlement(oldSettlement);
        } else if (this.settlement != null && oldSettlement == null) {
            settlementOwner.addSettlement(this.settlement);
            this.owner = settlementOwner;
        } else if (settlementOwner != oldSettlementOwner) {
            oldSettlement.setOwner(null);
            oldSettlementOwner.removeSettlement(oldSettlement);
            this.settlement.setOwner(settlementOwner);
            settlementOwner.addSettlement(this.settlement);
            this.owner = settlementOwner;
        }
        if (this.getColony() != null && this.getColony().isTileInUse(this)) {
            this.getColony().invalidateCache();
        }
    }

    public void fixup09x() {
        if (this.playerExploredTiles == null) {
            return;
        }
        for (Map.Entry<Player, PlayerExploredTile> e : this.playerExploredTiles.entrySet()) {
            Player p = e.getKey();
            PlayerExploredTile pet = e.getValue();
            if (this.settlement != null) {
                if (pet.getOwner() != null && pet.getOwningSettlement() != null) continue;
                if (p.canSee(this)) {
                    pet.update(false);
                    continue;
                }
                if (this.settlement instanceof Colony) {
                    if (pet.getColonyUnitCount() <= 0) continue;
                    pet.setOwner(this.settlement.getOwner());
                    pet.setOwningSettlement(this.settlement);
                    pet.setColonyStockadeKey(((Colony)this.settlement).getStockadeKey());
                    continue;
                }
                if (!(this.settlement instanceof IndianSettlement)) continue;
                pet.setOwner(this.settlement.getOwner());
                pet.setOwningSettlement(this.settlement);
                continue;
            }
            if (pet.getOwningSettlement() == null || pet.getOwner() != null) continue;
            pet.setOwner(pet.getOwningSettlement().getOwner());
        }
    }

    @Override
    public String toString() {
        return "Tile(" + this.x + "," + this.y + "):" + (this.type == null ? "unknown" : this.type.getId());
    }

    public static String getXMLElementTagName() {
        return "tile";
    }
}

