/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnitLocation
extends FreeColGameObject
implements Location {
    private static final Logger logger = Logger.getLogger(UnitLocation.class.getName());
    private final List<Unit> units = new ArrayList<Unit>();

    protected UnitLocation() {
    }

    public UnitLocation(Game game) {
        super(game);
    }

    public UnitLocation(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public UnitLocation(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public UnitLocation(Game game, String id) {
        super(game, id);
    }

    public int getUnitCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.key(this.getId());
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return this.getLocationName();
    }

    @Override
    public void add(Locatable locatable) {
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            if (this.contains(unit)) {
                return;
            }
            if (this.canAdd(unit)) {
                this.units.add(unit);
            }
        } else if (locatable instanceof Goods) {
            locatable.setLocation(null);
        }
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return this.getNoAddReason(locatable) == NoAddReason.NONE;
    }

    @Override
    public void remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            this.units.remove((Unit)locatable);
        }
    }

    @Override
    public boolean contains(Locatable locatable) {
        return this.units != null && this.units.contains(locatable);
    }

    public NoAddReason getNoAddReason(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (this.units == null || this.units.size() >= this.getUnitCapacity()) {
                return NoAddReason.CAPACITY_EXCEEDED;
            }
            Unit unit = (Unit)locatable;
            if (!this.units.isEmpty() && this.units.get(0).getOwner() != unit.getOwner()) {
                return NoAddReason.OCCUPIED_BY_ENEMY;
            }
            return NoAddReason.NONE;
        }
        return NoAddReason.WRONG_TYPE;
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    @Override
    public List<Unit> getUnitList() {
        return this.units;
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.getUnitList().iterator();
    }

    @Override
    public Tile getTile() {
        return null;
    }

    @Override
    public Colony getColony() {
        return null;
    }

    @Override
    public Settlement getSettlement() {
        return null;
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        out.writeAttribute("ID", this.getId());
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        this.writeChildren(out, null, true, true);
    }

    protected void writeChildren(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (!this.getUnitList().isEmpty()) {
            for (Unit unit : this.getUnitList()) {
                unit.toXML(out, player, showAll, toSavedGame);
            }
        }
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        this.units.clear();
        while (in.nextTag() != 2) {
            if (Unit.getXMLElementTagName().equals(in.getLocalName())) {
                Unit unit = this.updateFreeColGameObject(in, Unit.class);
                if (this.units.contains(unit)) continue;
                this.units.add(unit);
                continue;
            }
            logger.warning("Found unknown child element '" + in.getLocalName() + "'.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoAddReason {
        NONE,
        WRONG_TYPE,
        CAPACITY_EXCEEDED,
        OCCUPIED_BY_ENEMY,
        OWNED_BY_ENEMY;

    }
}

