/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.NetworkReplyObject;
import net.sf.freecol.common.networking.ReceivingThread;
import net.sf.freecol.common.networking.StreamedMessageHandler;
import org.w3c.dom.Element;

public class Connection {
    private static final Logger logger = Logger.getLogger(Connection.class.getName());
    private static final int TIMEOUT = 5000;
    private final OutputStream out;
    private final InputStream in;
    private final Socket socket;
    private final Transformer xmlTransformer;
    private final ReceivingThread thread;
    private final XMLOutputFactory xof = XMLOutputFactory.newInstance();
    private MessageHandler messageHandler;
    private XMLStreamWriter xmlOut = null;
    private int currentQuestionID = -1;
    private String threadName;

    protected Connection() {
        this.out = null;
        this.in = null;
        this.socket = null;
        this.thread = null;
        this.xmlTransformer = null;
    }

    public Connection(String host, int port, MessageHandler messageHandler, String threadName) throws IOException {
        this(Connection.createSocket(host, port), messageHandler, threadName);
    }

    public Connection(Socket socket, MessageHandler messageHandler, String threadName) throws IOException {
        Transformer myTransformer;
        this.messageHandler = messageHandler;
        this.socket = socket;
        this.threadName = threadName;
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            myTransformer = factory.newTransformer();
            myTransformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerException e) {
            logger.log(Level.WARNING, "Failed to install transformer!", e);
            myTransformer = null;
        }
        this.xmlTransformer = myTransformer;
        this.thread = new ReceivingThread(this, this.in, threadName);
        this.thread.start();
    }

    private static Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket();
        InetSocketAddress addr = new InetSocketAddress(host, port);
        socket.connect(addr, 5000);
        return socket;
    }

    public void close() throws IOException {
        Element disconnectElement = DOMMessage.createNewRootElement("disconnect");
        this.send(disconnectElement);
        this.reallyClose();
    }

    public void reallyClose() throws IOException {
        if (this.thread != null) {
            this.thread.askToStop();
        }
        if (this.out != null) {
            this.out.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.in != null) {
            this.in.close();
        }
        logger.info("Connection closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Element element) throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            while (this.currentQuestionID != -1) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Waiting to send element " + element.getTagName() + "...");
                    }
                    this.out.wait();
                }
                catch (InterruptedException e) {}
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Sending element " + element.getTagName() + "...");
            }
            try {
                this.xmlTransformer.transform(new DOMSource(element), new StreamResult(this.out));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to transform and send element!", e);
            }
            this.out.write(10);
            this.out.flush();
            this.out.notifyAll();
        }
    }

    public Element ask(Element element) throws IOException {
        int networkReplyId = this.thread.getNextNetworkReplyId();
        Element questionElement = element.getOwnerDocument().createElement("question");
        questionElement.setAttribute("networkReplyId", Integer.toString(networkReplyId));
        questionElement.appendChild(element);
        if (Thread.currentThread() == this.thread) {
            logger.warning("Attempt to 'wait()' the ReceivingThread for sending " + element.getTagName());
            throw new IOException("Attempt to 'wait()' the ReceivingThread.");
        }
        NetworkReplyObject nro = this.thread.waitForNetworkReply(networkReplyId);
        this.send(questionElement);
        DOMMessage response = (DOMMessage)nro.getResponse();
        if (response == null) {
            return null;
        }
        Element rootElement = response.getDocument().getDocumentElement();
        return (Element)rootElement.getFirstChild();
    }

    public XMLStreamWriter ask() throws IOException {
        this.waitForAndSetNewQuestionId();
        try {
            this.xmlOut = this.xof.createXMLStreamWriter(this.out);
            this.xmlOut.writeStartElement("question");
            this.xmlOut.writeAttribute("networkReplyId", Integer.toString(this.currentQuestionID));
            return this.xmlOut;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to ask question (" + this.currentQuestionID + ")", e);
            this.releaseQuestionId();
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseQuestionId() {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toString() + " released question id " + this.currentQuestionID);
            }
            this.currentQuestionID = -1;
            this.out.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAndSetNewQuestionId() {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            while (this.currentQuestionID != -1) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(this.toString() + " waiting for question id...");
                    }
                    this.out.wait();
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interrupted waiting for question id!", e);
                }
            }
            this.currentQuestionID = this.thread.getNextNetworkReplyId();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toString() + " installed new question id " + this.currentQuestionID);
            }
        }
    }

    public XMLStreamWriter send() throws IOException {
        this.waitForAndSetNewQuestionId();
        try {
            this.xmlOut = this.xof.createXMLStreamWriter(this.out);
            return this.xmlOut;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to send message", e);
            this.releaseQuestionId();
            throw new IOException(e.toString());
        }
    }

    public XMLStreamReader getReply() throws IOException {
        try {
            NetworkReplyObject nro = this.thread.waitForStreamedNetworkReply(this.currentQuestionID);
            this.xmlOut.writeEndElement();
            this.xmlOut.writeCharacters("\n");
            this.xmlOut.flush();
            this.xmlOut.close();
            this.xmlOut = null;
            XMLStreamReader in = (XMLStreamReader)nro.getResponse();
            in.nextTag();
            return in;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.toString() + " failed to get reply (" + this.currentQuestionID + ")", e);
            throw new IOException(e.toString());
        }
    }

    public void endTransmission(XMLStreamReader in) throws IOException {
        try {
            if (in != null) {
                while (in.hasNext()) {
                    in.next();
                }
                this.thread.unlock();
                in.close();
            } else {
                this.xmlOut.writeCharacters("\n");
                this.xmlOut.flush();
                this.xmlOut.close();
                this.xmlOut = null;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.toString() + " failed to end transmission", e);
            throw new IOException(e.toString());
        }
        finally {
            this.releaseQuestionId();
        }
    }

    public void sendAndWait(Element element) throws IOException {
        this.ask(element);
    }

    public void setMessageHandler(MessageHandler mh) {
        this.messageHandler = mh;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void handleAndSendReply(BufferedInputStream in) {
        try {
            in.mark(200);
            XMLInputFactory xif = XMLInputFactory.newInstance();
            XMLStreamReader xmlIn = xif.createXMLStreamReader(in);
            xmlIn.nextTag();
            final String networkReplyId = xmlIn.getAttributeValue(null, "networkReplyId");
            final boolean question = xmlIn.getLocalName().equals("question");
            boolean messagedConsumed = false;
            if (this.messageHandler instanceof StreamedMessageHandler) {
                StreamedMessageHandler smh = (StreamedMessageHandler)((Object)this.messageHandler);
                if (question) {
                    xmlIn.nextTag();
                }
                if (smh.accepts(xmlIn.getLocalName())) {
                    XMLStreamWriter xmlOut = null;
                    if (question) {
                        xmlOut = this.send();
                        xmlOut.writeStartElement("reply");
                        xmlOut.writeAttribute("networkReplyId", networkReplyId);
                    }
                    smh.handle(this, xmlIn, xmlOut);
                    if (question) {
                        xmlOut.writeEndElement();
                        this.endTransmission(null);
                    }
                    this.thread.unlock();
                    messagedConsumed = true;
                }
            }
            if (!messagedConsumed) {
                xmlIn.close();
                in.reset();
                final DOMMessage msg = new DOMMessage(in);
                final Connection connection = this;
                Thread t = new Thread(msg.getType()){

                    public void run() {
                        try {
                            Element element = msg.getDocument().getDocumentElement();
                            if (question) {
                                Element reply = Connection.this.messageHandler.handle(connection, (Element)element.getFirstChild());
                                if (reply == null) {
                                    reply = DOMMessage.createNewRootElement("reply");
                                    reply.setAttribute("networkReplyId", networkReplyId);
                                    logger.finest("reply == null");
                                } else {
                                    Element replyHeader = reply.getOwnerDocument().createElement("reply");
                                    replyHeader.setAttribute("networkReplyId", networkReplyId);
                                    replyHeader.appendChild(reply);
                                    reply = replyHeader;
                                }
                                connection.send(reply);
                            } else {
                                Element reply = Connection.this.messageHandler.handle(connection, element);
                                if (reply != null) {
                                    connection.send(reply);
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Message handler failed!", e);
                            logger.warning(msg.getDocument().getDocumentElement().toString());
                        }
                    }
                };
                t.setName(this.threadName + "MessageHandler:" + t.getName());
                t.start();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to handle and send reply", e);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String toString() {
        return "Connection[" + this.getSocket() + "]";
    }
}

