/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.goal.Goal;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtColonyMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.UnitWanderMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class AIUnit
extends AIObject
implements Transportable {
    private static final Logger logger = Logger.getLogger(AIUnit.class.getName());
    private Unit unit;
    private Mission mission;
    private Goal goal = null;
    private int dynamicPriority;
    private AIUnit transport = null;

    public AIUnit(AIMain aiMain, Unit unit) {
        super(aiMain, unit.getId());
        this.unit = unit;
        this.mission = new UnitWanderHostileMission(aiMain, this);
    }

    public AIUnit(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public AIUnit(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public AIUnit(AIMain aiMain, String id) {
        super(aiMain, id);
        this.unit = (Unit)this.getAIMain().getFreeColGameObject(id);
        if (this.unit == null) {
            logger.warning("Could not find unit: " + id);
        }
        this.uninitialized = true;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void abortWish(Wish w) {
        if (this.mission instanceof WishRealizationMission) {
            this.mission = null;
            this.dynamicPriority = 0;
        }
        if (w.getTransportable() == this) {
            w.dispose();
        }
    }

    public Locatable getTransportLocatable() {
        return this.unit;
    }

    public Location getTransportSource() {
        return this.getUnit().getLocation();
    }

    public Location getTransportDestination() {
        if (this.hasMission()) {
            return this.mission.getTransportDestination();
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.hasMission()) {
            return this.mission.getTransportPriority() + this.dynamicPriority;
        }
        return 0;
    }

    public void increaseTransportPriority() {
        if (this.hasMission()) {
            ++this.dynamicPriority;
        }
    }

    public AIUnit getTransport() {
        return this.transport;
    }

    public void setTransport(AIUnit transport) {
        TransportMission tm;
        AIUnit oldTransport = this.transport;
        this.transport = transport;
        if (oldTransport != null && oldTransport.getMission() != null && oldTransport.getMission() instanceof TransportMission && (tm = (TransportMission)oldTransport.getMission()).isOnTransportList(this)) {
            tm.removeFromTransportList(this);
        }
        if (transport != null && transport.getMission() instanceof TransportMission && !((TransportMission)transport.getMission()).isOnTransportList(this)) {
            ((TransportMission)transport.getMission()).addToTransportList(this);
        }
    }

    public Mission getMission() {
        return this.mission;
    }

    public boolean hasMission() {
        return this.mission != null;
    }

    public void setMission(Mission mission) {
        Mission oldMission = this.mission;
        if (oldMission != null) {
            oldMission.dispose();
        }
        this.mission = mission;
        this.dynamicPriority = 0;
    }

    public void doMission(Connection connection) {
        if (this.getMission() != null && this.getMission().isValid()) {
            this.getMission().doMission(connection);
        }
    }

    public void dispose() {
        this.setMission(null);
        this.setTransport(null);
        super.dispose();
    }

    public String getId() {
        if (this.unit != null) {
            return this.unit.getId();
        }
        logger.warning("unit == null");
        return null;
    }

    public void setGoal(Goal g) {
        this.goal = g;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public AIPlayer getAIOwner() {
        return this.getAIMain().getAIPlayer(this.unit.getOwner());
    }

    public Connection getConnection() {
        return this.getAIOwner().getConnection();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AIUnit.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        if (this.transport != null) {
            if (this.transport.getUnit() == null) {
                logger.warning("transport.getUnit() == null");
            } else if (this.getAIMain().getAIObject(this.transport.getId()) == null) {
                logger.warning("broken reference to transport");
            } else if (this.transport.getMission() != null && this.transport.getMission() instanceof TransportMission && !((TransportMission)this.transport.getMission()).isOnTransportList(this)) {
                logger.warning("We should not be on the transport list.");
            } else {
                out.writeAttribute("transport", this.transport.getUnit().getId());
            }
        }
        if (this.mission != null) {
            this.mission.toXML(out);
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String transportStr;
        String inID = in.getAttributeValue(null, "ID");
        this.unit = (Unit)this.getAIMain().getFreeColGameObject(inID);
        if (this.unit == null) {
            logger.warning("Could not find unit: " + inID);
        }
        if ((transportStr = in.getAttributeValue(null, "transport")) != null) {
            this.transport = (AIUnit)this.getAIMain().getAIObject(transportStr);
            if (this.transport == null) {
                this.transport = new AIUnit(this.getAIMain(), transportStr);
            }
        } else {
            this.transport = null;
        }
        if (in.nextTag() != 2) {
            if (in.getLocalName().equals(UnitWanderHostileMission.getXMLElementTagName())) {
                this.mission = new UnitWanderHostileMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(UnitWanderMission.getXMLElementTagName())) {
                this.mission = new UnitWanderMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(IndianBringGiftMission.getXMLElementTagName())) {
                this.mission = new IndianBringGiftMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(BuildColonyMission.getXMLElementTagName())) {
                this.mission = new BuildColonyMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(IndianDemandMission.getXMLElementTagName())) {
                this.mission = new IndianDemandMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(TransportMission.getXMLElementTagName())) {
                this.mission = new TransportMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(WishRealizationMission.getXMLElementTagName())) {
                this.mission = new WishRealizationMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(UnitSeekAndDestroyMission.getXMLElementTagName())) {
                this.mission = new UnitSeekAndDestroyMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(PioneeringMission.getXMLElementTagName())) {
                this.mission = new PioneeringMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(DefendSettlementMission.getXMLElementTagName())) {
                this.mission = new DefendSettlementMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(WorkInsideColonyMission.getXMLElementTagName())) {
                this.mission = new WorkInsideColonyMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(ScoutingMission.getXMLElementTagName())) {
                this.mission = new ScoutingMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(CashInTreasureTrainMission.getXMLElementTagName())) {
                this.mission = new CashInTreasureTrainMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(IdleAtColonyMission.getXMLElementTagName())) {
                this.mission = new IdleAtColonyMission(this.getAIMain(), in);
            } else if (in.getLocalName().equals(PrivateerMission.getXMLElementTagName())) {
                this.mission = new PrivateerMission(this.getAIMain(), in);
            } else {
                logger.warning("Could not find mission-class for: " + in.getLocalName());
                this.mission = new UnitWanderHostileMission(this.getAIMain(), this);
                return;
            }
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "aiUnit";
    }
}

