/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.UnitWanderMission;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewAIPlayer
extends AIObject {
    private static final Logger logger = Logger.getLogger(AIPlayer.class.getName());
    protected HashMap<String, Integer> sessionRegister = new HashMap();
    private ServerPlayer player;
    private ArrayList<AIUnit> aiUnits = new ArrayList();
    private Connection debuggingConnection;

    public NewAIPlayer() {
        super(null);
    }

    public NewAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player.getId());
        this.player = player;
    }

    public NewAIPlayer(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public NewAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public String getId() {
        return this.player.getId();
    }

    public Connection getConnection() {
        if (this.debuggingConnection != null) {
            return this.debuggingConnection;
        }
        return ((DummyConnection)this.player.getConnection()).getOtherConnection();
    }

    public void setDebuggingConnection(Connection debuggingConnection) {
        this.debuggingConnection = debuggingConnection;
    }

    protected void clearAIUnits() {
        this.aiUnits.clear();
    }

    private void createAIUnits() {
        this.clearAIUnits();
        for (Unit u : this.player.getUnits()) {
            AIUnit a = this.getAIUnit(u);
            if (a != null) {
                this.aiUnits.add(a);
                continue;
            }
            logger.warning("Could not find the AIUnit for: " + u + " (" + u.getId() + ")");
        }
    }

    protected List<AIUnit> getAIUnits() {
        if (this.aiUnits.size() == 0) {
            this.createAIUnits();
        }
        return new ArrayList<AIUnit>(this.aiUnits);
    }

    protected Iterator<AIUnit> getAIUnitIterator() {
        if (this.aiUnits.size() == 0) {
            this.createAIUnits();
        }
        return this.aiUnits.iterator();
    }

    protected AIUnit getAIUnit(Unit unit) {
        return this.getAIMain().getAIUnit(unit);
    }

    protected AIColony getAIColony(Colony colony) {
        return this.getAIMain().getAIColony(colony);
    }

    public abstract void startWorking();

    protected void determineStances() {
        logger.finest("Entering method determineStances");
        Player player = this.getPlayer();
        for (Player p : this.getGame().getPlayers()) {
            Player.Stance newStance;
            if (p == player || p.isDead() || (newStance = p.getREFPlayer() == player && p.getPlayerType() == Player.PlayerType.REBEL ? Player.Stance.WAR : player.getStance(p).getStanceFromTension(player.getTension(p))) == player.getStance(p)) continue;
            this.getAIMain().getFreeColServer().getInGameController().changeStance(player, newStance, p, true);
        }
    }

    protected void abortInvalidMissions() {
        logger.finest("Entering method abortInvalidMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.getMission() == null || aiUnit.getMission().isValid()) continue;
            aiUnit.setMission(null);
        }
    }

    protected void abortInvalidAndOneTimeMissions() {
        logger.finest("Entering method abortInvalidAndOneTimeMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.getMission() == null || aiUnit.getMission().isValid() && !(aiUnit.getMission() instanceof UnitWanderHostileMission) && !(aiUnit.getMission() instanceof UnitWanderMission)) continue;
            aiUnit.setMission(null);
        }
    }

    protected void doMissions() {
        logger.finest("Entering method doMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (!aiUnit.hasMission() || !aiUnit.getMission().isValid() || aiUnit.getUnit().isOnCarrier()) continue;
            try {
                aiUnit.doMission(this.getConnection());
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                logger.warning(sw.toString());
            }
        }
    }

    public Unit getBestTreasureTrain(Tile tile) {
        Unit bestTreasureTrain = null;
        for (Unit unit : tile.getUnitList()) {
            if (!unit.canCarryTreasure() || bestTreasureTrain != null && bestTreasureTrain.getTreasureAmount() >= unit.getTreasureAmount()) continue;
            bestTreasureTrain = unit;
        }
        return bestTreasureTrain;
    }

    int getUnitSeekAndDestroyMissionValue(Unit unit, Tile newTile, int turns) {
        logger.finest("Entering method getUnitSeekAndDestroyMissionValue");
        Unit defender = newTile.getDefendingUnit(unit);
        if (!this.isTargetValidForSeekAndDestroy(unit, defender)) {
            return Integer.MIN_VALUE;
        }
        int value = 10020;
        CombatModel combatModel = unit.getGame().getCombatModel();
        if (this.getBestTreasureTrain(newTile) != null) {
            value += Math.min(this.getBestTreasureTrain(newTile).getTreasureAmount() / 10, 50);
        }
        if (defender.getType().getOffence() > 0 && newTile.getSettlement() == null) {
            value = (int)((float)value + (200.0f - combatModel.getDefencePower(unit, defender) * 2.0f - (float)(turns * 50)));
        }
        value = (int)((float)value + (combatModel.getOffencePower(defender, unit) - combatModel.getDefencePower(defender, unit)));
        value -= turns * 10;
        if (!defender.isNaval()) {
            if (defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
                value = (int)((float)value + (10.0f - combatModel.getDefencePower(unit, defender) * 2.0f - (float)(turns * 25)));
            }
            if (newTile.getSettlement() != null) {
                value += 300;
                Iterator<Unit> dp = newTile.getUnitIterator();
                while (dp.hasNext()) {
                    Unit u = dp.next();
                    if (!u.isDefensiveUnit()) continue;
                    if (combatModel.getDefencePower(unit, u) > combatModel.getOffencePower(unit, u)) {
                        value = (int)((float)value - 100.0f * (combatModel.getDefencePower(unit, u) - combatModel.getOffencePower(unit, u)));
                        continue;
                    }
                    value = (int)((float)value - combatModel.getDefencePower(unit, u));
                }
            }
        }
        return Math.max(0, value);
    }

    boolean isTargetValidForSeekAndDestroy(Unit attacker, Unit defender) {
        boolean notAtWar;
        Player defenderPlayer;
        if (defender == null) {
            return false;
        }
        boolean attackerInLand = true;
        if (attacker.getTile() != null) {
            attackerInLand = attacker.getTile().isLand();
        }
        boolean defenderInLand = true;
        if (defender.getTile() != null) {
            defenderInLand = defender.getTile().isLand();
        }
        if (attackerInLand != defenderInLand) {
            return false;
        }
        if (attacker.isNaval() != defender.isNaval()) {
            return false;
        }
        Player attackerPlayer = attacker.getOwner();
        if (attackerPlayer == (defenderPlayer = defender.getOwner())) {
            return false;
        }
        boolean bl = notAtWar = !attackerPlayer.atWarWith(defenderPlayer);
        if (attackerPlayer.isEuropean() && notAtWar) {
            return false;
        }
        if (attackerPlayer.isIndian()) {
            boolean inFriendlyMood;
            boolean bl2 = inFriendlyMood = attackerPlayer.getTension(defenderPlayer).getLevel().compareTo(Tension.Level.CONTENT) >= 0;
            if (notAtWar && inFriendlyMood) {
                return false;
            }
        }
        return true;
    }

    public void registerSellGoods(Goods goods) {
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + goods.getLocation().getId();
        this.sessionRegister.put(goldKey, null);
    }

    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method buyProposition");
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        Integer registered = this.sessionRegister.get(goldKey);
        if (registered == null) {
            int price = ((IndianSettlement)settlement).getPriceToSell(goods) + this.player.getTension(unit.getOwner()).getValue();
            this.sessionRegister.put(goldKey, new Integer(price));
            return price;
        }
        int price = registered;
        if (price < 0 || price == gold) {
            return price;
        }
        if (gold < price * 9 / 10) {
            logger.warning("Cheating attempt: sending a offer too low");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (this.getAIRandom().nextInt(3 + haggling) <= 3) {
            this.sessionRegister.put(goldKey, new Integer(gold));
            this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
            return gold;
        }
        this.sessionRegister.put(goldKey, new Integer(-1));
        return -1;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(NewAIPlayer.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.player = (ServerPlayer)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "ID"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "aiPlayer";
    }
}

