/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class BuildColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(BuildColonyMission.class.getName());
    private Tile target;
    private int colonyValue;
    private boolean doNotGiveUp = false;
    private boolean colonyBuilt = false;

    public BuildColonyMission(AIMain aiMain, AIUnit aiUnit, Tile target, int colonyValue) {
        super(aiMain, aiUnit);
        this.target = target;
        this.colonyValue = colonyValue;
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        if (!this.getUnit().isColonist()) {
            logger.warning("Only colonists can build a new Colony.");
            throw new IllegalArgumentException("Only colonists can build a new Colony.");
        }
    }

    public BuildColonyMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        this.target = null;
        this.colonyValue = -1;
        this.doNotGiveUp = true;
        if (!this.getUnit().isColonist()) {
            logger.warning("Only colonists can build a new Colony.");
            throw new IllegalArgumentException("Only colonists can build a new Colony.");
        }
    }

    public BuildColonyMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public BuildColonyMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        int newValue;
        Unit unit = this.getUnit();
        Player player = unit.getOwner();
        if (!this.isValid()) {
            return;
        }
        if (unit.getTile() == null) {
            return;
        }
        int n = newValue = this.target == null ? -1 : player.getColonyValue(this.target);
        if (newValue <= 0 || newValue < this.colonyValue) {
            if (!this.doNotGiveUp || (this.target = BuildColonyMission.findColonyLocation(this.getUnit())) == null) {
                this.doNotGiveUp = false;
                return;
            }
            this.colonyValue = player.getColonyValue(this.target);
        }
        if (unit.getTile() != null) {
            Map.Direction r;
            if (!(this.target == unit.getTile() || (r = this.moveTowards(this.target)) != null && this.moveButDontAttack(r))) {
                return;
            }
            if (unit.canBuildColony() && this.target == unit.getTile() && unit.getMovesLeft() > 0) {
                if (this.target.getOwner() != null) {
                    if (this.target.getOwner() == player) {
                        Colony colony = (Colony)this.target.getOwningSettlement();
                        if (colony != null && colony.getColonyTile(this.target) != null) {
                            colony.getColonyTile(this.target).relocateWorkers();
                        }
                    } else {
                        int price = player.getLandPrice(this.target);
                        if (price < 0) {
                            this.target = null;
                            return;
                        }
                        if (price > 0 && !player.checkGold(price) && this.getAIRandom().nextInt(4) == 0) {
                            player.modifyGold(price);
                        }
                        if (!AIMessage.askClaimLand(connection, this.target, null, player.checkGold(price) ? price : -1) || this.target.getOwner() != player) {
                            this.target = null;
                            return;
                        }
                    }
                }
                if (AIMessage.askBuildColony(this.getAIUnit(), "") && this.target.getSettlement() != null) {
                    this.colonyBuilt = true;
                    AIColony aiColony = this.getAIMain().getAIColony(this.target.getColony());
                    this.getAIUnit().setMission(new WorkInsideColonyMission(this.getAIMain(), this.getAIUnit(), aiColony));
                } else {
                    logger.warning("Could not build an AI colony on tile " + this.target.getPosition().toString());
                }
            }
        }
    }

    public Tile getTransportDestination() {
        if (this.target == null) {
            return (this.getUnit().isOnCarrier() ? (Unit)this.getUnit().getLocation() : this.getUnit()).getFullEntryLocation();
        }
        if (this.getUnit().isOnCarrier()) {
            return this.target;
        }
        if (this.getUnit().getLocation().getTile() == this.target) {
            return null;
        }
        if (this.getUnit().getTile() == null) {
            return this.target;
        }
        if (this.getUnit().findPath(this.target) == null) {
            return this.target;
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    public static Tile findColonyLocation(Unit unit) {
        Game game = unit.getGame();
        Map map = game.getMap();
        Player player = unit.getOwner();
        Tile startTile = null;
        Unit carrier = null;
        if (unit.isOnCarrier()) {
            carrier = (Unit)unit.getLocation();
            startTile = carrier.getTile();
        } else {
            startTile = unit.getLocation() instanceof Europe ? unit.getFullEntryLocation() : unit.getTile();
        }
        if (startTile == null) {
            logger.warning("findColonyLocation failed, unit " + unit.getId() + " not on the map");
            return null;
        }
        boolean noFail = player.getSettlements().size() == 0;
        boolean gameStart = game.getTurn().getNumber() < 20;
        int maxNumberofTiles = 400;
        int tileCounter = 0;
        Tile bestTile = null;
        float bestValue = 0.0f;
        Map.CircleIterator it = map.getCircleIterator(startTile.getPosition(), true, 12);
        block3: while (it.hasNext() && (++tileCounter < 400 || noFail && bestTile == null && carrier != null)) {
            float value;
            Tile tile = map.getTile((Map.Position)it.next());
            if (gameStart && map.isPolar(tile)) continue;
            switch (player.canClaimToFoundSettlementReason(tile)) {
                case NONE: 
                case NATIVES: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            int val = unit.getOwner().getColonyValue(tile);
            if (val <= 0) continue;
            float len = 1.0f;
            if (tile != startTile) {
                PathNode path;
                PathNode pathNode = path = carrier == null ? map.findPath(unit, startTile, tile) : map.findPath(unit, startTile, tile, carrier);
                if (path == null) continue;
                len += (float)path.getTotalTurns();
            }
            if (!((value = (float)val / len) > bestValue)) continue;
            bestValue = value;
            bestTile = tile;
        }
        logger.finest("findColonyLocation(" + unit.getId() + ") found tile: " + bestTile);
        return bestTile;
    }

    public boolean isValid() {
        return super.isValid() && !this.colonyBuilt && (this.doNotGiveUp || this.target != null && this.target.getSettlement() == null && this.colonyValue <= this.getUnit().getOwner().getColonyValue(this.target));
    }

    public String getDebuggingInfo() {
        String targetName = this.target != null ? this.target.getPosition().toString() : "unassigned";
        return targetName + " " + this.colonyValue + (this.doNotGiveUp ? "!" : "");
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(BuildColonyMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        if (this.target != null) {
            out.writeAttribute("target", this.target.getId());
        }
        out.writeAttribute("doNotGiveUp", Boolean.toString(this.doNotGiveUp));
        out.writeAttribute("colonyBuilt", Boolean.toString(this.colonyBuilt));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        String targetStr = in.getAttributeValue(null, "target");
        this.target = targetStr != null ? (Tile)this.getGame().getFreeColGameObject(targetStr) : null;
        String doNotGiveUpStr = in.getAttributeValue(null, "doNotGiveUp");
        this.doNotGiveUp = doNotGiveUpStr != null ? Boolean.valueOf(doNotGiveUpStr) : false;
        this.colonyBuilt = Boolean.valueOf(in.getAttributeValue(null, "colonyBuilt"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "buildColonyMission";
    }
}

