/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class IndianBringGiftMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IndianBringGiftMission.class.getName());
    private Colony target;
    private boolean completed;

    public IndianBringGiftMission(AIMain aiMain, AIUnit aiUnit, Colony target) {
        super(aiMain, aiUnit);
        this.target = target;
        this.completed = false;
        if (!this.getUnit().getOwner().isIndian() || !this.getUnit().canCarryGoods()) {
            logger.warning("Only an indian which can carry goods can be given the mission: IndianBringGiftMission");
            throw new IllegalArgumentException("Only an indian which can carry goods can be given the mission: IndianBringGiftMission");
        }
    }

    public IndianBringGiftMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public IndianBringGiftMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        if (!this.isValid()) {
            return;
        }
        if (!this.hasGift()) {
            if (this.getUnit().getTile() != this.getUnit().getIndianSettlement().getTile()) {
                Map.Direction r = this.moveTowards(this.getUnit().getIndianSettlement().getTile());
                if (r == null || !this.moveButDontAttack(r)) {
                    return;
                }
            } else {
                IndianSettlement is = this.getUnit().getIndianSettlement();
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                GoodsContainer gc = is.getGoodsContainer();
                for (GoodsType goodsType : this.getAIMain().getGame().getSpecification().getNewWorldGoodsTypeList()) {
                    if (gc.getGoodsCount(goodsType) < 75) continue;
                    goodsList.add(new Goods(this.getGame(), is, goodsType, this.getAIRandom().nextInt(15) + 10));
                }
                if (goodsList.size() == 0) {
                    this.completed = true;
                } else {
                    Goods goods = (Goods)goodsList.get(this.getAIRandom().nextInt(goodsList.size()));
                    AIMessage.askLoadCargo(this.getAIUnit(), goods);
                }
            }
        } else {
            Map.Direction r = this.moveTowards(this.target.getTile());
            if (r != null && this.getUnit().getTile().getNeighbourOrNull(r) == this.target.getTile()) {
                if (AIMessage.askGetTransaction(this.getAIUnit(), this.target) && AIMessage.askDeliverGift(this.getAIUnit(), this.target, this.getUnit().getGoodsIterator().next())) {
                    AIMessage.askCloseTransaction(this.getAIUnit(), this.target);
                    logger.info("IndianBringGift for " + this.getUnit().getId() + " delivered at " + this.target.getName());
                } else {
                    logger.warning("IndianBringGift for " + this.getUnit().getId() + " failed at " + this.target.getName());
                }
                this.completed = true;
            }
        }
        this.moveRandomly(connection);
    }

    private boolean hasGift() {
        return this.getUnit().getSpaceLeft() == 0;
    }

    public boolean isValid() {
        return super.isValid() && !this.completed && this.target != null && !this.target.isDisposed() && this.target.getTile().getColony() == this.target && IndianBringGiftMission.isValidMission(this.getUnit().getOwner(), this.target.getOwner()) && this.getUnit().getIndianSettlement() != null;
    }

    public static boolean isValidMission(Player owner, Player targetPlayer) {
        switch (owner.getStance(targetPlayer)) {
            case UNCONTACTED: 
            case WAR: 
            case CEASE_FIRE: {
                break;
            }
            case PEACE: 
            case ALLIANCE: {
                return owner.getTension(targetPlayer).getLevel().compareTo(Tension.Level.HAPPY) <= 0;
            }
        }
        return false;
    }

    public String getDebuggingInfo() {
        if (!this.hasGift()) {
            return "[" + this.target.getName() + "] Getting gift: " + this.getUnit().getIndianSettlement().getTile().getPosition();
        }
        return "[" + this.target.getName() + "] " + this.getUnit().getGoodsIterator().next().getNameKey();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(IndianBringGiftMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        if (this.target != null) {
            out.writeAttribute("target", this.target.getId());
        }
        out.writeAttribute("completed", Boolean.toString(this.completed));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String unitString = in.getAttributeValue(null, "unit");
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(unitString));
        String targetString = in.getAttributeValue(null, "target");
        this.target = targetString == null ? null : (Colony)this.getGame().getFreeColGameObject(targetString);
        String completedString = in.getAttributeValue(null, "completed");
        if (completedString == null) {
            completedString = in.getAttributeValue(null, "giftDelivered");
        }
        this.completed = Boolean.valueOf(completedString);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "indianBringGiftMission";
    }
}

