/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import net.sf.freecol.common.model.Map;

public class RiverSection {
    private static int[] base = new int[]{1, 3, 9, 27};
    private int[] branch = new int[]{0, 0, 0, 0};
    private int size = 1;
    public Map.Direction direction;
    private Map.Position position;

    public RiverSection(int style) {
        this.decodeStyle(style);
    }

    public RiverSection(Map.Position position, Map.Direction direction) {
        this.position = position;
        this.direction = direction;
        this.setBranch(direction, 1);
    }

    public Map.Position getPosition() {
        return this.position;
    }

    public int getSize() {
        return this.size;
    }

    public void decodeStyle(int style) {
        int tempStyle = style;
        for (int i = base.length - 1; i >= 0; --i) {
            if (tempStyle <= 0) continue;
            this.branch[i] = tempStyle / base[i];
            tempStyle -= this.branch[i] * base[i];
        }
    }

    public int encodeStyle() {
        int style = 0;
        for (int i = 0; i < base.length; ++i) {
            style += base[i] * this.branch[i];
        }
        return style;
    }

    public void setBranch(Map.Direction direction, int size) {
        if (size != 1) {
            size = 2;
        }
        for (int i = 0; i < Map.Direction.longSides.length; ++i) {
            if (Map.Direction.longSides[i] != direction) continue;
            this.branch[i] = size;
            break;
        }
    }

    public int getBranch(Map.Direction direction) {
        for (int i = 0; i < Map.Direction.longSides.length; ++i) {
            if (Map.Direction.longSides[i] != direction) continue;
            return this.branch[i];
        }
        return 0;
    }

    public void removeBranch(Map.Direction direction) {
        this.setBranch(direction, 0);
    }

    public void growBranch(Map.Direction direction, int increment) {
        for (int i = 0; i < Map.Direction.longSides.length; ++i) {
            if (Map.Direction.longSides[i] != direction) continue;
            this.branch[i] = Math.min(2, Math.max(0, this.branch[i] + increment));
            break;
        }
    }

    public void grow() {
        ++this.size;
        this.setBranch(this.direction, 2);
    }
}

