/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import com.ctc.wstx.util.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public final class URLUtil {
    private URLUtil() {
    }

    public static URL urlFromSystemId(String sysId) throws IOException {
        try {
            int ix = sysId.indexOf(58, 0);
            if (ix >= 3 && ix <= 8) {
                return new URL(sysId);
            }
            String absPath = new File(sysId).getAbsolutePath();
            char sep = File.separatorChar;
            if (sep != '/') {
                absPath = absPath.replace(sep, '/');
            }
            if (absPath.length() > 0 && absPath.charAt(0) != '/') {
                absPath = "/" + absPath;
            }
            return new URL("file", "", absPath);
        }
        catch (MalformedURLException e) {
            URLUtil.throwIOException(e, sysId);
            return null;
        }
    }

    public static URL urlFromSystemId(String sysId, URL ctxt) throws IOException {
        if (ctxt == null) {
            return URLUtil.urlFromSystemId(sysId);
        }
        try {
            return new URL(ctxt, sysId);
        }
        catch (MalformedURLException e) {
            URLUtil.throwIOException(e, sysId);
            return null;
        }
    }

    public static URL urlFromCurrentDir() throws MalformedURLException {
        return new File("a").getAbsoluteFile().getParentFile().toURL();
    }

    public static InputStream optimizedStreamFromURL(URL url) throws IOException {
        if ("file".equals(url.getProtocol()) && url.getHost() == null) {
            return new FileInputStream(url.getPath());
        }
        return url.openStream();
    }

    private static void throwIOException(MalformedURLException mex, String sysId) throws IOException {
        IOException ie = new IOException("[resolving systemId '" + sysId + "']: " + mex.toString());
        ExceptionUtil.setInitCause(ie, mex);
        throw ie;
    }
}

