/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DumpCargoDialog
extends FreeColDialog<List<Goods>> {
    private static final Logger logger = Logger.getLogger(DumpCargoDialog.class.getName());
    private static final String CANCEL = "CANCEL";
    private final JLabel header = new JLabel(Messages.message("dumpCargo"));
    private final JButton cancelButton;
    private List<Goods> goodsList;
    private List<JCheckBox> checkBoxes;

    public DumpCargoDialog(Canvas parent, Unit unit) {
        super(parent);
        this.header.setFont(smallHeaderFont);
        this.add(this.header);
        this.cancelButton = new JButton(Messages.message("cancel"));
        this.cancelButton.setActionCommand(CANCEL);
        this.cancelButton.addActionListener(this);
        this.goodsList = unit.getGoodsList();
        this.checkBoxes = new ArrayList<JCheckBox>(this.goodsList.size());
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
        for (Goods goods : this.goodsList) {
            JCheckBox checkBox = new JCheckBox(Messages.message(goods.getLabel(true)), true);
            this.checkBoxes.add(checkBox);
            this.add(checkBox);
        }
        this.add((Component)this.okButton, "newline 20, span, split 2, tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            ArrayList<Goods> dump = new ArrayList<Goods>();
            for (int index = 0; index < this.checkBoxes.size(); ++index) {
                if (!this.checkBoxes.get(index).isSelected()) continue;
                dump.add(this.goodsList.get(index));
            }
            this.setResponse(dump);
        } else {
            this.setResponse(null);
        }
    }
}

