/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Image;
import javax.swing.ImageIcon;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.resources.ResourceManager;

public final class GoodsLabel
extends AbstractGoodsLabel {
    public GoodsLabel(Goods goods, Canvas parent) {
        super(goods, parent);
        this.initializeDisplay();
    }

    private void initializeDisplay() {
        Player player = null;
        Goods goods = this.getGoods();
        Location location = goods.getLocation();
        if (this.getAmount() < 100) {
            this.setPartialChosen(true);
        }
        if (location instanceof Ownable) {
            player = ((Ownable)((Object)location)).getOwner();
        }
        if (player == null || !goods.getType().isStorable() || player.canTrade(goods) || location instanceof Colony && player.getGame().getSpecification().getBoolean("model.option.customIgnoreBoycott") && ((Colony)location).hasAbility("model.ability.export")) {
            this.setToolTipText(Messages.message(goods.getNameKey()));
        } else {
            this.setToolTipText(Messages.message(goods.getLabel(false)));
            this.setIcon(this.getDisabledIcon());
        }
        if (!goods.getType().limitIgnored() && location instanceof Colony && ((Colony)location).getWarehouseCapacity() < goods.getAmount()) {
            this.setForeground(ResourceManager.getColor("goodsLabel.capacityExceeded.color"));
        } else if (location instanceof Colony && goods.getType().isStorable() && ((Colony)location).getExportData(goods.getType()).isExported()) {
            this.setForeground(ResourceManager.getColor("goodsLabel.exported.color"));
        } else if (goods.getAmount() == 0) {
            this.setForeground(ResourceManager.getColor("goodsLabel.zeroAmount.color"));
        } else if (goods.getAmount() < 0) {
            this.setForeground(ResourceManager.getColor("goodsLabel.negativeAmount.color"));
        } else {
            this.setForeground(ResourceManager.getColor("goodsLabel.positiveAmount.color"));
        }
        super.setText(String.valueOf(goods.getAmount()));
    }

    public void setPartialChosen(boolean partialChosen) {
        super.setPartialChosen(partialChosen);
        Image image = this.getCanvas().getImageLibrary().getGoodsImage(this.getType(), partialChosen ? 0.75 : 1.0);
        this.setIcon(new ImageIcon(image));
    }

    public Goods getGoods() {
        return (Goods)super.getGoods();
    }
}

