/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Graphics;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;

public final class MarketLabel
extends AbstractGoodsLabel {
    private static Logger logger = Logger.getLogger(MarketLabel.class.getName());
    private final Market market;

    public MarketLabel(GoodsType type, Market market, Canvas parent) {
        super(new AbstractGoods(type, 100), parent);
        if (market == null) {
            throw new NullPointerException();
        }
        this.market = market;
    }

    public Market getMarket() {
        return this.market;
    }

    public void setAmount(int amount) {
        this.getGoods().setAmount(amount);
    }

    public void paintComponent(Graphics g) {
        Player player = this.market.getGame().getViewOwner();
        String toolTipText = Messages.message(this.getType().getNameKey());
        if (player == null || player.canTrade(this.getType())) {
            this.setEnabled(true);
        } else {
            toolTipText = Messages.message(this.getType().getLabel(false));
            this.setEnabled(false);
        }
        if (FreeCol.isInDebugMode()) {
            toolTipText = toolTipText + " " + this.market.getAmountInMarket(this.getType());
        }
        this.setToolTipText(toolTipText);
        super.setText(Integer.toString(this.market.getPaidForSale(this.getType())) + "/" + Integer.toString(this.market.getCostToBuy(this.getType())));
        super.paintComponent(g);
    }
}

