/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportCargoPanel
extends ReportPanel {
    private List<String> colonyNames;
    private List<String> otherNames;
    private TypeCountMap<UnitType> carriers = new TypeCountMap();
    private Map<String, ArrayList<Unit>> locations;
    int capacity = 0;

    public ReportCargoPanel(Canvas parent) {
        super(parent, Messages.message("reportCargoAction.name"));
        this.gatherData();
        Player player = this.getMyPlayer();
        this.reportPanel.setLayout((LayoutManager)new MigLayout("fillx, wrap 12", "", ""));
        this.reportPanel.add((Component)this.localizedLabel(StringTemplate.template("report.military.forces").addStringTemplate("%nation%", player.getNationName())), "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        ArrayList<AbstractUnit> cargoTypes = new ArrayList<AbstractUnit>();
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!unitType.isAvailableTo(player) || !unitType.canCarryUnits() && !unitType.canCarryGoods()) continue;
            cargoTypes.add(new AbstractUnit(unitType, Unit.Role.DEFAULT, this.carriers.getCount(unitType)));
        }
        for (AbstractUnit unit : cargoTypes) {
            this.reportPanel.add((Component)this.createUnitTypeLabel(unit), "sg");
        }
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx, wrap 40");
        for (String locationName : this.colonyNames) {
            this.handleLocation(locationName, true);
        }
        if (player.getEurope() != null) {
            String europeName = Messages.message(player.getEurope().getNameKey());
            this.handleLocation(europeName, true);
            this.otherNames.remove(europeName);
        }
        Collections.sort(this.otherNames);
        for (String locationName : this.otherNames) {
            this.handleLocation(locationName, false);
        }
        this.revalidate();
        this.repaint();
    }

    private void gatherData() {
        this.locations = new HashMap<String, ArrayList<Unit>>();
        Player player = this.getMyPlayer();
        List<Colony> colonies = this.getSortedColonies();
        this.colonyNames = new ArrayList<String>();
        for (Colony colony : colonies) {
            this.colonyNames.add(colony.getName());
        }
        this.otherNames = new ArrayList<String>();
        if (player.getEurope() != null) {
            this.otherNames.add(Messages.message(player.getEurope().getNameKey()));
        }
        for (Unit unit : player.getUnits()) {
            if (!unit.isCarrier()) continue;
            this.carriers.incrementCount(unit.getType(), 1);
            this.capacity += unit.getType().getSpace();
            String locationName = this.getLocationNameFor(unit);
            ArrayList<Unit> unitList = this.locations.get(locationName);
            if (unitList == null) {
                unitList = new ArrayList();
                this.locations.put(locationName, unitList);
            }
            unitList.add(unit);
            if (this.colonyNames.contains(locationName) || this.otherNames.contains(locationName)) continue;
            this.otherNames.add(locationName);
        }
    }

    private void handleLocation(String location, boolean makeButton) {
        JComponent component;
        List unitList = this.locations.get(location);
        if (makeButton) {
            JButton button = FreeColPanel.getLinkButton(location, null, location);
            button.addActionListener(this);
            component = button;
        } else {
            component = new JLabel(location);
        }
        this.reportPanel.add((Component)component, "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        if (unitList == null) {
            this.reportPanel.add((Component)new JLabel(Messages.message("none")), "sg");
        } else {
            Collections.sort(unitList, ReportPanel.getUnitTypeComparator());
            for (Unit unit : unitList) {
                UnitLabel unitLabel = new UnitLabel(unit, this.getCanvas(), true);
                if (unit.getDestination() != null) {
                    String destination = Messages.message(unit.getDestination().getLocationNameFor(this.getMyPlayer()));
                    unitLabel.setToolTipText("<html>" + unitLabel.getToolTipText() + "<br>" + Messages.message(StringTemplate.template("goingTo").addName("%location%", destination)) + "</html>");
                }
                unitLabel.setSelected(true);
                this.reportPanel.add((Component)unitLabel, "newline, sg");
                for (Goods goods : unit.getGoodsList()) {
                    GoodsLabel goodsLabel = new GoodsLabel(goods, this.getCanvas());
                    this.reportPanel.add(goodsLabel);
                }
                for (Unit unitLoaded : unit.getUnitList()) {
                    UnitLabel unitLoadedLabel = new UnitLabel(unitLoaded, this.getCanvas(), true);
                    this.reportPanel.add(unitLoadedLabel);
                }
            }
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(750, 600);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

