/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.TradeRouteInputDialog;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TradeRouteDialog
extends FreeColDialog<TradeRoute>
implements ActionListener {
    private static final Logger logger = Logger.getLogger(TradeRouteDialog.class.getName());
    private final JButton editRouteButton = new JButton(Messages.message("traderouteDialog.editRoute"));
    private final JButton newRouteButton = new JButton(Messages.message("traderouteDialog.newRoute"));
    private final JButton removeRouteButton = new JButton(Messages.message("traderouteDialog.removeRoute"));
    private final JButton deassignRouteButton = new JButton(Messages.message("traderouteDialog.deassignRoute"));
    private final DefaultListModel listModel = new DefaultListModel();
    private final JList tradeRoutes = new JList(this.listModel);
    private final JScrollPane tradeRouteView = new JScrollPane(this.tradeRoutes);
    private static final Comparator<TradeRoute> tradeRouteComparator = new Comparator<TradeRoute>(){

        @Override
        public int compare(TradeRoute r1, TradeRoute r2) {
            return r1.getName().compareTo(r2.getName());
        }
    };

    public TradeRouteDialog(final Canvas parent, TradeRoute selectedRoute) {
        super(parent);
        this.deassignRouteButton.addActionListener(this);
        this.deassignRouteButton.setToolTipText(Messages.message("traderouteDialog.deassign.tooltip"));
        this.deassignRouteButton.setActionCommand(Action.DEASSIGN.toString());
        TradeRouteDialog.enterPressesWhenFocused(this.deassignRouteButton);
        this.tradeRoutes.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TradeRouteDialog.this.updateButtons();
            }
        });
        this.newRouteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Player player = TradeRouteDialog.this.getMyPlayer();
                TradeRoute newRoute = TradeRouteDialog.this.getController().getNewTradeRoute(player);
                newRoute.setName(Messages.message("traderouteDialog.newRoute"));
                if (parent.showFreeColDialog(new TradeRouteInputDialog(parent, newRoute)).booleanValue()) {
                    TradeRouteDialog.this.listModel.addElement(newRoute);
                    TradeRouteDialog.this.tradeRoutes.setSelectedValue(newRoute, true);
                }
            }
        });
        this.editRouteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                parent.showFreeColDialog(new TradeRouteInputDialog(parent, (TradeRoute)TradeRouteDialog.this.tradeRoutes.getSelectedValue()));
            }
        });
        this.removeRouteButton.addActionListener(this);
        this.removeRouteButton.setActionCommand(Action.DELETE.toString());
        Player player = this.getMyPlayer();
        ArrayList<TradeRoute> theRoutes = new ArrayList<TradeRoute>(player.getTradeRoutes());
        for (TradeRoute tradeRoute : theRoutes) {
            tradeRoute.setCount(0);
        }
        for (Unit u : player.getUnits()) {
            TradeRoute tradeRoute = u.getTradeRoute();
            if (tradeRoute == null) continue;
            tradeRoute.setCount(1 + tradeRoute.getCount());
        }
        Collections.sort(theRoutes, tradeRouteComparator);
        for (TradeRoute route : theRoutes) {
            this.listModel.addElement(route);
        }
        this.tradeRoutes.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
                Component ret = super.getListCellRendererComponent((JList<?>)list, value, index, selected, focus);
                TradeRoute tradeRoute = (TradeRoute)value;
                String name = tradeRoute.getName();
                int n = tradeRoute.getCount();
                if (n > 0) {
                    this.setText(name + "  (" + String.valueOf(n) + ")");
                } else {
                    this.setText(name);
                }
                return ret;
            }
        });
        if (selectedRoute != null) {
            this.tradeRoutes.setSelectedValue(selectedRoute, true);
        }
        this.updateButtons();
        this.setLayout((LayoutManager)new MigLayout("wrap 2", "[fill][fill]"));
        this.add((Component)TradeRouteDialog.getDefaultHeader(Messages.message("traderouteDialog.name")), "span, align center");
        this.add((Component)this.tradeRouteView, "height 360:400, width 250:");
        this.add((Component)this.newRouteButton, "split 4, flowy, growx");
        this.add((Component)this.editRouteButton, "growx");
        this.add((Component)this.removeRouteButton, "growx");
        this.add(this.deassignRouteButton);
        this.add((Component)this.okButton, "newline 20, span, split 2, tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
        this.restoreSavedSize(this.getPreferredSize());
    }

    public void updateButtons() {
        if (this.tradeRoutes.getSelectedIndex() == -1) {
            this.editRouteButton.setEnabled(false);
            this.removeRouteButton.setEnabled(false);
            this.deassignRouteButton.setEnabled(false);
        } else {
            this.editRouteButton.setEnabled(true);
            this.removeRouteButton.setEnabled(true);
            this.deassignRouteButton.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Action action = Enum.valueOf(Action.class, event.getActionCommand());
        Unit unit = this.getCanvas().getGUI().getActiveUnit();
        TradeRoute route = (TradeRoute)this.tradeRoutes.getSelectedValue();
        if (unit != null && route != null) {
            switch (action) {
                case OK: {
                    this.getCanvas().remove(this);
                    ArrayList<TradeRoute> routes = new ArrayList<TradeRoute>();
                    for (int index = 0; index < this.listModel.getSize(); ++index) {
                        routes.add((TradeRoute)this.listModel.getElementAt(index));
                    }
                    this.getController().setTradeRoutes(routes);
                    unit.setTradeRoute(route);
                    this.setResponse(route);
                    return;
                }
                case DEASSIGN: {
                    this.getCanvas().remove(this);
                    this.getController().clearOrders(unit);
                    this.setResponse(route);
                    return;
                }
                case DELETE: {
                    for (Unit u : route.getAssignedUnits()) {
                        this.getController().clearOrders(u);
                    }
                    this.listModel.removeElementAt(this.tradeRoutes.getSelectedIndex());
                    Player player = this.getMyPlayer();
                    player.getTradeRoutes().remove(route);
                    this.getController().setTradeRoutes(player.getTradeRoutes());
                    return;
                }
            }
        }
        this.getCanvas().remove(this);
        this.setResponse(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        OK,
        CANCEL,
        DEASSIGN,
        DELETE;

    }
}

