/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class UnitLabel
extends JLabel
implements ActionListener {
    private static Logger logger = Logger.getLogger(UnitLabel.class.getName());
    private final Unit unit;
    private final Canvas parent;
    private boolean selected;
    private boolean isSmall = false;
    private boolean ignoreLocation;
    private InGameController inGameController;

    public UnitLabel(Unit unit, Canvas parent) {
        this.unit = unit;
        this.parent = parent;
        this.inGameController = parent.getFreeColClient().getInGameController();
        this.selected = false;
        this.setSmall(false);
        this.setIgnoreLocation(false);
        this.updateIcon();
    }

    public UnitLabel(Unit unit, Canvas parent, boolean isSmall) {
        this(unit, parent);
        this.setSmall(isSmall);
        this.setIgnoreLocation(false);
    }

    public UnitLabel(Unit unit, Canvas parent, boolean isSmall, boolean ignoreLocation) {
        this(unit, parent);
        this.setSmall(isSmall);
        this.setIgnoreLocation(ignoreLocation);
    }

    public Canvas getCanvas() {
        return this.parent;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public void setIgnoreLocation(boolean b) {
        this.ignoreLocation = b;
    }

    public void setSmall(boolean isSmall) {
        ImageIcon imageIcon = this.parent.getImageLibrary().getUnitImageIcon(this.unit);
        ImageIcon disabledImageIcon = this.parent.getImageLibrary().getUnitImageIcon(this.unit, true);
        if (isSmall) {
            this.setPreferredSize(null);
            this.setIcon(new ImageIcon(imageIcon.getImage().getScaledInstance(imageIcon.getIconWidth() / 3 * 2, imageIcon.getIconHeight() / 3 * 2, 4)));
            this.setDisabledIcon(new ImageIcon(disabledImageIcon.getImage().getScaledInstance(imageIcon.getIconWidth() / 3 * 2, imageIcon.getIconHeight() / 3 * 2, 4)));
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.isSmall = true;
        } else {
            if (this.unit.getLocation() instanceof ColonyTile) {
                TileType tileType = ((ColonyTile)this.unit.getLocation()).getTile().getType();
                this.setSize(new Dimension(this.parent.getImageLibrary().getTerrainImageWidth(tileType) / 2, imageIcon.getIconHeight()));
            } else {
                this.setPreferredSize(null);
            }
            this.setIcon(imageIcon);
            this.setDisabledIcon(disabledImageIcon);
            if (this.unit.getLocation() instanceof ColonyTile) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            }
            this.isSmall = false;
        }
    }

    public String getDescriptionLabel() {
        return this.getToolTipText();
    }

    public void setDescriptionLabel(String label) {
        this.setToolTipText(label);
    }

    public void paintComponent(Graphics g) {
        if (this.ignoreLocation || this.selected || !this.unit.isCarrier() && this.unit.getState() != Unit.UnitState.SENTRY) {
            this.setEnabled(true);
        } else if (this.unit.getOwner() != this.parent.getFreeColClient().getMyPlayer() && this.unit.getColony() == null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        super.paintComponent(g);
        if (this.ignoreLocation) {
            return;
        }
        if (this.unit.getLocation() instanceof ColonyTile) {
            GoodsType workType = this.unit.getWorkType();
            int production = ((ColonyTile)this.unit.getLocation()).getProductionOf(workType);
            ProductionLabel pl = new ProductionLabel(workType, production, this.getCanvas());
            g.translate(0, 10);
            pl.paintComponent(g);
            g.translate(0, -10);
        } else if (this.getParent() instanceof ColonyPanel.OutsideColonyPanel || this.getParent() instanceof ColonyPanel.InPortPanel || this.getParent() instanceof EuropePanel.InPortPanel || this.getParent() instanceof EuropePanel.DocksPanel || this.getParent().getParent() instanceof ReportPanel) {
            g.drawImage(this.parent.getGUI().getOccupationIndicatorImage(g, this.unit), 0, 0, null);
            if (this.unit.isUnderRepair()) {
                String underRepair = Messages.message(StringTemplate.template("underRepair").addAmount("%turns%", this.unit.getTurnsForRepair()));
                String underRepair1 = underRepair.substring(0, underRepair.indexOf(40)).trim();
                String underRepair2 = underRepair.substring(underRepair.indexOf(40)).trim();
                Font font = ResourceManager.getFont("NormalFont", 14.0f);
                Image repairImage1 = this.parent.getGUI().createStringImage((Graphics2D)g, underRepair1, Color.RED, font);
                Image repairImage2 = this.parent.getGUI().createStringImage((Graphics2D)g, underRepair2, Color.RED, font);
                int textHeight = repairImage1.getHeight(null) + repairImage2.getHeight(null);
                int leftIndent = Math.min(5, Math.min(this.getWidth() - repairImage1.getWidth(null), this.getWidth() - repairImage2.getWidth(null)));
                g.drawImage(repairImage1, leftIndent, (this.getHeight() - textHeight) / 2, null);
                g.drawImage(repairImage2, leftIndent, (this.getHeight() - textHeight) / 2 + repairImage1.getHeight(null), null);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        String commandString = event.getActionCommand();
        String arg = null;
        int index = commandString.indexOf(58);
        if (index > 0) {
            arg = commandString.substring(index + 1);
            commandString = commandString.substring(0, index);
        }
        UnitAction command = Enum.valueOf(UnitAction.class, commandString.toUpperCase());
        switch (command) {
            case ASSIGN: {
                Unit teacher = (Unit)this.unit.getGame().getFreeColGameObject(arg);
                this.inGameController.assignTeacher(this.unit, teacher);
                for (Container uc = this.getParent(); uc != null; uc = uc.getParent()) {
                }
                break;
            }
            case WORK_TILE: {
                GoodsType goodsType = this.parent.getSpecification().getGoodsType(arg);
                this.inGameController.changeWorkType(this.unit, goodsType);
                ColonyTile bestTile = this.unit.getColony().getVacantColonyTileFor(this.unit, false, goodsType);
                if (bestTile == null || bestTile == this.unit.getLocation()) break;
                this.inGameController.work(this.unit, bestTile);
                break;
            }
            case WORK_BUILDING: {
                BuildingType buildingType = this.parent.getSpecification().getBuildingType(arg);
                Building building = this.unit.getColony().getBuilding(buildingType);
                if (building == this.unit.getLocation()) break;
                this.inGameController.work(this.unit, building);
                break;
            }
            case ACTIVATE_UNIT: {
                this.inGameController.changeState(this.unit, Unit.UnitState.ACTIVE);
                this.parent.getGUI().setActiveUnit(this.unit);
                break;
            }
            case FORTIFY: {
                this.inGameController.changeState(this.unit, Unit.UnitState.FORTIFYING);
                break;
            }
            case SENTRY: {
                this.inGameController.changeState(this.unit, Unit.UnitState.SENTRY);
                break;
            }
            case COLOPEDIA: {
                this.getCanvas().showPanel(new ColopediaPanel(this.getCanvas(), null, this.unit.getType()));
                break;
            }
            case LEAVE_TOWN: {
                this.inGameController.putOutsideColony(this.unit);
                break;
            }
            case CLEAR_SPECIALITY: {
                this.inGameController.clearSpeciality(this.unit);
                break;
            }
            case CLEAR_ORDERS: {
                this.inGameController.clearOrders(this.unit);
                break;
            }
            case ASSIGN_TRADE_ROUTE: {
                this.inGameController.assignTradeRoute(this.unit);
            }
        }
        this.updateIcon();
    }

    public void updateIcon() {
        ImageLibrary lib = this.parent.getImageLibrary();
        this.setIcon(lib.getUnitImageIcon(this.unit));
        this.setDisabledIcon(lib.getUnitImageIcon(this.unit, true));
        this.setDescriptionLabel(Messages.message(Messages.getLabel(this.unit)));
        StringTemplate label = this.unit.getEquipmentLabel();
        if (label != null) {
            this.setDescriptionLabel(this.getDescriptionLabel() + " (" + Messages.message(label) + ")");
        }
        this.setSmall(this.isSmall);
        for (Container uc = this.getParent(); uc != null; uc = uc.getParent()) {
            if (uc instanceof ColonyPanel) {
                if (this.unit.getColony() != null) break;
                this.parent.remove(uc);
                this.parent.getFreeColClient().getActionManager().update();
                break;
            }
            if (uc instanceof EuropePanel) break;
        }
    }

    public boolean canUnitBeEquipedWith(JLabel data) {
        if (!this.getUnit().hasAbility("model.ability.canBeEquipped")) {
            return false;
        }
        if (data instanceof GoodsLabel && ((GoodsLabel)data).isToEquip()) {
            return true;
        }
        return data instanceof MarketLabel && ((MarketLabel)data).isToEquip();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnitAction {
        ASSIGN,
        CLEAR_SPECIALITY,
        ACTIVATE_UNIT,
        FORTIFY,
        SENTRY,
        COLOPEDIA,
        LEAVE_TOWN,
        WORK_TILE,
        WORK_BUILDING,
        CLEAR_ORDERS,
        ASSIGN_TRADE_ROUTE;

    }
}

