/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NationType
extends FreeColGameObjectType {
    private SettlementNumber numberOfSettlements = SettlementNumber.AVERAGE;
    private AggressionLevel aggression = AggressionLevel.AVERAGE;
    private List<SettlementType> settlementTypes = new ArrayList<SettlementType>();

    public NationType(String id, Specification specification) {
        super(id, specification);
        this.setModifierIndex(Modifier.NATION_PRODUCTION_INDEX);
    }

    public final List<SettlementType> getSettlementTypes() {
        return this.settlementTypes;
    }

    public SettlementType getCapitalType() {
        return this.getSettlementType(true);
    }

    public SettlementType getSettlementType(boolean isCapital) {
        for (SettlementType settlementType : this.settlementTypes) {
            if (settlementType.isCapital() != isCapital) continue;
            return settlementType;
        }
        String id = "model.settlement." + this.getId().substring(this.getId().lastIndexOf(".") + 1) + (isCapital ? ".capital" : "");
        SettlementType type = new SettlementType(id, this.getSpecification());
        if (isCapital) {
            type.setCapital(true);
            type.setPlunder(new RandomRange(100, 2, 6, 1500));
            type.setGifts(new RandomRange(100, 2, 6, 200));
        } else {
            type.setPlunder(new RandomRange(50, 2, 6, 1000));
            type.setGifts(new RandomRange(50, 2, 6, 100));
        }
        return type;
    }

    public SettlementType getSettlementType(String id) {
        for (SettlementType settlementType : this.settlementTypes) {
            if (!id.equals(settlementType.getId())) continue;
            return settlementType;
        }
        return null;
    }

    public final SettlementNumber getNumberOfSettlements() {
        return this.numberOfSettlements;
    }

    public final void setNumberOfSettlements(SettlementNumber newNumberOfSettlements) {
        this.numberOfSettlements = newNumberOfSettlements;
    }

    public final AggressionLevel getAggression() {
        return this.aggression;
    }

    public final void setAggression(AggressionLevel newAggression) {
        this.aggression = newAggression;
    }

    public abstract boolean isEuropean();

    public abstract boolean isIndian();

    public abstract boolean isREF();

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String extendString = in.getAttributeValue(null, "extends");
        NationType parent = extendString == null ? this : this.getSpecification().getType(extendString, NationType.class);
        String valueString = in.getAttributeValue(null, "number-of-settlements");
        this.numberOfSettlements = valueString == null ? parent.numberOfSettlements : Enum.valueOf(SettlementNumber.class, valueString.toUpperCase(Locale.US));
        valueString = in.getAttributeValue(null, "aggression");
        this.aggression = valueString == null ? parent.aggression : Enum.valueOf(AggressionLevel.class, valueString.toUpperCase(Locale.US));
        if (parent != this) {
            this.getSettlementTypes().addAll(parent.getSettlementTypes());
            this.getFeatureContainer().add(parent.getFeatureContainer());
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String childName = in.getLocalName();
        if ("settlement".equals(childName)) {
            String id = in.getAttributeValue(null, "id");
            SettlementType settlementType = new SettlementType(id, this.getSpecification());
            settlementType.readFromXML(in);
            this.settlementTypes.add(settlementType);
        } else {
            super.readChild(in);
        }
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("number-of-settlements", this.numberOfSettlements.toString().toLowerCase(Locale.US));
        out.writeAttribute("aggression", this.aggression.toString().toLowerCase(Locale.US));
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (SettlementType settlementType : this.settlementTypes) {
            settlementType.toXML(out, "settlement");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AggressionLevel {
        LOW,
        AVERAGE,
        HIGH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SettlementNumber {
        LOW,
        AVERAGE,
        HIGH;

    }
}

