/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeRoute
extends FreeColGameObject
implements Cloneable,
Ownable {
    private static final Logger logger = Logger.getLogger(TradeRoute.class.getName());
    private static final String CARGO_TAG = "cargo";
    private String name;
    private int count;
    private boolean modified = false;
    private Player owner;
    private List<Stop> stops = new ArrayList<Stop>();

    public TradeRoute(Game game, String name, Player player) {
        super(game);
        this.name = name;
        this.owner = player;
        this.count = 0;
    }

    public TradeRoute(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public TradeRoute(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public synchronized void updateFrom(TradeRoute other) {
        this.setName(other.getName());
        this.setCount(other.getCount());
        this.stops.clear();
        for (Stop otherStop : other.getStops()) {
            this.addStop(new Stop(otherStop));
        }
    }

    public final boolean isModified() {
        return this.modified;
    }

    public final void setModified(boolean newModified) {
        this.modified = newModified;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String newName) {
        this.name = newName;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int newCount) {
        this.count = newCount;
    }

    public void addStop(Stop stop) {
        this.stops.add(stop);
    }

    @Override
    public final Player getOwner() {
        return this.owner;
    }

    @Override
    public final void setOwner(Player newOwner) {
        this.owner = newOwner;
    }

    public List<Unit> getAssignedUnits() {
        ArrayList<Unit> list = new ArrayList<Unit>();
        for (Unit unit : this.owner.getUnits()) {
            if (unit.getTradeRoute() != this) continue;
            list.add(unit);
        }
        return list;
    }

    public final List<Stop> getStops() {
        return this.stops;
    }

    public final void setStops(List<Stop> newStops) {
        this.stops = newStops;
    }

    public TradeRoute clone() {
        try {
            TradeRoute copy = (TradeRoute)super.clone();
            copy.replaceStops(this.getStops());
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone should be supported!", e);
        }
    }

    private void replaceStops(List<Stop> otherStops) {
        this.stops = new ArrayList<Stop>();
        for (Stop otherStop : otherStops) {
            this.addStop(new Stop(otherStop));
        }
    }

    public static boolean isStopValid(Unit unit, Stop stop) {
        return TradeRoute.isStopValid(unit.getOwner(), stop);
    }

    public static boolean isStopValid(Player player, Stop stop) {
        return stop == null ? false : stop.isValid();
    }

    public static String getStopXMLElementTagName() {
        return "tradeRouteStop";
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(TradeRoute.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("name", this.getName());
        out.writeAttribute("owner", this.getOwner().getId());
        for (Stop stop : this.stops) {
            out.writeStartElement(TradeRoute.getStopXMLElementTagName());
            out.writeAttribute("location", stop.getLocation().getId());
            for (GoodsType cargoType : stop.getCargo()) {
                out.writeStartElement(CARGO_TAG);
                out.writeAttribute("id", cargoType.getId());
                out.writeEndElement();
            }
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    private Location findLocation(Game game, String id) {
        FreeColGameObject fcgo = game.getFreeColGameObject(id);
        if (fcgo == null) {
            if (id.startsWith(Colony.getXMLElementTagName())) {
                return new Colony(game, id);
            }
            if (id.startsWith(Europe.getXMLElementTagName())) {
                return new Europe(game, id);
            }
            try {
                throw new IllegalStateException("STOP = " + id + " => null");
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return (Location)((Object)fcgo);
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.setName(in.getAttributeValue(null, "name"));
        String ownerID = in.getAttributeValue(null, "owner");
        Game game = this.getGame();
        this.owner = (Player)game.getFreeColGameObject(ownerID);
        if (this.owner == null) {
            this.owner = new Player(game, ownerID);
        }
        this.stops.clear();
        while (in.nextTag() != 2) {
            if (!TradeRoute.getStopXMLElementTagName().equals(in.getLocalName())) continue;
            String locationId = in.getAttributeValue(null, "location");
            Stop stop = new Stop(this.findLocation(game, locationId));
            while (in.nextTag() != 2) {
                if (!in.getLocalName().equals(CARGO_TAG)) continue;
                String id = in.getAttributeValue(null, "id");
                if (id == null) {
                    List<GoodsType> goodsList = this.getSpecification().getGoodsTypeList();
                    for (int cargoIndex : this.readFromArrayElement(CARGO_TAG, in, new int[0])) {
                        stop.addCargo(goodsList.get(cargoIndex));
                    }
                    continue;
                }
                stop.addCargo(this.getSpecification().getGoodsType(id));
                in.nextTag();
            }
            this.stops.add(stop);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static String getXMLElementTagName() {
        return "tradeRoute";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Stop {
        private Location location;
        private List<GoodsType> cargo = new ArrayList<GoodsType>();
        private boolean modified = false;

        public Stop(Location location) {
            this.location = location;
        }

        public Stop(Stop other) {
            this.location = other.location;
            this.cargo = new ArrayList<GoodsType>(other.cargo);
        }

        public boolean isValid() {
            return this.location != null && !((FreeColGameObject)((Object)this.location)).isDisposed() && (!(this.location instanceof Ownable) || ((Ownable)((Object)this.location)).getOwner() == TradeRoute.this.getOwner());
        }

        public final boolean isModified() {
            return this.modified;
        }

        public final void setModified(boolean newModified) {
            this.modified = newModified;
        }

        public final Location getLocation() {
            return this.location;
        }

        public final List<GoodsType> getCargo() {
            return this.cargo;
        }

        public final void setCargo(List<GoodsType> cargo) {
            this.cargo.clear();
            this.cargo.addAll(cargo);
        }

        public void addCargo(GoodsType newCargo) {
            this.cargo.add(newCargo);
        }

        public String toString() {
            return this.isValid() ? this.getLocation().toString() : "invalid stop";
        }
    }
}

