/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.pathfinding;

import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;

class BaseCostDecider
implements CostDecider {
    private int movesLeft;
    private boolean newTurn;

    BaseCostDecider() {
    }

    public int getCost(Unit unit, Tile oldTile, Tile newTile, int movesLeftBefore) {
        this.newTurn = false;
        if (!newTile.isExplored()) {
            return -1;
        }
        boolean consumeMove = false;
        switch (unit.getSimpleMoveType(oldTile, newTile)) {
            case MOVE_HIGH_SEAS: {
                break;
            }
            case ATTACK_UNIT: 
            case MOVE: {
                if (!(unit.getLocation() instanceof Unit)) break;
            }
            case ATTACK_SETTLEMENT: 
            case EXPLORE_LOST_CITY_RUMOUR: 
            case EMBARK: 
            case ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST: 
            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: 
            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: 
            case ENTER_FOREIGN_COLONY_WITH_SCOUT: 
            case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                consumeMove = true;
                break;
            }
            default: {
                return -1;
            }
        }
        int moveCost = unit.getMoveCost(oldTile, newTile, movesLeftBefore);
        if (moveCost <= movesLeftBefore) {
            this.movesLeft = movesLeftBefore - moveCost;
        } else {
            int thisTurnMovesLeft = movesLeftBefore;
            int initialMoves = unit.getInitialMovesLeft();
            int moveCostNextTurn = unit.getMoveCost(oldTile, newTile, initialMoves);
            moveCost = thisTurnMovesLeft + moveCostNextTurn;
            this.movesLeft = initialMoves - moveCostNextTurn;
            this.newTurn = true;
        }
        if (consumeMove) {
            moveCost += this.movesLeft;
            this.movesLeft = 0;
        }
        return moveCost;
    }

    public int getMovesLeft() {
        return this.movesLeft;
    }

    public boolean isNewTurn() {
        return this.newTurn;
    }
}

