/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class EmbarkMessage
extends DOMMessage {
    private String unitId;
    private String carrierId;
    private String directionString;

    public EmbarkMessage(Unit unit, Unit carrier, Map.Direction direction) {
        this.unitId = unit.getId();
        this.carrierId = carrier.getId();
        this.directionString = direction == null ? null : String.valueOf((Object)direction);
    }

    public EmbarkMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.carrierId = element.getAttribute("carrier");
        this.directionString = !element.hasAttribute("direction") ? null : element.getAttribute("direction");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element handle(FreeColServer server, Player player, Connection connection) {
        Map.Direction direction;
        Unit carrier;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            carrier = server.getUnitSafely(this.carrierId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Location sourceLocation = unit.getLocation();
        Tile sourceTile = null;
        Tile destinationTile = null;
        if (this.directionString == null) {
            if (sourceLocation != carrier.getLocation() && (!(sourceLocation instanceof Unit) || ((Unit)sourceLocation).getLocation() != carrier.getLocation()) && (sourceLocation.getTile() == null || sourceLocation.getTile() != carrier.getTile())) return DOMMessage.clientError("Unit " + this.unitId + " at " + (FreeColGameObject)((Object)sourceLocation) + " and carrier " + this.carrierId + " at " + (FreeColGameObject)((Object)carrier.getLocation()) + " are not co-located.");
            Object direction2 = null;
            return server.getInGameController().embarkUnit(serverPlayer, unit, carrier);
        }
        try {
            direction = Enum.valueOf(Map.Direction.class, this.directionString);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        sourceTile = unit.getTile();
        if (sourceTile == null) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        if (unit.getMovesLeft() <= 0) {
            return DOMMessage.clientError("Unit has no moves left: " + this.unitId);
        }
        destinationTile = sourceTile.getNeighbourOrNull(direction);
        if (destinationTile == null) {
            return DOMMessage.clientError("Could not find tile in direction: " + (Object)((Object)direction) + " from unit: " + this.unitId);
        }
        if (carrier.getTile() == destinationTile) return server.getInGameController().embarkUnit(serverPlayer, unit, carrier);
        return DOMMessage.clientError("Carrier: " + this.carrierId + " is not at destination tile: " + destinationTile.toString());
    }

    public Element toXMLElement() {
        Element result = EmbarkMessage.createNewRootElement(EmbarkMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("carrier", this.carrierId);
        if (this.directionString != null) {
            result.setAttribute("direction", this.directionString);
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "embark";
    }
}

