/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MonarchActionMessage
extends DOMMessage {
    private Monarch.MonarchAction action;
    private StringTemplate template;
    private String tax;
    private boolean accepted;

    public MonarchActionMessage(Monarch.MonarchAction action, StringTemplate template) {
        this.action = action;
        this.template = template;
        this.tax = null;
        this.accepted = false;
    }

    public MonarchActionMessage(Game game, Element element) {
        this.action = Enum.valueOf(Monarch.MonarchAction.class, element.getAttribute("action"));
        this.tax = element.getAttribute("tax");
        this.accepted = element.hasAttribute("accepted") ? Boolean.valueOf(element.getAttribute("accepted")) : false;
        NodeList children = element.getChildNodes();
        if (children.getLength() == 1) {
            this.template = StringTemplate.label(" ");
            this.template.readFromXMLElement((Element)children.item(0));
        } else {
            this.template = null;
        }
    }

    public Monarch.MonarchAction getAction() {
        return this.action;
    }

    public StringTemplate getTemplate() {
        return this.template;
    }

    public int getTax() {
        try {
            return Integer.parseInt(this.tax);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setTax(int tax) {
        this.tax = Integer.toString(tax);
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Game game = player.getGame();
        ServerPlayer serverPlayer = server.getPlayer(connection);
        switch (this.action) {
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: {
                return server.getInGameController().monarchRaiseTax(serverPlayer, this.accepted);
            }
            case OFFER_MERCENARIES: {
                return server.getInGameController().monarchOfferMercenaries(serverPlayer, this.accepted);
            }
        }
        return DOMMessage.clientError("Invalid reply to monarch action: " + (Object)((Object)this.action));
    }

    public Element toXMLElement() {
        Element result = MonarchActionMessage.createNewRootElement(MonarchActionMessage.getXMLElementTagName());
        Document doc = result.getOwnerDocument();
        result.setAttribute("action", this.action.toString());
        if (this.tax != null) {
            result.setAttribute("tax", this.tax);
        }
        result.setAttribute("accepted", Boolean.toString(this.accepted));
        result.appendChild(this.template.toXMLElement(null, doc));
        return result;
    }

    public static String getXMLElementTagName() {
        return "monarchAction";
    }
}

