/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class NewLandNameMessage
extends DOMMessage {
    private String unitId;
    private String newLandName;
    private String welcomerId;
    private String campCount;
    private String acceptString;

    public NewLandNameMessage(Unit unit, String newLandName, Player welcomer, int camps, boolean accept) {
        this.unitId = unit.getId();
        this.newLandName = newLandName;
        if (welcomer == null) {
            this.welcomerId = null;
            this.campCount = null;
        } else {
            this.welcomerId = welcomer.getId();
            this.campCount = Integer.toString(camps);
        }
        this.acceptString = Boolean.toString(accept);
    }

    public NewLandNameMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.newLandName = element.getAttribute("newLandName");
        if (element.hasAttribute("welcomer")) {
            this.welcomerId = element.getAttribute("welcomer");
            this.campCount = element.getAttribute("camps");
        } else {
            this.welcomerId = null;
            this.campCount = null;
        }
        this.acceptString = element.getAttribute("accept");
    }

    public Unit getUnit(Game game) {
        FreeColGameObject o = game.getFreeColGameObjectSafely(this.unitId);
        return o instanceof Unit ? (Unit)o : null;
    }

    public String getNewLandName() {
        return this.newLandName;
    }

    public Player getWelcomer(Game game) {
        FreeColGameObject o = game.getFreeColGameObjectSafely(this.welcomerId);
        return o instanceof Player ? (Player)o : null;
    }

    public void setAccept(boolean accept) {
        this.acceptString = Boolean.toString(accept);
    }

    public String getCamps() {
        return this.campCount;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerGame game = server.getGame();
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        if (!tile.isLand()) {
            return DOMMessage.clientError("Unit is not in the new world: " + this.unitId);
        }
        if (this.newLandName == null || this.newLandName.length() == 0) {
            return DOMMessage.clientError("Empty new land name");
        }
        ServerPlayer welcomer = null;
        int camps = 0;
        if (this.welcomerId != null) {
            if (game.getFreeColGameObjectSafely(this.welcomerId) instanceof ServerPlayer) {
                welcomer = (ServerPlayer)game.getFreeColGameObjectSafely(this.welcomerId);
                if (!welcomer.isIndian()) {
                    return DOMMessage.clientError("Not a native player: " + this.welcomerId);
                }
            } else {
                return DOMMessage.clientError("Not a player: " + this.welcomerId);
            }
            boolean foundWelcomer = false;
            for (Tile t : tile.getSurroundingTiles(1)) {
                if (t.getFirstUnit() == null || t.getFirstUnit().getOwner() != welcomer) continue;
                foundWelcomer = true;
                break;
            }
            if (!foundWelcomer) {
                return DOMMessage.clientError("Unit is not next to welcomer.");
            }
            if (tile.getOwner() != welcomer) {
                return DOMMessage.clientError("Welcomer offers unowned tile: " + tile.getId());
            }
            try {
                camps = Integer.parseInt(this.campCount);
            }
            catch (NumberFormatException e) {
                return DOMMessage.clientError("Invalid camp count: " + this.campCount);
            }
        }
        boolean accept = Boolean.valueOf(this.acceptString);
        return server.getInGameController().setNewLandName(serverPlayer, unit, this.newLandName, welcomer, camps, accept);
    }

    public Element toXMLElement() {
        Element result = NewLandNameMessage.createNewRootElement(NewLandNameMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("newLandName", this.newLandName);
        if (this.welcomerId != null) {
            result.setAttribute("welcomer", this.welcomerId);
        }
        if (this.campCount != null) {
            result.setAttribute("camps", this.campCount);
        }
        if (this.acceptString != null) {
            result.setAttribute("accept", this.acceptString);
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "newLandName";
    }
}

