/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class NewRegionNameMessage
extends DOMMessage {
    private String regionId;
    private String unitId;
    private String newRegionName;

    public NewRegionNameMessage(Region region, Unit unit, String newRegionName) {
        this.regionId = region.getId();
        this.unitId = unit.getId();
        this.newRegionName = newRegionName;
    }

    public NewRegionNameMessage(Game game, Element element) {
        this.regionId = element.getAttribute("region");
        this.unitId = element.getAttribute("unit");
        this.newRegionName = element.getAttribute("newRegionName");
    }

    public Region getRegion(Game game) {
        FreeColGameObject o = game.getFreeColGameObjectSafely(this.regionId);
        return o instanceof Region ? (Region)o : null;
    }

    public Unit getUnit(Game game) {
        FreeColGameObject o = game.getFreeColGameObjectSafely(this.unitId);
        return o instanceof Unit ? (Unit)o : null;
    }

    public String getNewRegionName() {
        return this.newRegionName;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        Region region = tile.getDiscoverableRegion();
        if (region == null) {
            return DOMMessage.clientError("No discoverable region for: " + this.unitId);
        }
        if (region.isPacific()) {
            return DOMMessage.clientError("Can not rename the Pacific!");
        }
        if (!region.getId().equals(this.regionId)) {
            return DOMMessage.clientError("Region mismatch, " + region.getId() + " != " + this.regionId);
        }
        return server.getInGameController().setNewRegionName(serverPlayer, unit, region, this.newRegionName);
    }

    public Element toXMLElement() {
        Element result = NewRegionNameMessage.createNewRootElement(NewRegionNameMessage.getXMLElementTagName());
        result.setAttribute("region", this.regionId);
        result.setAttribute("unit", this.unitId);
        result.setAttribute("newRegionName", this.newRegionName);
        return result;
    }

    public static String getXMLElementTagName() {
        return "newRegionName";
    }
}

