/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class PayForBuildingMessage
extends DOMMessage {
    private String colonyId;

    public PayForBuildingMessage(Colony colony) {
        this.colonyId = colony.getId();
    }

    public PayForBuildingMessage(Game game, Element element) {
        this.colonyId = element.getAttribute("colony");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        if (!(game.getFreeColGameObject(this.colonyId) instanceof Colony)) {
            return DOMMessage.clientError("Not a colony: " + this.colonyId);
        }
        Colony colony = (Colony)game.getFreeColGameObject(this.colonyId);
        if (colony.getOwner() != player) {
            return DOMMessage.clientError("Not your colony: " + this.colonyId);
        }
        return server.getInGameController().payForBuilding(serverPlayer, colony);
    }

    public Element toXMLElement() {
        Element result = PayForBuildingMessage.createNewRootElement(PayForBuildingMessage.getXMLElementTagName());
        result.setAttribute("colony", this.colonyId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "payForBuilding";
    }
}

