/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.io.File;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOption
extends AbstractOption<File> {
    private static Logger logger = Logger.getLogger(FileOption.class.getName());
    private File value = null;

    public FileOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXML(in);
    }

    @Override
    public File getValue() {
        return this.value;
    }

    @Override
    public void setValue(File value) {
        File oldValue = this.value;
        this.value = value;
        if (value != oldValue) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, FileOption.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.value != null) {
            out.writeAttribute("value", this.value.getAbsolutePath());
        }
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + FileOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        if (in.getAttributeValue(null, "value") != null && !in.getAttributeValue(null, "value").equals("")) {
            this.setValue(new File(in.getAttributeValue(null, "value")));
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "fileOption";
    }
}

