/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.IntegerOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOption
extends IntegerOption {
    private static Logger logger = Logger.getLogger(SelectOption.class.getName());
    protected boolean localizedLabels = false;
    private Map<Integer, String> itemValues = new LinkedHashMap<Integer, String>();

    public SelectOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXML(in);
    }

    public Map<Integer, String> getItemValues() {
        return this.itemValues;
    }

    public boolean localizeLabels() {
        return this.localizedLabels;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXMLImpl(out, SelectOption.getXMLElementTagName());
    }

    protected void toXMLImpl(XMLStreamWriter out, String tag) throws XMLStreamException {
        out.writeStartElement(tag);
        out.writeAttribute("id", this.getId());
        out.writeAttribute("value", this.getStringValue());
        out.writeAttribute("localizedLabels", Boolean.toString(this.localizedLabels));
        for (Map.Entry<Integer, String> entry : this.itemValues.entrySet()) {
            out.writeStartElement(this.getXMLItemElementTagName());
            out.writeAttribute("value", Integer.toString(entry.getKey()));
            out.writeAttribute("label", entry.getValue());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.localizedLabels = SelectOption.getAttribute(in, "localizedLabels", true);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if (!in.getLocalName().equals(this.getXMLItemElementTagName())) {
            throw new XMLStreamException("Unknown child \"" + in.getLocalName() + "\" in a \"" + SelectOption.getXMLElementTagName() + "\". ");
        }
        String label = in.getAttributeValue(null, "label");
        String itemValue = in.getAttributeValue(null, "value");
        this.itemValues.put(Integer.parseInt(itemValue), label);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "selectOption";
    }

    public String getXMLItemElementTagName() {
        return "selectValue";
    }
}

