/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringOption
extends AbstractOption<String> {
    private static Logger logger = Logger.getLogger(StringOption.class.getName());
    public static final String NONE = "none";
    private String value;
    private boolean addNone;
    private Specification.TypeSelector generateChoices;
    private List<String> choices;

    public StringOption(String id) {
        super(id);
    }

    public StringOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXMLImpl(in);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        String oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        this.setValue(valueString != null ? valueString : defaultValueString);
    }

    public final boolean addNone() {
        return this.addNone;
    }

    public final void setAddNone(boolean newAddNone) {
        this.addNone = newAddNone;
    }

    public final List<String> getChoices() {
        return this.choices;
    }

    public final void setChoices(List<String> newChoices) {
        this.choices = newChoices;
    }

    public final Specification.TypeSelector getGenerateChoices() {
        return this.generateChoices;
    }

    public final void setGenerateChoices(Specification.TypeSelector newGenerateChoices) {
        this.generateChoices = newGenerateChoices;
    }

    public void generateChoices(Specification specification) {
        if (this.generateChoices == null) {
            if (this.choices == null || this.choices.isEmpty()) {
                this.choices = new ArrayList<String>();
                this.choices.add(this.getValue());
            }
        } else {
            List<FreeColGameObjectType> objects = specification.getTypes(this.generateChoices);
            this.choices = new ArrayList<String>(objects.size() + (this.addNone ? 1 : 0));
            if (this.addNone) {
                this.choices.add(NONE);
            }
            for (FreeColGameObjectType object : objects) {
                this.choices.add(object.getId());
            }
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, StringOption.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("value", this.value);
        if (this.generateChoices != null) {
            out.writeAttribute("generate", this.generateChoices.toString());
        }
        if (this.addNone) {
            out.writeAttribute("addNone", Boolean.toString(this.addNone));
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.choices != null && !this.choices.isEmpty()) {
            for (String choice : this.choices) {
                out.writeStartElement("choice");
                out.writeAttribute("value", choice);
                out.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.addNone = StringOption.getAttribute(in, "addNone", false);
        String generate = in.getAttributeValue(null, "generate");
        if (generate != null) {
            this.generateChoices = Specification.TypeSelector.valueOf(generate);
        }
        this.choices = new ArrayList<String>();
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if ("choice".equals(in.getLocalName())) {
            this.choices.add(in.getAttributeValue(null, "value"));
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "stringOption";
    }
}

