/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.sf.freecol.common.resources.Resource;

public class AudioResource
extends Resource {
    private static final Logger logger = Logger.getLogger(AudioResource.class.getName());
    private File file;

    public AudioResource(File file) {
        this.file = file;
    }

    AudioResource(URI resourceLocator) throws Exception {
        super(resourceLocator);
        URL url = resourceLocator.toURL();
        File f = new File(url.getFile());
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            bis.mark(1000);
            bis.skip(1L);
            bis.reset();
            AudioInputStream ais = AudioSystem.getAudioInputStream(bis);
            this.file = f;
            ais.close();
        }
        catch (Exception e) {
            logger.warning("Not an audio file: " + url.getFile() + "\r\nProblem: " + e);
            e.printStackTrace();
            this.file = null;
        }
    }

    public void preload() {
    }

    public File getAudio() {
        return this.file;
    }
}

